<!--start main wrapper-->
<main class="main-wrapper">
    <div class="main-content">

        <div class="row align-items-center">
            <div class="col-md-8 my-2">
                <h3 class="fmon mb-0">Orders</h3>
            </div>
            <!-- <div class="col-md-4 my-2 d-flex justify-content-end">
                <a href="<?= base_url('product/addProduct'); ?>" class="btn setBtn px-4"> Add Product</a>

            </div> -->
        </div>

        <div class="row my-2">
            <div class="col-md-12">
                <div class="orderCard table-responsive p-2">
                    <table class="table  table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Client</th>
                                <th>Address</th>
                                <th>Total Price</th>
                                <th>Order Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php foreach ($orders as $id => $order): ?>

                            <tr>
                                <td><?php echo $order['user']; ?> <?php echo $customerlists['lastName']; ?></td>
                                <td><?php echo output($order['address']['address']); ?></td>
                                <td>AED <?php echo output($order['displayPrice']); ?></td>
                                <td><?php echo output(date('M d, Y', $order['date'] / 1000)); ?></td>
                                <td><?php echo output($order['orderStatus']); ?></td>
                                <td>
                                    <a class="icon" style="text-decoration: none;" href="<?php echo base_url(); ?>product/orderDetails/<?php echo output($id); ?>">
                                        <button class="btn btn-info btn-block mt-2">Details</button>
                                    </a>
                                    <button class="btn btn-danger btn-block mt-2" data-bs-toggle="modal" data-bs-target="#exampleModa2" onclick="showConfirmation('<?php echo output($id); ?>','<?= $customerlists['firstName'] ?>', 'deleteOrder');">Delete</button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>


                </div>
            </div>
        </div>
</main>
<!--end main wrapper-->


<!--start overlay-->
<div class="overlay btn-toggle"></div>
<!--end overlay-->

<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="get" name="cform" action="">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel2"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn"></button>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
function showModal(userid, username) {
    document.getElementById('user-name').innerText = username;
    document.getElementById('user-id').value = userid;
}

function showConfirmation(userid, username, action) {
    let url = "";
    let message = "";
    let btnTitle = "";
    switch (action) {
        case 'deleteOrder':
            url = "<?php echo base_url(); ?>product/deleteOrder/" + userid;
            message = "Are you sure you want to delete this order?";
            btnTitle = "Delete Order";
            break;
        case 'deleteImage':
            url = "<?php echo base_url(); ?>customer/deleteImage/" + userid;
            message = "Are you sure you want to remove profile phot of user '" + username + "'?";
            btnTitle = "Remove Profile Photo";
            break;
        case 'banCustomer':
            url = "<?php echo base_url(); ?>customer/banCustomer/" + userid;
            message = "Are you sure you want to ban user '" + username + "'?";
            btnTitle = "Ban User";
            break;
        case 'unBanCustomer':
            url = "<?php echo base_url(); ?>customer/unBanCustomer/" + userid;
            message = "Are you sure you want to Unbanned user '" + username + "'?";
            btnTitle = "Unban User";
            break;
        case 'suspendCustomer':
            url = "<?php echo base_url(); ?>customer/suspendCustomer/" + userid;
            message = "Are you sure you want to deactivate user '" + username + "'?";
            btnTitle = "Deactivate User";
            break;
        case 'unSuspendCustomer':
            url = "<?php echo base_url(); ?>customer/unSuspendCustomer/" + userid;
            message = "Are you sure you want to activate user '" + username + "'?";
            btnTitle = "Activate User";
            break;
        case 'deleteCustomer':
            url = "<?php echo base_url(); ?>customer/remove/" + userid + "/user";
            message = "Are you sure you want to delete user '" + username + "'?";
            btnTitle = "Delete User";
            break;
        default:
            return false;
    }

    document.getElementById('exampleModalLabel2').innerText = message;
    document.getElementById('submitBtn').innerText = btnTitle;
    document.cform.action = url;
}
</script>