<main class="main-wrapper">
  <div class="main-content">
      <div class="row">
          <div class="col-md-8 my-2">
              <h3 class="fmon">Profile</h3>
          </div>
      </div>
      
      <form class="row my-2" id="profileForm" enctype="multipart/form-data">
          <!-- Profile Image Section -->
          <div class="col-md-12">
              <div class="d-flex justify-content-between align-items-center">
                  <label for="profileImageUpload">
                      <img class="profmage" id="profileImagePreview" 
                           src="<?= $user['u_image'] ?? base_url('assets/images/avatars/01.png') ?>" 
                           alt="Profile Image">
                  </label>
                  <input type="file" id="profileImageUpload" name="profile_image" accept="image/*" style="display: none;">
                  <button type="submit" class="btn setBtn px-5 py-3">Update Profile</button>
              </div>
          </div>

          <!-- Basic Information -->
          <div class="col-md-6 my-2">
              <label class="clabel">Name</label>
              <input class="form-control formInput" type="text" name="name" 
                     value="<?= $user['name'] ?? '' ?>">
          </div>

          <div class="col-md-6 my-2">
              <label class="clabel">Start Date</label>
              <input class="form-control formInput" type="text" name="start_date" 
                     value="<?= $user['startDate'] ?? '' ?>">
          </div>

          <!-- Shop Information -->
          <div class="col-md-6 my-2">
              <label class="clabel">Shop Timing</label>
              <input class="form-control formInput" type="text" name="shop_timing" 
                     value="<?= $user['shopTiming'] ?? '' ?>">
          </div>

          <div class="col-md-6 my-2">
              <label class="clabel">Shop Location</label>
              <input class="form-control formInput" type="text" name="shop_location" 
                     value="<?= $user['shopLocation'] ?? '' ?>">
          </div>

          <!-- Tailor Specific Fields -->
          <div class="col-md-6 my-2">
              <label class="clabel">ETA (Estimated Delivery Time)</label>
              <input class="form-control formInput" type="text" name="eta" 
                     value="<?= $user['eta'] ?? '' ?>" 
                     placeholder="e.g., 3 days">
          </div>

          <div class="col-md-6 my-2">
              <label class="clabel">State</label>
              <input class="form-control formInput" type="text" name="state" 
                     value="<?= $user['state'] ?? '' ?>" 
                     placeholder="e.g., Abu Dhabi">
          </div>

          <!-- Categories Selection -->
          <div class="col-md-12 my-2">
              <label class="clabel">Specializations</label>
              <div class="row">
                  <?php foreach ($categories as $category): ?>
                  <div class="col-md-3">
                      <div class="form-check">
                          <input class="form-check-input" type="checkbox" 
                                 name="categoryIds[]" 
                                 value="<?= $category['id'] ?>"
                                 id="cat_<?= $category['id'] ?>"
                                 <?= in_array($category['id'], $user['categoryId'] ?? []) ? 'checked' : '' ?>>
                          <label class="form-check-label" for="cat_<?= $category['id'] ?>">
                              <?= $category['data']['name'] ?? 'Unnamed Category' ?>
                          </label>
                      </div>
                  </div>
                  <?php endforeach; ?>
              </div>
          </div>

          <!-- Tailor Type Selection -->
          <div class="col-md-6 my-2">
              <label class="clabel">Tailor Type</label>
              <select class="form-control formInput" name="tailor_type">
                  <option value="">Select Service Type</option>
                  <option value="Men's Tailor" <?= ($user['tailorType'] ?? '') === "Men's Tailor" ? 'selected' : '' ?>>Men's Tailor</option>
                  <option value="Women's Tailor" <?= ($user['tailorType'] ?? '') === "Women's Tailor" ? 'selected' : '' ?>>Women's Tailor</option>
                  <option value="Both Men's & Women's Tailor" <?= ($user['tailorType'] ?? '') === "Both Men's & Women's Tailor" ? 'selected' : '' ?>>Both</option>
              </select>
          </div>
      </form>
  </div>
</main>

<script>
document.getElementById("profileImageUpload").addEventListener("change", function(e) {
    const reader = new FileReader();
    reader.onload = () => document.getElementById("profileImagePreview").src = reader.result;
    reader.readAsDataURL(e.target.files[0]);
});

document.getElementById("profileForm").addEventListener("submit", function(e) {
    e.preventDefault();
    const formData = new FormData(this);
    
    document.querySelector(".loader-overlay").style.display = "block";

    fetch("<?= base_url('dashboard/updateProfile') ?>", {
        method: "POST",
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        document.querySelector(".loader-overlay").style.display = "none";
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: data.message,
                confirmButtonColor: '#FFD700'
            }).then(() => location.reload());
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: data.message,
                confirmButtonColor: '#FFD700'
            });
        }
    })
    .catch(error => {
        console.error("Error:", error);
        document.querySelector(".loader-overlay").style.display = "none";
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Update failed. Please try again.',
            confirmButtonColor: '#FFD700'
        });
    });
});
</script>