<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Naseej - Sign Up</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>
<body class="bg-main pt-5 pb-5">
    <div class="container-fluid mt-5 pt-5 mb-5 pb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-12 my-2">
                    <?php if($this->session->flashdata('warningmessage')) { ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <?= $this->session->flashdata('warningmessage') ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php } ?>
                    
                    <img class="d-block mx-auto" src="<?= base_url(); ?>assets/images/logo.png" alt="Logo" width="200">
                    
                    <form action="<?= base_url('login/signup_action') ?>" method="post" enctype="multipart/form-data">
                        <div class="row mb-2 mt-5">
                            <!-- Name and Email -->
                            <div class="row justify-content-center">
                                <div class="col-md-6 my-2">
                                    <input class="form-control formInp py-3" type="text" 
                                           name="name" placeholder="Name" required
                                           value="<?= set_value('name', $this->session->flashdata('form_data')['name'] ?? '') ?>">
                                </div>
                                <div class="col-md-6 my-2">
                                    <input class="form-control formInp py-3" type="email" 
                                           name="email" placeholder="Email" required
                                           value="<?= set_value('email', $this->session->flashdata('form_data')['email'] ?? '') ?>">
                                </div>
                            </div>

                            <!-- Start Date and Shop Timing -->
                            <div class="row justify-content-center">
                                <div class="col-md-6 my-2">
                                    <input class="form-control formInp py-3" type="date" 
                                           name="start_date" required
                                           value="<?= set_value('start_date', $this->session->flashdata('form_data')['start_date'] ?? '') ?>">
                                </div>
                                <div class="col-md-6 my-2">
                                    <input class="form-control formInp py-3" type="text" 
                                           name="shop_timing" placeholder="Shop Timing (e.g., 9 AM - 6 PM)" required
                                           value="<?= set_value('shop_timing', $this->session->flashdata('form_data')['shop_timing'] ?? '') ?>">
                                </div>
                            </div>

                            <!-- Shop Location and Opening Number -->
                            <div class="row justify-content-center">
                                <div class="col-md-6 my-2">
                                    <input class="form-control formInp py-3" type="text" 
                                           name="shop_location" placeholder="Shop Location" required
                                           value="<?= set_value('shop_location', $this->session->flashdata('form_data')['shop_location'] ?? '') ?>">
                                </div>
                                <div class="col-md-6 my-2">
                                    <input class="form-control formInp py-3" type="text" 
                                           name="opening_number" placeholder="Opening Shop Number" required
                                           value="<?= set_value('opening_number', $this->session->flashdata('form_data')['opening_number'] ?? '') ?>">
                                </div>
                            </div>

                            <!-- Password and Image Upload -->
                            <div class="row justify-content-center">
                                <div class="col-md-6 my-2 position-relative">
                                    <input class="form-control formInp py-3 pr-5" 
                                           type="password" name="password" placeholder="Password" required>
                                    <i class="fa-regular fa-eye eye position-absolute" 
                                       style="right: 15px; top: 50%; transform: translateY(-50%); cursor: pointer;"></i>
                                </div>
                                <div class="col-md-6 my-2 position-relative">
                                    <input type="file" name="shop_image" id="shopImage" class="d-none" accept="image/*">
                                    <label for="shopImage" class="btn w-100 btnUpload py-3">
                                        Tap to Upload Image
                                    </label>
                                    <div id="imagePreview" class="mt-2"></div>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="row my-2 justify-content-center">
                                <div class="col-md-6">
                                    <div class="d-flex flex-column align-items-center">
                                        <button type="submit" class="btn my-2 signB py-3 w-100">
                                            Sign Up
                                        </button>
                                        <a href="<?= base_url('login'); ?>" class="forgText my-2 py-3">
                                            Already Have Account? <span class="spanColor">Login</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Password Visibility Toggle
        document.querySelectorAll('.eye').forEach(icon => {
            icon.addEventListener('click', function() {
                const passwordField = this.previousElementSibling;
                if (passwordField.type === 'password') {
                    passwordField.type = 'text';
                    this.classList.replace('fa-eye', 'fa-eye-slash');
                } else {
                    passwordField.type = 'password';
                    this.classList.replace('fa-eye-slash', 'fa-eye');
                }
            });
        });

        // Image Preview
        document.getElementById('shopImage').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('imagePreview').innerHTML = `
                        <img src="${e.target.result}" class="img-thumbnail" style="max-width: 200px;">
                    `;
                }
                reader.readAsDataURL(file);
            }
        });
    </script>
</body>
</html>