<div class="container-fluid">
        <!-- Page Heading -->
        <div class="row column_title">
            <div class="col-md-12">
                <div class="page_title">
                    <h2>Curation Sliders Management</h2>
                </div>
            </div>
        </div>

        <!-- Manage Curation Sliders Section -->
        <br><br><br>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h5 class="m-0 font-weight-bold text-primary">Curation Sliders</h5>
            </div>
            <div class="card-body">

                <!-- Table to Display Existing Sliders -->
                <table class="table table-bordered" id="slidersTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Slider ID</th>
                            <th>Slider Name</th>
                            <th>Book</th>
                            <th>Items Count</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>1</td>
                            <td>Top Rated Books</td>
                            <td>Book 1</td>
                            <td>12</td>
                            <td>
                                <button class="btn btn-primary" data-toggle="modal" data-target="#editSliderModal">Edit</button>
                                <button class="btn btn-danger" data-toggle="modal" data-target="#deleteSliderModal">Delete</button>
                            </td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td>New Arrivals</td>
                            <td>Book 2</td>
                            <td>8</td>
                            <td>
                                <button class="btn btn-primary" data-toggle="modal" data-target="#editSliderModal">Edit</button>
                                <button class="btn btn-danger" data-toggle="modal" data-target="#deleteSliderModal">Delete</button>
                            </td>
                        </tr>
                    </tbody>
                </table>

                <!-- Button to Add a New Slider -->
                <button class="btn btn-success" data-toggle="modal" data-target="#addSliderModal">Add New Slider</button>

            </div>
        </div>

        <!-- Add New Slider Modal -->
        <div class="modal fade" id="addSliderModal" tabindex="-1" role="dialog" aria-labelledby="addSliderModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addSliderModalLabel">Add New Slider</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form>
                            <div class="form-group">
                                <label for="sliderName">Slider Name</label>
                                <input type="text" class="form-control" id="sliderName" placeholder="Enter slider name">
                            </div>
                            <div class="form-group">
                                <label for="editCriteria">Book</label>
                                <select class="form-control" id="editCriteria" >
                                      <option value="1">Book 1</option>  
                                      <option value="1">Book 2</option>  
                                      <option value="1">Book 3</option>                  

                                </select>
                            </div>
                            <button type="submit" class="btn btn-success">Save Slider</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Edit Slider Modal -->
        <div class="modal fade" id="editSliderModal" tabindex="-1" role="dialog" aria-labelledby="editSliderModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editSliderModalLabel">Edit Slider</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form>
                            <div class="form-group">
                                <label for="editSliderName">Slider Name</label>
                                <input type="text" class="form-control" id="editSliderName" placeholder="Update slider name">
                            </div>
                            <div class="form-group">
                                <label for="editCriteria">Book</label>
                                <select class="form-control" id="editCriteria" >
                                      <option value="1">Book 1</option>  
                                      <option value="1">Book 2</option>  
                                      <option value="1">Book 3</option>                  

                                </select>
                            </div>
                            <div class="form-group">
                                <label for="editSliderItems">Update Items</label>
                                <input type="file" class="form-control" id="editSliderItems" multiple>
                            </div>
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Delete Slider Modal -->
        <div class="modal fade" id="deleteSliderModal" tabindex="-1" role="dialog" aria-labelledby="deleteSliderModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteSliderModalLabel">Delete Slider</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to delete this slider?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-danger">Delete</button>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- /.container-fluid -->
