<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">

    <div class="row align-items-center">
      <div class="col-md-8 my-2">
        <h3 class="fmon mb-0">Catalogues</h3>
      </div>
      <div class="col-md-4 my-2 d-flex justify-content-end">
        <a href="<?= base_url('product/addProduct'); ?>" class="btn setBtn px-4"> Add Product</a>

      </div>
    </div>

    <div class="row my-2">
      <div class="col-md-12">
        <div class="orderCard table-responsive p-2">
          <table class="table">
            <thead>
              <tr>
                <th>#</th>
                <th>Name</th>
                <th>Category</th>
                <!-- <th>Quantity</th> -->
                <th>Date</th>
                <!-- <th>Shop Location</th> -->
                <th>Price</th>
                <th class="d-flex justify-content-center">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php
              $num = 1; // Initialize numbering
              ?>
              <?php foreach ($products as $product): ?>

                <tr>
                  <td><?= $num++; ?></td>
                  <td>
                    <img class="tableImag" src="<?= $product['image'] ?>" alt=""><?= $product['serviceName'] ?>
                  </td>
                  <td><?= $product['category'] ?></td>
                  <!-- <td><?= $product['quantity'] ?></td> -->
                  <td><?= $product['date'] ?></td>
                  <!-- <td><?= $product['shopLocation'] ?></td> -->
                  <td><?= $product['price'] ?></td>
                  <!-- <td>
                    <span class="action">
                      <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#5f6368">
                        <path d="M480-160q-33 0-56.5-23.5T400-240q0-33 23.5-56.5T480-320q33 0 56.5 23.5T560-240q0 33-23.5 56.5T480-160Zm0-240q-33 0-56.5-23.5T400-480q0-33 23.5-56.5T480-560q33 0 56.5 23.5T560-480q0 33-23.5 56.5T480-400Zm0-240q-33 0-56.5-23.5T400-720q0-33 23.5-56.5T480-800q33 0 56.5 23.5T560-720q0 33-23.5 56.5T480-640Z" />
                      </svg>
                    </span>
                  </td> -->
                  <td class="d-flex justify-content-center align-items-center">
                             <a class="btn setBtn px-4" href="<?= base_url('product/updateProduct/') . $product['id'] ?>">Edit</a>
                        <a class="btn setBtn px-4 text-danger delete-btn" data-id="<?= $product['id'] ?>" href="#">Delete</a>
                    
                    <!-- <div class="dropdown">
                      <span class="action dropdown-toggle" data-bs-toggle="dropdown" style="cursor: pointer;">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#5f6368">
                          <path d="M480-160q-33 0-56.5-23.5T400-240q0-33 23.5-56.5T480-320q33 0 56.5 23.5T560-240q0 33-23.5 56.5T480-160Zm0-240q-33 0-56.5-23.5T400-480q0-33 23.5-56.5T480-560q33 0 56.5 23.5T560-480q0 33-23.5 56.5T480-400Zm0-240q-33 0-56.5-23.5T400-720q0-33 23.5-56.5T480-800q33 0 56.5 23.5T560-720q0 33-23.5 56.5T480-640Z" />
                        </svg>
                      </span>
                      <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item edit-btn" href="<?= base_url('product/edit/') . $product['id'] ?>">Edit</a></li>
                        <li><a class="dropdown-item text-danger delete-btn" data-id="<?= $product['id'] ?>" href="#">Delete</a></li>
                      </ul>
                    </div> -->
                  </td>

                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>


        </div>
      </div>
    </div>
</main>
<!--end main wrapper-->


<!--start overlay-->
<div class="overlay btn-toggle"></div>
<!--end overlay-->

<script>
document.addEventListener('DOMContentLoaded', () => {
    // Delete handler
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            const productId = this.dataset.id;

            Swal.fire({
                title: 'Are you sure?',
                text: 'This will permanently delete the product.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(`<?= base_url('product/delete/') ?>${productId}`, {
                        method: 'DELETE'
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire('Deleted!', data.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error!', data.message, 'error');
                        }
                    })
                    .catch(err => {
                        console.error(err);
                        Swal.fire('Error!', 'Something went wrong.', 'error');
                    });
                }
            });
        });
    });
});
</script>
