<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Naseej</title>
    <!-- bootstrap cdn -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- custom css -->
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/style.css">
    <!-- fontawesone link -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
</head>

<body class="bg-main pt-5 pb-5">
    <div class="container-fluid mt-5 pt-5 mb-5 pb-5">
        <div class="container">
            <div class="row">
                <?php $successMessage = $this->session->flashdata('successmessage');
                $warningmessage = $this->session->flashdata('warningmessage');
                if (isset($successMessage)) { ?>
                    <div id="alertmessage" class="col-md-12">
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= output($successMessage) ?>
                        </div>
                    </div>
                <?php }
                if (isset($warningmessage)) { ?>
                    <div id="alertmessage" class="col-md-12">
                        <div class="alert alert-warning alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= output($warningmessage) ?>
                        </div>
                    </div>
                <?php } ?>
            </div>

            <div class="row">
                <div class="col-md-12 my-2">
                    <img class="d-block mx-auto"
                        src="<?= base_url(); ?>assets/images/logo.png"
                        alt="Logo"
                        width="200" />
                    <p class="text-center fs1 mt-3">Enter your Login details to Access Your Account</p>

                    <form action="<?= base_url('login/login_action'); ?>" method="post">
                        <div class="row mb-2 mt-5">
                            <div class="col-md-12 my-2">
                                <!-- Email Input -->
                                <div class="my-2 row justify-content-center">
                                    <div class="col-md-6 my-2 align-self-center">
                                        <label for="email" class="fs3 mb-2">Email</label>
                                        <input type="email"
                                            name="email"
                                            class="form-control formInp py-3"
                                            placeholder="Email/username"
                                            required
                                            value="<?= set_value('email', $this->session->flashdata('email')) ?>">
                                    </div>
                                </div>

                                <!-- Password Input -->
                                <div class="my-2 row justify-content-center">
                                    <div class="col-md-6 my-2 align-self-center">
                                        <label for="password" class="fs3 mb-2">Password</label>
                                        <div class="position-relative">
                                            <input type="password"
                                                name="password"
                                                class="form-control formInp py-3 pr-5"
                                                placeholder="Password"
                                                required>
                                            <i class="fas fa-eye eye position-absolute"
                                                style="right: 15px; top: 50%; transform: translateY(-50%); cursor: pointer;"></i>
                                        </div>
                                    </div>
                                </div>

                                <div class="my-2 d-flex justify-content-center">
                                    <a href="#" class="text-center forgText">Forgot Your Password</a>
                                </div>

                                <div class="row my-2 justify-content-center">
                                    <div class="col-md-6">
                                        <div class="row justify-content-center">
                                            <div class="col-md-6">
                                                <div class="d-flex flex-column justify-content-center align-items-center">
                                                    <button type="submit" class="btn my-2 signB py-3 w-100">
                                                        Login
                                                    </button>
                                                    <a href="<?= base_url('login/signup'); ?>" class="forgText my-2 py-3">
                                                        Don't have an account? <span class="spanColor">Sign Up</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL"
        crossorigin="anonymous"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Password visibility toggle
            document.querySelectorAll('.eye').forEach(icon => {
                icon.addEventListener('click', function() {
                    const passwordField = this.closest('.input-group').querySelector('input');
                    const eyeIcon = this.querySelector('i');

                    if (passwordField.type === 'password') {
                        passwordField.type = 'text';
                        eyeIcon.classList.replace('fa-eye', 'fa-eye-slash');
                    } else {
                        passwordField.type = 'password';
                        eyeIcon.classList.replace('fa-eye-slash', 'fa-eye');
                    }
                });
            });

            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.alert');
                alerts.forEach(alert => {
                    new bootstrap.Alert(alert).close();
                });
            }, 5000);
        });
    </script>
</body>

</html>