<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Naseej - Sign Up</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>

<body class="bg-main pt-5 pb-5">
    <div class="container-fluid mt-5 pt-5 mb-5 pb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-12 my-2">
                    <?php if ($this->session->flashdata('warningmessage')) { ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <?= $this->session->flashdata('warningmessage') ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php } ?>

                    <img class="d-block mx-auto" src="<?= base_url(); ?>assets/images/logo.png" alt="Logo" width="200">

                    <form action="<?= base_url('login/signup_action') ?>" method="post" enctype="multipart/form-data">
                        <div class="row mb-2 mt-5">
                            <!-- Name and Email -->
                            <div class="row justify-content-center">
                                <div class="col-md-6 my-2">
                                    <label class="clabel text-white">Name</label>
                                    <input class="form-control formInp py-3" type="text"
                                        name="name" placeholder="Name" required
                                        value="<?= set_value('name', $this->session->flashdata('form_data')['name'] ?? '') ?>">
                                </div>
                                <div class="col-md-6 my-2">
                                    <label class="clabel text-white">Email</label>
                                    <input class="form-control formInp py-3" type="email"
                                        name="email" placeholder="Email" required
                                        value="<?= set_value('email', $this->session->flashdata('form_data')['email'] ?? '') ?>">
                                </div>
                            </div>

                            <!-- Start Date and Shop Timing -->
                            <div class="row justify-content-center">
                                <!-- <div class="col-md-6 my-2">
                                    <input class="form-control formInp py-3" type="date" 
                                           name="start_date" required
                                           value="<?= set_value('start_date', $this->session->flashdata('form_data')['start_date'] ?? '') ?>">
                                </div> -->
                                <div class="col-md-6 my-2">
                                    <label class="clabel text-white">Location</label>
                                    <input id="shop_location" class="form-control formInp py-3" type="text"
                                        name="shop_location" placeholder="Shop Location" required
                                        value="<?= set_value('shop_location', $this->session->flashdata('form_data')['shop_location'] ?? '') ?>">
                                    <input type="hidden" id="lat" name="lat">
                                    <input type="hidden" id="lng" name="lng">
                                    <small id="locationError" class="text-danger d-none">Please select a valid location from suggestions.</small>
                                </div>
                                <div class="col-md-3 my-2">
                                    <label class="clabel text-white">Open At</label>
                                    <input class="form-control formInp py-3" type="time" id="time_from" placeholder="From" />
                                </div>
                                <div class="col-md-3 my-2">
                                    <label class="clabel text-white">Close At</label>
                                    <input class="form-control formInp py-3" type="time" id="time_to" placeholder="To" />
                                </div>

                                <!-- This will hold the combined value -->
                                <input type="hidden" id="shop_timing" name="shop_timing"
                                    value="<?= set_value('shop_timing', $this->session->flashdata('form_data')['shop_timing'] ?? '') ?>" />
                            </div>

                            <!-- Shop Location and Opening Number -->
                            <div class="row justify-content-center">

                                <div class="col-md-6 my-2">
                                    <label class="clabel text-white">Opening Shop Number - Contact Number</label>
                                    <input class="form-control formInp py-3" type="text"
                                        name="opening_number" placeholder="Opening Shop Number - Contact Number" required
                                        value="<?= set_value('opening_number', $this->session->flashdata('form_data')['opening_number'] ?? '') ?>">
                                </div>

                                <div class="col-md-6 my-2 position-relative">
                                    <label class="clabel text-white">Password</label>
                                    <input class="form-control formInp py-3 pr-5"
                                        type="password" name="password" placeholder="Password" required>
                                    <i class="fa-regular fa-eye eye position-absolute"
                                        style="right: 15px; top: 50%; transform: translateY(-50%); cursor: pointer;"></i>
                                </div>
                            </div>

                            <!-- Categories Selection -->
                            <div class="col-md-9 my-2">
                                <label class="clabel text-white">Select Specializations</label>
                                <div class="row">
                                    <?php foreach ($categories as $category): ?>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox"
                                                    name="categoryIds[]"
                                                    value="<?= $category['id'] ?>"
                                                    id="cat_<?= $category['id'] ?>">
                                                <label class="form-check-label text-white text-capitalize" for="cat_<?= $category['id'] ?>">
                                                    <?= $category['data']['name'] ?? 'Unnamed Category' ?>
                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>

                            <!-- Tailor Type Selection -->
                            <div class="col-md-3 my-2">
                                <label class="clabel text-white">Tailor Type</label>
                                <select class="form-control formInput" name="tailor_type" required>
                                    <option value="">Select Service Type</option>
                                    <option value="Men's Tailor">Men's Tailor</option>
                                    <option value="Women's Tailor">Women's Tailor</option>
                                    <option value="Both Men's & Women's Tailor">Both</option>
                                </select>
                            </div>



                            <!-- Password and Image Upload -->
                            <div class="row justify-content-center">

                                <div class="col-md-6 my-2 position-relative">
                                    <input type="file" name="shop_image" id="shopImage" class="d-none" accept="image/*">
                                    <label for="shopImage" class="btn w-100 btnUpload py-3">
                                        Tap to Upload Image
                                    </label>
                                    <div id="imagePreview" class="mt-2 d-flex justify-content-center"></div>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="row my-2 justify-content-center">
                                <div class="col-md-6">
                                    <div class="d-flex flex-column align-items-center">
                                        <button type="submit" class="btn my-2 signB py-3 w-100" disabled id="signup_btn">
                                            Sign Up
                                        </button>
                                        <a href="<?= base_url('login'); ?>" class="forgText my-2 py-3">
                                            Already Have Account? <span class="spanColor">Login</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4&libraries=places&callback=initAutocomplete" async defer></script>
    <script>
        const timeFrom = document.getElementById('time_from');
        const timeTo = document.getElementById('time_to');
        const shopTiming = document.getElementById('shop_timing');

        function updateShopTiming() {
            const from = timeFrom.value;
            const to = timeTo.value;
            shopTiming.value = from && to ? `${from} - ${to}` : '';
        }

        timeFrom.addEventListener('change', updateShopTiming);
        timeTo.addEventListener('change', updateShopTiming);
    </script>

    <script>
        let autocomplete;
        let placeSelected = false;

        function initAutocomplete() {
            const input = document.getElementById('shop_location');
            const signupBtn = document.getElementById('signup_btn');
            const latInput = document.getElementById('lat');
            const lngInput = document.getElementById('lng');
            const errorMsg = document.getElementById('locationError');

            autocomplete = new google.maps.places.Autocomplete(input, {
                types: ['geocode'],
                componentRestrictions: {
                    country: 'ae'
                } // AE = United Arab Emirates
            });

            autocomplete.addListener('place_changed', () => {
                const place = autocomplete.getPlace();
                if (place.geometry) {
                    const lat = place.geometry.location.lat();
                    const lng = place.geometry.location.lng();

                    latInput.value = lat;
                    lngInput.value = lng;
                    placeSelected = true;

                    signupBtn.disabled = false;
                    errorMsg.classList.add('d-none');
                }
            });

            input.addEventListener('blur', () => {
                if (!placeSelected || !latInput.value || !lngInput.value) {
                    signupBtn.disabled = true;
                    errorMsg.classList.remove('d-none');
                } else {
                    errorMsg.classList.add('d-none');
                }
            });

            // Reset if the user starts typing again
            input.addEventListener('input', () => {
                placeSelected = false;
                latInput.value = '';
                lngInput.value = '';
                signupBtn.disabled = true;
                errorMsg.classList.add('d-none');
            });
        }
    </script>

    <script>
        // Password Visibility Toggle
        document.querySelectorAll('.eye').forEach(icon => {
            icon.addEventListener('click', function() {
                const passwordField = this.previousElementSibling;
                if (passwordField.type === 'password') {
                    passwordField.type = 'text';
                    this.classList.replace('fa-eye', 'fa-eye-slash');
                } else {
                    passwordField.type = 'password';
                    this.classList.replace('fa-eye-slash', 'fa-eye');
                }
            });
        });

        // Image Preview
        document.getElementById('shopImage').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('imagePreview').innerHTML = `
                        <img src="${e.target.result}" class="img-thumbnail" style="max-width: 200px;">
                    `;
                }
                reader.readAsDataURL(file);
            }
        });
    </script>
</body>

</html>