<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark"><?php echo (isset($speciality)) ? 'Edit Tradional Dishes' : 'Add Tradional Dishes' ?>
                </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= base_url(); ?>/dashboard/dishes">Tradional Dishes</a></li>
                    <li class="breadcrumb-item active"><?php echo (isset($speciality)) ? 'Edit Tradional Dishes' : 'Add Tradional Dishes' ?></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <?php
            if(isset($speciality)){
                $endPoint = "updatetradish";
            }else{
                $endPoint = "inserttradish";
            }
        ?>
        <form method="post" id="customer_add" class="card" action="<?php echo base_url() . "dashboard/".$endPoint; ?>" enctype="multipart/form-data">
            <div class="card-body">

                <div class="row">
                    <input type="hidden" name="id" id="eid" value="<?php echo (isset($speciality)) ? $speciality['id'] : '' ?>">

                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Name / Title</Title></label>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($speciality)) ? $speciality['name'] : '' ?>" name="name" placeholder="Speciality Name">
                        </div>
                    </div>
                    
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Country</Title></label>
                            <select class="form-control" name="country_id" required="true">
                                <option value="" selected>Select Country</option>
                                <?php foreach ($country as $key => $value) {?>
                                   


                                <option value="<?php echo $key; ?>" <?php echo (isset($speciality) && $speciality['country_id']==$key) ? ' selected' : '' ?>><?php echo $value['name'] ?></option>
                                                                <?php }  ?>

                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Type</Title></label>
                            <select class="form-control" name="type" required="true">
                                <option value="" selected>Select  Type</option>
                                <option value="beverages" <?php echo (isset($speciality) && $speciality['type']=="beverages") ? ' selected' : '' ?>>Beverages</option>
                                <option value="desserts" <?php echo (isset($speciality) && $speciality['type']=="desserts") ? ' selected' : '' ?>>Desserts</option>
                                <option value="sweets" <?php echo (isset($speciality) && $speciality['type']=="sweets") ? ' selected' : '' ?>>Sweets</option>
                       
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Price</label>
                            <input type="number" step="0.01" required="true" class="form-control" value="<?php echo (isset($speciality)) ? $speciality['price'] : '' ?>" name="price" placeholder="Price">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Ingredients: </label><span class="label label-danger" style="color:red;">Ingredient must with comma seprated</span>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($speciality)) ? implode(",",$speciality['ingredients']) : '' ?>" name="ingredients" placeholder="ingredients">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="descriptions" required="true" placeholder="Description"><?php echo (isset($speciality)) ? $speciality['descriptions'] : '' ?></textarea>  
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Feature Image</label>
                            <input type="file" class="form-control" name="image">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Image 2</label>
                            <input type="file" class="form-control" name="image1">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Image 3</label>
                            <input type="file" class="form-control" name="image2">
                        </div>
                    </div>
                </div>

                <div class="modal-footer">

                    <button type="submit" class="btn btn-primary"> <?php echo (isset($speciality)) ? 'Update Tradional Dish' : 'Add Tradional Dish' ?></button>
                </div>
            </div>
        </form>
    </div>
</section>
<!-- /.content -->