<?php
function floorDec($val, $precision = 2)
{
    if ($precision < 0) {
        $precision = 0;
    }
    $numPointPosition = intval(strpos($val, '.'));
    if ($numPointPosition === 0) { //$val is an integer
        return $val;
    }
    return floatval(substr($val, 0, $numPointPosition + $precision + 1));
}
?>
<!-- Begin Page Content -->
<style>
select {
    margin: 15px;
    width: 150px;
    padding: 5px 5px 5px 5px;
    font-size: 16px;
    border: 1px solid #CCC;
    height: 34px;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
}
</style>
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
        <!-- <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i class="fas fa-download fa-sm text-white-50"></i> Generate Report</a> -->
    </div>

    <!-- Content Row -->
    <div class="row">

        <!-- Earnings (Monthly) Card Example -->
        <div class="col-xl-3 col-md-6 mb-4 ">
            <div class="card border-left-users shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#20435A;">
                                Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $totalUsers; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-3x" style="color:#20435A;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Earnings (Monthly) Card Example -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-podcasts shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#638DA6;">
                                Restaurant</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php  echo $rides;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-podcast fa-3x" style="color:#638DA6;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-podcasts shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#638DA6;">
                                claimed Restaurant</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php  echo $associate;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-podcast fa-3x" style="color:#638DA6;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-podcasts shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#638DA6;">
                                unclaimed Restaurant</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php  echo ($rides-$associate);?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-podcast fa-3x" style="color:#638DA6;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-podcasts shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#638DA6;">
                                claimed User</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php  echo $userassociate;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-podcast fa-3x" style="color:#638DA6;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Pending Requests Card Example -->
        <div class="col-xl-3 col-md-6 mb-4 ">
            <div class="card border-left-females shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#CC8A9F;">
                                Meals</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php  echo $meal;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-circle fa-3x" style="color:#CC8A9F;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4 ">
            <div class="card border-left-females shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#638DA6;">
                                MRR</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">$<?php  echo $mrr;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-3x" style="color:#638DA6;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4 ">
            <div class="card border-left-females shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#CC8A9F;">
                                ARR</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">$<?php  echo $arr;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-3x" style="color:#CC8A9F;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4 ">
            <div class="card border-left-females shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#CC8A9F;">
                                Basic Plan</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php  echo $basicplan;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-3x" style="color:#CC8A9F;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4 ">
            <div class="card border-left-females shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#CC8A9F;">
                                Pro Plan</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php  echo $proplan;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-3x" style="color:#CC8A9F;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4 ">
            <div class="card border-left-females shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="color:#CC8A9F;">
                                Premium Plan</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php  echo $premiumplan;?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-3x" style="color:#CC8A9F;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Content Row -->

    <div class="row">

        <!-- Area Chart -->
        <div class="col-xl-12 col-lg-12">
            <h4>
                User Sign Up Trends
            </h4>
            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="line_chart" style="width: 100%; height: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12 col-lg-12">&nbsp;</div>
        <div class="col-xl-12 col-lg-12">
            <h4>
                Search Frequency
            </h4>
            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="pi_chart" style="width: 100%; height: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12 col-lg-12">&nbsp;</div>
        <div class="col-xl-12 col-lg-12">
            <h4>
                Click-Through Rates
            </h4>
            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="pi_chart2" style="width: 100%; height: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12 col-lg-12">&nbsp;</div>
        <div class="col-xl-12 col-lg-12">
            <h4>
                Retention Metrics <small>(Dishes)</small>
            </h4>
            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="bar_chart" style="width: 100%; height: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12 col-lg-12">&nbsp;</div>
        <div class="col-xl-12 col-lg-12">
            <h4>
                Conversion Rates
            </h4>
            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="bar_chart4" style="width: 100%; height: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12 col-lg-12">&nbsp;</div>
        <div class="col-xl-12 col-lg-12">
            <h4>
                Engagement Metrics <small>(Restaurants)</small>
            </h4>
            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="bar_engagement" style="width: 100%; height: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12 col-lg-12">&nbsp;</div>
        <div class="col-xl-12 col-lg-12">
            <h4>
                Time-Based Trends <small>(<?=$timeMainLabel?>)</small>
            </h4>
            <p style="display: inline-flex; align-items:center; justify-content:space-between">
                <select class="form-select" name="day" id="day" onchange="selectDay()">
                    <option value="">Select Day</option>
                    <option value="Monday" <?=($dayOfWeek == 'Monday')?'selected':''?>>Monday</option>
                    <option value="Tuesday" <?=($dayOfWeek == 'Tuesday')?'selected':''?>>Tuesday</option>
                    <option value="Wednesday" <?=($dayOfWeek == 'Wednesday')?'selected':''?>>Wednesday</option>
                    <option value="Thursday" <?=($dayOfWeek == 'Thursday')?'selected':''?>>Thursday</option>
                    <option value="Friday" <?=($dayOfWeek == 'Friday')?'selected':''?>>Friday</option>
                    <option value="Saturday" <?=($dayOfWeek == 'Saturday')?'selected':''?>>Saturday</option>
                    <option value="Sunday" <?=($dayOfWeek == 'Sunday')?'selected':''?>>Sunday</option>
                </select>
                <select class="form-select" name="week" id="week" onchange="selectWeek()">
                    <option value="">Select Week</option>
                    <option value="1st week" <?=($week == '1st week')?'selected':''?>>1st week</option>
                    <option value="2nd week" <?=($week == '2nd week')?'selected':''?>>2nd week</option>
                    <option value="3rd week" <?=($week == '3rd week')?'selected':''?>>3rd week</option>
                    <option value="last week" <?=($week == 'last week')?'selected':''?>>last week</option>
                </select>
                <select class="form-select" name="year" id="year" onchange="selectYear()">
                    <option value="">Select Year</option>
                    <!-- <option value="2023" <?=($year == '2023')?'selected':''?>>2023</option> -->
                    <option value="2024" <?=($year == '2024')?'selected':''?>>2024</option>
                </select>
            </p>
            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="time_bar" style="width: 100%; height: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>



</div>
<!-- /.container-fluid -->
<script>
function selectDay() {
    var day = $('#day').find(":selected").val();
    window.location.href = '<?=base_url('dashboard')?>?day=' + day;
}

function selectWeek() {
    var week = $('#week').find(":selected").val();
    window.location.href = '<?=base_url('dashboard')?>?week=' + week;
}

function selectYear() {
    var year = $('#year').find(":selected").val();
    window.location.href = '<?=base_url('dashboard')?>?year=' + year;
}
</script>