<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark"><?php echo (isset($event)) ? 'Edit Restaurant' : 'Add Restaurant' ?>
                </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= base_url(); ?>/dashboard/events">Restaurant</a></li>
                    <li class="breadcrumb-item active"><?php echo (isset($event)) ? 'Edit Restaurant' : 'Add Restaurant' ?></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <?php
            if(isset($event)){
                $endPoint = "updateevent";
            }else{
                $endPoint = "insertevent";
            }
        ?>
        <form method="post" id="customer_add" class="card" action="<?php echo base_url() . "dashboard/". $endPoint ; ?>" enctype="multipart/form-data">
            <div class="card-body">

                <div class="row">
                    <input type="hidden" name="id" value="<?php echo (isset($event)) ? $event['id'] : '' ?>">

                    <div class="col-4">
                        <div class="form-group">
                            <label class="form-label">Name / Title</Title></label>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['name'] : '' ?>" name="name" placeholder="Event Name">
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                            <label class="form-label">Phone Number</label>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['phoneNumber'] : '' ?>" name="phoneNumber" placeholder="Phone Number">
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                            <label class="form-label">Address</label>
                            <input type="text" required="true" class="form-control" id="pac-input"  name="address" value="<?php echo (isset($event)) ? $event['address'] : '' ?>" placeholder="Event Address">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Category</label>
                            <?php foreach ($mcategory as $key => $value) {?>
                                    <input type="checkbox" name="category[]" value="<?php echo $key; ?>" <?php echo (isset($event) && in_array($key,$event['category'])) ? ' checked' : '' ?>><?php echo $value['name'] ?>           
                                <?php }  ?>
                        </div>
                    </div>

                    <div class="col-4">
                        <div class="form-group">
                                <label class="form-label">Website</label>
                                <input type="text"  class="form-control" value="<?php echo (isset($event)) ? $event['website'] : '' ?>" name="website" >
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                                <label class="form-label">City</label>
                                <input type="text" required="true" id="locality" class="form-control" value="<?php echo (isset($event)) ? $event['city'] : '' ?>" required name="city" >
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                            <label class="form-label">Country</Title></label>
                            <select class="form-control" id="country" name="country" required="true">
                                <option value="" selected>Select Country</option>
                                <?php
                         
                                foreach ($country as $key=> $value) {?>
                                   


                                <option value="<?php echo $key; ?>" <?php echo (isset($event) && $event['country']==$key) ? ' selected' : '' ?>><?php echo $value['name'] ?></option>
                                                                <?php }  ?>

                            </select>
                           
                        </div>
                    </div>


                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Latitude</label>
                            <input type="text" required="true" id="lat" class="form-control" value="<?php echo (isset($event)) ? $event['lat'] : '' ?>" name="lat">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Longititude</label>
                            <input type="text" required="true" id="lng" class="form-control" value="<?php echo (isset($event)) ? $event['lng'] : '' ?>" name="lng" >
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Image</label>
                            <input type="file" class="form-control" name="image">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Details</label>
                            <textarea required="true" class="form-control" name="details" placeholder="Event Details"><?php echo (isset($event)) ? $event['details'] : '' ?></textarea>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">

                    <button type="submit" class="btn btn-primary"> <?php echo (isset($event)) ? 'Update Restaurant' : 'Add Restaurant' ?></button>
                </div>
            </div>
        </form>
        <div id="map" style="display:none;width: 500px; height: 500px;"></div>
    </div>
</section>
<!-- /.content -->

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDfRI5hac8jwDvEQ1k2S5jfNEiNa9vcWhE&libraries=places&callback=initMap"
        async defer></script>
  <script>
      // This example requires the Places library. Include the libraries=places
      // parameter when you first load the API. For example:
      // <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">

var componentForm = {
  
  locality: 'long_name',
 
  country: 'long_name',

};


      function initMap() {
        var map = new google.maps.Map(document.getElementById('map'), {
          center: {lat: -33.8688, lng: 151.2195},
          zoom: 13
        });
        var card = document.getElementById('pac-card');
        var input = document.getElementById('pac-input');
        var types = document.getElementById('type-selector');
        var strictBounds = document.getElementById('strict-bounds-selector');

        map.controls[google.maps.ControlPosition.TOP_RIGHT].push(card);

        var autocomplete = new google.maps.places.Autocomplete(input);

        // Bind the map's bounds (viewport) property to the autocomplete object,
        // so that the autocomplete requests use the current map bounds for the
        // bounds option in the request.
        autocomplete.bindTo('bounds', map);

        // Set the data fields to return when the user selects a place.
        autocomplete.setFields(
            ['address_components', 'geometry', 'icon', 'name']);

        var infowindow = new google.maps.InfoWindow();
        var infowindowContent = document.getElementById('infowindow-content');
        infowindow.setContent(infowindowContent);
        var marker = new google.maps.Marker({
          map: map,
          anchorPoint: new google.maps.Point(0, -29)
        });

        autocomplete.addListener('place_changed', function() {
          infowindow.close();
          marker.setVisible(false);
          var place = autocomplete.getPlace();
                       
          
          if (!place.geometry) {
            // User entered the name of a Place that was not suggested and
            // pressed the Enter key, or the Place Details request failed.
            window.alert("No details available for input: '" + place.name + "'");
            return;
          }

          // If the place has a geometry, then present it on a map.
          if (place.geometry.viewport) {
            map.fitBounds(place.geometry.viewport);
          } else {
            map.setCenter(place.geometry.location);
            map.setZoom(17);  // Why 17? Because it looks good.
          }
          marker.setPosition(place.geometry.location);
          marker.setVisible(true);

          var address = '';
          if (place.address_components) {
              console.log(place);
              
              var latitude = place.geometry.location.lat();
        var longitude = place.geometry.location.lng();
        console.log(latitude);
        console.log(longitude);
        document.getElementById("lat").value = latitude;
        document.getElementById("lng").value = longitude;
       

  // Get each component of the address from the place details,
  // and then fill-in the corresponding field on the form.
  console.log(place.address_components);
  var countryname="";
  for (var i = 0; i < place.address_components.length; i++) {
    var addressType = place.address_components[i].types[0];
    if (componentForm[addressType]) {
    console.log(addressType,componentForm[addressType]);
        var val="";
       val = place.address_components[i][componentForm[addressType]];
       console.log(val);
       
        if(addressType=="country"){
            console.log("hahahha");
            countryname=val;


        }


      document.getElementById(addressType).value = val;
    
    }
  }
  var selectElement = document.getElementById("country");
// Loop through each <option> inside the <select> element

for (var i = 0; i < selectElement.options.length; i++) {
    console.log(selectElement.options[i].text,"=== ",countryname);
    // Check if the text of the current option matches the country variable
    if (selectElement.options[i].text == countryname) {
        console.log("hahahha");
        // Set the selected attribute of the matching option to true
        selectElement.options[i].selected = true;
        break; // Exit the loop since we found a match
    }
}
            // address = [
            //   (place.address_components[0] && place.address_components[0].short_name || ''),
            //   (place.address_components[1] && place.address_components[1].short_name || ''),
            //   (place.address_components[2] && place.address_components[2].short_name || '')
            // ].join(' ');
          
              
              
              
          }
          console.log(address);
          
            document.getElementById("infodetail").value = place.name;
          infowindowContent.children['place-icon'].src = place.icon;
          infowindowContent.children['place-name'].textContent = place.name;
          infowindowContent.children['place-address'].textContent = address;
          infowindow.open(map, marker);
        });

        // Sets a listener on a radio button to change the filter type on Places
        // Autocomplete.
        function setupClickListener(id, types) {
          var radioButton = document.getElementById(id);
          radioButton.addEventListener('click', function() {
            autocomplete.setTypes(types);
          });
        }

        setupClickListener('changetype-all', []);
        setupClickListener('changetype-address', ['address']);
        setupClickListener('changetype-establishment', ['establishment']);
        setupClickListener('changetype-geocode', ['geocode']);

        document.getElementById('use-strict-bounds')
            .addEventListener('click', function() {
              console.log('Checkbox clicked! New state=' + this.checked);
              autocomplete.setOptions({strictBounds: this.checked});
            });
      }
    </script>
    
    