<!-- Begin Page Content -->
<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>News Management</h2>
            </div>
        </div>
    </div>

    <button type="button" style="float: right;" onclick="location.href='<?= base_url() . 'news/addnews' ?>'" class="btn btn-primary">Add News</button>
    <br><br><br>

    <div class="card shadow">
        <div class="card-header py-3">
            <!-- <h6 class="m-0 font-weight-bold text-primary">DataTables Example</h6> -->
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="newsTable" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Title</th>
                            <th>Description</th>
                            <th>Date</th>
                            <th>Created Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php
                        if (!empty($newslist)) {
                            $count = 1;
                            foreach ($newslist as $id => $news) {
                        ?>
                        <tr>
                            <td><?php echo ($news['title'] != "") ? $news['title'] : 'N/A'; ?></td>
                            <td><?php echo ($news['description'] != "") ? substr($news['description'], 0, 100) . '...' : 'N/A'; ?></td>
                            <td><?php echo ($news['newsDate'] != "") ? date('Y-m-d', $news['newsDate'] / 1000) : 'N/A'; ?></td>
                            <td><?php echo ($news['createdDate'] != "") ? date('Y-m-d H:i:s', $news['createdDate'] / 1000) : 'N/A'; ?></td>
                            <td>
                                <?php if ($news['isActive'] == true) { ?>
                                    <span class="badge badge-success">Active</span>
                                <?php } else { ?>
                                    <span class="badge badge-danger">Inactive</span>
                                <?php } ?>
                            </td>
                            <td>
                                <a class="icon" style="text-decoration: none;" href="<?php echo base_url(); ?>news/editnews/<?php echo output($id); ?>">
                                    <button class="btn btn-info btn-sm">Edit</button>
                                </a>

                                <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#exampleModal" onclick="showConfirmation('<?php echo output($id); ?>','<?=$news['title']?>', 'deleteNews');">Delete</button>
                            </td>
                        </tr>
                        <?php
                        }
                        }
                         ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="get" name="cform" action="">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn"></button>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
function showConfirmation(newsId, newsTitle, action) {
    let url = "";
    let message = "";
    let btnTitle = "";
    switch (action) {
        case 'deleteNews':
            url = "<?php echo base_url(); ?>news/remove/" + newsId;
            message = "Are you sure you want to delete news '" + newsTitle + "'?";
            btnTitle = "Delete News";
            break;
        default:
            return false;
    }

    document.getElementById('exampleModalLabel').innerText = message;
    document.getElementById('submitBtn').innerText = btnTitle;
    document.cform.action = url;
}
</script>
