<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Products</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Begin Page Content -->
<div class="container-fluid mt-4">
  <div class="row column_title">
    <div class="col-md-12">
      <div class="page_title">
        <h2>Products</h2>
      </div>
    </div>
  </div>


  <br><br><br>

  <div class="card shadow">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Product Details</h6>
    </div>
    <div class="card-body">
      <div class="table-responsive">

        <table class="table table-bordered" id="productTable" width="100%" cellspacing="0">
          <thead class="thead-dark">
            <tr>
              <th>#</th>
              <th>Detail</th>
            </tr>
          </thead>

          <tbody id="productTbody">
            <tr>
              <td>Product Name</td>
              <td>
              <?php echo $product['productName']; ?>
              </td>
            </tr>
            <tr>
              <td>Product Detail</td>
              <td>
              <?php echo $product['productDetail']; ?>
              </td>
            </tr>
            <tr>
              <td>Product Price</td>
              <td>
              <?php echo "$".$product['productPrice']; ?>
              </td>
            </tr>

            <tr>
              <td>Average Rating</td>
              <td>
              <?php echo $product['averageRating']; ?>
              </td>
            </tr>
            <tr>
              <td>Product Rating Count</td>
              <td>
              <?php echo $product['ratingCount']; ?> Ratings
              </td>
            </tr>
            <tr>
              <td>Product Is Verified</td>
              <td>
              <?php echo ($product['isVerified']==1) ? 'Yes' : 'No'; ?>
              </td>
            </tr>
            <tr>
              <td>Product Create Date</td>
              <td>
              <?php echo date("d-m-Y", $product['createDate']/1000); ?>
              </td>
            </tr>
            <tr>
              <td>User Name</td>
              <td>
              <?php
              
              $user=$this->common->readdatadocument('Users', $product['userId']);
              echo $user['userName']; ?>
              </td>
            </tr>
            <tr>
              <td>Category</td>
              <td>
                <?php 
              $service=$this->common->readdatadocument('Categories', $product['categoryId']);
              echo $service['name']; ?>
              </td>
            </tr>


            
            <tr>
              <td>Product Images</td>
              <td>
                <?php foreach ($product['productUrl'] as $url) { ?>
                  <img class="img-thumbnail" width="100" height="100" src="<?php echo $url; ?>">
                <?php } ?>
              </td>
            </tr>

            <tr></tr>
            <!-- Rows will be injected via JavaScript -->
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <form method="get" name="cform" action="">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel2"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary" id="submitBtn"></button>
        </div>
      </div>
    </div>
  </form>
</div>

