<?php
// Helper function to get badge class based on status
function getStatusBadgeClass($status) {
    switch ($status) {
        case 'pending':
            return 'warning';
        case 'confirmed':
            return 'info';
        case 'processing':
            return 'info';
        case 'processing':
            return 'primary';
        case 'shipped':
            return 'secondary';
        case 'delivered':
            return 'success';
        case 'completed':
            return 'success';
       case 'rated':
            return 'success';
        case 'cancelled':
            return 'danger';
        default:
            return 'secondary';
    }
}
?>

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Order Details</h2>
            </div>
        </div>
    </div>

    <!-- Back Button -->
    <div class="row mb-3">
        <div class="col-md-12">
            <a href="<?= base_url('dashboard/orders') ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Orders
            </a>
        </div>
    </div>

    <?php if ($order): ?>

        <?php
        echo "<pre>";
        print_r($order);
        echo "</pre>";
        ?>
        <!-- Order Information Card -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Order Information</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Order ID:</strong></td>
                                <td><?= $this->uri->segment(3) ?></td>
                            </tr>

                            <tr>
                                <td><strong>Date:</strong></td>
                                <td>
                                    <?php 
                                    if (isset($order['date'])) {
                                        echo date('M d, Y H:i:s', $order['date'] / 1000);
                                    } else {
                                        echo 'N/A';
                                    }
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Status:</strong></td>
                                <td>
                                    <span class="badge badge-<?= getStatusBadgeClass($order['orderStatus'] ?? 'pending') ?>">
                                        <?= ucfirst($order['orderStatus'] ?? 'pending') ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Total Amount:</strong></td>
                                <td>
                                    <?php 
                                    if (isset($order['totalAmount'])) {
                                        echo '$' . number_format($order['totalAmount'], 2);
                                    } else {
                                        echo 'N/A';
                                    }
                                    ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Customer Name:</strong></td>
                                <td>
                                    <?php 
                                    if (isset($order['userId'])) {
                                        $user=$this->common->readdatadocument('Users', $order['userId']);
                                        echo $user['userName'];
                                    }  else {
                                        echo 'N/A';
                                    }
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Customer Email:</strong></td>
                                <td><?= $user['email'] ?? 'N/A' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Customer Phone:</strong></td>
                                <td><?= $user['phoneNumber'] ?? 'N/A' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Payment Method:</strong></td>
                                <td><?= ucfirst($order['paymentMethod'] ?? 'N/A') ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Shipping Information Card -->
        <?php if (isset($order['address'])): ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Shipping Information</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Address:</strong></td>
                                <td><?= $order['address']['address'] ?? 'N/A' ?></td>
                            </tr>
                            <tr>
                                <td><strong>City:</strong></td>
                                <td><?= $order['address']['city'] ?? 'N/A' ?></td>
                            </tr>
                            <tr>
                                <td><strong>State:</strong></td>
                                <td><?= $order['address']['state'] ?? 'N/A' ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Postal Code:</strong></td>
                                <td><?= $order['address']['zipcode'] ?? 'N/A' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Pincode:</strong></td>
                                <td><?= $order['address']['pincode'] ?? 'N/A' ?></td>
                            </tr>
                           <tr>
                                <td><strong>Recipient:</strong></td>
                                <td><?= $order['address']['name'] ?? 'N/A' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Recipient Phone:</strong></td>
                                <td><?= $order['address']['phoneNumber'] ?? 'N/A' ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Order Items Card -->
        <?php if (isset($order['productsData']) && is_array($order['productsData'])): ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Order Items</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="thead-dark">
                            <tr>
                                <th>Product</th>
                                <th>Quantity</th>
                                <th>Price</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($order['productsData'] as $item): ?>
                                <tr>
                                    <td>
                                        <?php if (isset($item['productName'])): ?>
                                            <?= $item['productName'] ?>
                                       
                                        <?php else: ?>
                                            N/A
                                        <?php endif; ?>
                                    </td>
                                    <td><?= $item['productAmount'] ?? 'N/A' ?></td>
                                    <td>
                                        <?php 
                                        if (isset($item['productPrice'])) {
                                            echo '$' . number_format($item['productPrice'], 2);
                                        } else {
                                            echo 'N/A';
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        if (isset($item['productAmount']) && isset($item['productPrice'])) {
                                            echo '$' . number_format($item['productAmount'] * $item['productPrice'], 2);
                                        } else {
                                            echo 'N/A';
                                        }
                                        ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr class="font-weight-bold">
                                <td colspan="3">Subtotal:</td>
                                <td>
                                    <?php 
                                    if (isset($order['subtotal'])) {
                                        echo '$' . number_format($order['subtotal'], 2);
                                    } else {
                                        echo 'N/A';
                                    }
                                    ?>
                                </td>
                            </tr>
                            <tr class="font-weight-bold">
                                <td colspan="3">Tax:</td>
                                <td>
                                    <?php 
                                    if (isset($order['tax'])) {
                                        echo '$' . number_format($order['tax'], 2);
                                    } else {
                                        echo 'N/A';
                                    }
                                    ?>
                                </td>
                            </tr>
                            <tr class="font-weight-bold">
                                <td colspan="3">Total:</td>
                                <td>
                                    <?php 
                                    if (isset($order['price'])) {
                                        echo '$' . number_format($order['price'], 2);
                                    } else {
                                        echo 'N/A';
                                    }
                                    ?>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Order Actions Card -->
        <div class="card shadow mb-4 d-none">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Order Actions</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Update Status:</h6>
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-warning btn-sm" onclick="updateStatus('pending')">Pending</button>
                            <button type="button" class="btn btn-info btn-sm" onclick="updateStatus('confirmed')">Confirmed</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="updateStatus('processing')">Processing</button>
                            <button type="button" class="btn btn-secondary btn-sm" onclick="updateStatus('shipped')">Shipped</button>
                            <button type="button" class="btn btn-success btn-sm" onclick="updateStatus('delivered')">Delivered</button>
                            <button type="button" class="btn btn-danger btn-sm" onclick="updateStatus('cancelled')">Cancelled</button>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <h6>Other Actions:</h6>
                        <a href="<?= base_url('dashboard/delete_order/' . $this->uri->segment(3)) ?>" 
                           class="btn btn-danger btn-sm" 
                           onclick="return confirm('Are you sure you want to delete this order?')">
                            <i class="fas fa-trash"></i> Delete Order
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Order Notes Card -->
        <?php if (isset($order['notes']) && !empty($order['notes'])): ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Order Notes</h6>
            </div>
            <div class="card-body">
                <p><?= nl2br($order['notes']) ?></p>
            </div>
        </div>
        <?php endif; ?>

    <?php else: ?>
        <div class="card shadow mb-4">
            <div class="card-body text-center">
                <h4>Order not found</h4>
                <p>The order you're looking for doesn't exist or has been deleted.</p>
                <a href="<?= base_url('dashboard/orders') ?>" class="btn btn-primary">Back to Orders</a>
            </div>
        </div>
    <?php endif; ?>

</div>
<!-- /.container-fluid -->

<script>
function updateStatus(status) {
    if (confirm('Are you sure you want to update the order status to ' + status + '?')) {
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?= base_url('dashboard/update_order_status') ?>';
        
        var orderIdInput = document.createElement('input');
        orderIdInput.type = 'hidden';
        orderIdInput.name = 'order_id';
        orderIdInput.value = '<?= $this->uri->segment(3) ?>';
        
        var statusInput = document.createElement('input');
        statusInput.type = 'hidden';
        statusInput.name = 'status';
        statusInput.value = status;
        
        form.appendChild(orderIdInput);
        form.appendChild(statusInput);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

