<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Login extends CI_Controller
{
	//To load initial libraries, functions
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('directory');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('common');
		$this->load->model('customer_model');
		$this->load->library('session');
		// $this->load->database();
	}
	//To load login page
	public function index()    //Login Controller
	{
		// print_r($this->session->userdata('session_data'));
		// exit;
		if (!empty($this->session->userdata('session_data'))) {
			$url = base_url('dashboard');
			header("location: $url");
		} else {
			$this->load->view('login');
		}
	}

		//To load login page
		public function register()    //Login Controller
		{
			// print_r($this->session->userdata('session_data'));
			// exit;
			if (!empty($this->session->userdata('session_data'))) {
				$url = base_url('dashboard');
				header("location: $url");
			} else {
				$this->load->view('register');
			}
		}
		

		public function Registerpharmacy()    //Login Controller
		{
			$data=$this->input->post();
			// print_r($data);
			// exit;
			// print_r($this->session->userdata('session_data'));
			// exit;
			$data["userRole"] = "pharmist";
			$data["image"] ="" ;
		
			$response = $this->customer_model->add_customer($data);
			if ($response) {
				$this->session->set_flashdata('successmessage', 'New customer added successfully');
				redirect(base_url('dashboard'));			
			} else {
				$errormsg = 'Error! User already Exists.';
				$this->session->set_flashdata('warningmessage', $errormsg);
				redirect('Login/register');
			}
		}

	//To login functionality check
	public function login_action()
	{
		// print_r("hello");
		// exit;
		$email = $this->input->post("email");
		$password = $this->input->post("password");

		$firebase = $this->firebase->init();

		$auth = $firebase->createAuth();

		try{
		$signInResult = $auth->signInWithEmailAndPassword($email, $password);
	
		}catch (FirebaseException $e) {
		 	$this->session->set_flashdata('warningmessage', 'Invalid email and/or password !');
		 	redirect(base_url('login'));
		 }
		$my = $signInResult->data();
		$Id=$my['localId'];
		$userdata=$this->common->readdatadocument("Users",$Id);
		 if($userdata==""){
			$this->session->set_flashdata('warningmessage', 'Invalid email and/or password !');
			redirect(base_url('login'));
		 }else{
			$session_data = array(
				'userId' => $Id,
				'name' => $userdata["firstName"]." ".$userdata["lastName"],
				'email' => $userdata["email"],
				'permissions' => 'all',
				'firebaseToken' => ''
			);
			$this->session->set_userdata('session_data', $session_data);
			$this->session->set_userdata('authenthicate', true);
		
			redirect(base_url('dashboard'));			


		 }

	}

	//To logout session from browser
	public function logout()
	{
		// Removing session data
		$sess_array = array('userId' => '');
		$this->session->unset_userdata('session_data', $sess_array);
		$this->session->sess_destroy();
		$this->session->set_flashdata('successmessage', 'Successfully Logged out !');
		redirect('login');
	}
}
