<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Category extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->model('common');
    $this->load->helper(array('form', 'url', 'string'));
    $this->load->library('form_validation');
    $this->load->library('session');
  }

  public function index()
  {
    $data['categorieslist'] = $this->common->readdatafromcollectionwhereclause("Categories");
    foreach ($data['categorieslist'] as $id => $category) {
      $data["products"][$id] = ($this->common->readnumberofdocumentsincollectionbetween("Products", "proCategory", "=", $category['name']));
    }
    $this->template->template_render('category_management', $data);
  }

  public function addcategory()
  {
    $this->template->template_render('category_add');
  }

  public function insertcategory()
  {

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $data = $this->input->post();

    if ($_FILES['image']['tmp_name'] != '') {
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['image']['tmp_name']),
        [
          'name' => "categoryImage" . rand() . time() . $_FILES['image']['name'],
        ]
      );
      $data['imageUrl'] = $uploadedFile->info()['mediaLink'];
    }

    if (isset($_POST)) {
      $categoryId = time();
      $response = $this->common->adddatamodel("Categories", $categoryId, $data);
      if ($response) {
        $this->session->set_flashdata('successmessage', 'New category added successfully..');
      } else {
        $this->session->set_flashdata('warningmessage', 'Error in creating new category..');
      }
      redirect('category');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
      redirect('category');
    }
  }

  public function editcategory()
  {
    $id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['categorydetails'] = $this->common->readdatadocument("Categories", $id);
    $this->template->template_render('editcategory', $data);
  }

  public function deletecategory()
  {
    $id = $this->uri->segment(3);
    $response = $this->common->deletedatamodel("Categories", $id);
    if ($response) {
      $this->session->set_flashdata('successmessage', 'category deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error in deleting category..');
    }
    redirect('category');
  }

  public function updatecategorydata()
  {
    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $id = $this->uri->segment(3);
    $data = $this->input->post();
    if ($_FILES['image']['tmp_name'] != '') {
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['image']['tmp_name']),
        [
          'name' => "categoryImage" . rand() . time() . $_FILES['image']['name'],
        ]
      );
      $data['imageUrl'] = $uploadedFile->info()['mediaLink'];
    }
    if (isset($_POST)) {
      $response = $this->common->updatedatamodel("Categories", $id, $data);
      if ($response) {
        $this->session->set_flashdata('successmessage', 'category updated successfully..');
        redirect('category');
      } else {
        $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
        redirect('category');
      }
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
      redirect('category');
    }
  }
}
