<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('session');
        $this->load->model('dashboard_model');
        $this->load->model('common');
        $this->load->model('geofence_model');
        // $this->load->database();
    }

    public function index()
    {
        $data["usersCount"] = ($this->common->readnumberofdocumentsincollectionbetween("users", "userType", "=", "User"));
        $data["categoriesCount"] = $this->common->readnumberofdocumentsincollectionbetween("Categories");
        $data["productsCount"] = $this->common->readnumberofdocumentsincollectionbetween("Products");
        $data['vendorcount'] = ($this->common->readnumberofdocumentsincollectionbetween("users", "userType", "=", "Pro"));
        // print_r($data);
        $this->template->template_render('dashboard', $data);
    }

    public function feedback()
    {
        $data["feedbacks"] = ($this->common->readdatafromcollectionwhereclause("Feedback"));
        $this->template->template_render('feedback_management', $data);
    }



    public function iechart()
    {
        $data = $this->common->get_iechartdata();
        $res = "['" . implode("', '", array_keys($data)) . "']";
        $income = "['" . implode("', '", array_column($data, 'income')) . "']";
        $expense = "['" . implode("', '", array_column($data, 'expense')) . "']";
        echo json_encode(array('res' => $res, 'income' => $income, 'expense' => $expense));
    }
    public function remindermark()
    {
        $data = array('r_isread' => 1);
        $this->db->where('r_id', $this->input->post('r_id'));
        echo $this->db->update('reminder', $data);
    }
}
