<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
    .image-placeholder {
        width: 100%;
        height: 200px;
        background-color: #e9ecef;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        color: #6c757d;
        border: 1px solid #dee2e6;
    }

    .image-placeholder img {
        max-height: 100%;
        max-width: 100%;
        object-fit: contain;
    }

    .custom-bg {
        background-color: #d4fc79 !important;
    }

    .btn-custom {
        background-color: #d4fc79 !important;
        border-color: #d4fc79 !important;
        color: black !important;
    }
</style>

<div class="container mt-4">
    <h2 class="mb-4 text-center">Admin Portal - App Settings</h2>



    <!-- Initial Screen Image -->
    <div class="card mb-4">
        <div class="card-header custom-bg text-dark">Initial Screen Image</div>
        <div class="card-body text-center">
            <div class="image-placeholder" id="initialPreview">Initial Screen</div>
            <input type="file" class="form-control mt-3" id="initialImage">
        </div>
    </div>

    <!-- Login Page Image -->
    <div class="card mb-4">
        <div class="card-header custom-bg text-dark">Login Page Image</div>
        <div class="card-body text-center">
            <div class="image-placeholder" id="loginPreview">Login Screen</div>
            <input type="file" class="form-control mt-3" id="loginImage">
        </div>
    </div>

    <!-- Signup Page Image -->
    <div class="card mb-4">
        <div class="card-header custom-bg text-dark">Signup Page Image</div>
        <div class="card-body text-center">
            <div class="image-placeholder" id="signupPreview">Signup Screen</div>
            <input type="file" class="form-control mt-3" id="signupImage">
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header custom-bg text-dark">Home Screen Title</div>
        <div class="card-body text-center">
            <!-- <div >Home Screen Heading</div> -->
            <input type="text" class="form-control mb-3" id="homeTitle" placeholder="Home Page Title">
        </div>
    </div>

    <!-- Home Page Cover Images -->
    <div class="card mb-4">
        <div class="card-header custom-bg text-dark">Home Page - Cover Images</div>
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-md-6 text-center">
                    <label for="coverImage1" class="form-label">Cover Image 1:</label>
                    <div class="image-placeholder mb-2" id="coverPreview1">Cover Image 1 Preview</div>
                    <input type="file" class="form-control" id="coverImage1">
                </div>
                <div class="col-md-6 text-center">
                    <label for="coverImage2" class="form-label">Cover Image 2:</label>
                    <div class="image-placeholder mb-2" id="coverPreview2">Cover Image 2 Preview</div>
                    <input type="file" class="form-control" id="coverImage2">
                </div>
            </div>
        </div>


        <div class="text-center mb-5">
            <button class="btn btn-custom btn-lg" id="updateSettings">Save Changes</button>
        </div>
    </div>

</div>

<script>
    function previewImage(input, previewContainerId) {
        const file = input.files[0];
        const reader = new FileReader();
        reader.onload = function(e) {
            $(`#${previewContainerId}`).html(`<img src="${e.target.result}" alt="Preview">`);
        }
        if (file) {
            reader.readAsDataURL(file);
        }
    }

    $('#initialImage').on('change', function() {
        previewImage(this, 'initialPreview');
    });

    $('#loginImage').on('change', function() {
        previewImage(this, 'loginPreview');
    });

    $('#signupImage').on('change', function() {
        previewImage(this, 'signupPreview');
    });

    $('#saveBooks').click(function() {
        const title = $('#homeTitle').val();
        const book1 = $('#book1Select').val();
        const book2 = $('#book2Select').val();

        const previewHtml = `
            <h5>${title}</h5>
            <ul class="list-group">
                <li class="list-group-item">📘 ${book1}</li>
                <li class="list-group-item">📙 ${book2}</li>
            </ul>
        `;
        $('#booksPreview').html(previewHtml);
    });
</script>

<script>
    function previewImage(input, previewId) {
        const file = input.files[0];
        const reader = new FileReader();
        reader.onload = function(e) {
            $(`#${previewId}`).html(`<img src="${e.target.result}" alt="Preview">`);
        };
        if (file) {
            reader.readAsDataURL(file);
        }
    }

    $('#coverImage1').on('change', function() {
        previewImage(this, 'coverPreview1');
    });

    $('#coverImage2').on('change', function() {
        previewImage(this, 'coverPreview2');
    });
</script>