<div class="container mt-5">
        <h2 class="mb-4">Earnings and Payment Settings</h2>

        <!-- Earnings Breakdown -->
        <div class="card mb-4">
            <div class="card-header">
                <h5>Earnings Breakdown</h5>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Book Title</th>
                            <th>Royalty Percentage</th>
                            <th>Earnings</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Dummy Data -->
                        <tr>
                            <td>1</td>
                            <td>The Adventure Begins</td>
                            <td>70%</td>
                            <td>$1,200</td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td>Learn to Code</td>
                            <td>50%</td>
                            <td>$800</td>
                        </tr>
                        <tr>
                            <td>3</td>
                            <td>Cooking with Love</td>
                            <td>60%</td>
                            <td>$950</td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="3" class="text-right">Total Earnings:</th>
                            <th>$2,950</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Payment Preferences -->
        <div class="card">
            <div class="card-header">
                <h5>Payment Preferences</h5>
            </div>
            <div class="card-body">
                <form id="paymentPreferencesForm">
                    <!-- Payment Method -->
                    <div class="form-group">
                        <label for="paymentMethod">Preferred Payment Method</label>
                        <select class="form-control" id="paymentMethod" required>
                            <option value="">Select Payment Method</option>
                            <option value="bank">Bank Transfer</option>
                            <option value="paypal">PayPal</option>
                        </select>
                    </div>

                    <!-- Bank Details (Conditional) -->
                    <div id="bankDetails" style="display: none;">
                        <div class="form-group">
                            <label for="bankName">Bank Name</label>
                            <input type="text" class="form-control" id="bankName" placeholder="Enter your bank name">
                        </div>
                        <div class="form-group">
                            <label for="accountNumber">Account Number</label>
                            <input type="text" class="form-control" id="accountNumber" placeholder="Enter your account number">
                        </div>
                        <div class="form-group">
                            <label for="ifscCode">IFSC Code</label>
                            <input type="text" class="form-control" id="ifscCode" placeholder="Enter IFSC code">
                        </div>
                    </div>

                    <!-- PayPal Details (Conditional) -->
                    <div id="paypalDetails" style="display: none;">
                        <div class="form-group">
                            <label for="paypalEmail">PayPal Email</label>
                            <input type="email" class="form-control" id="paypalEmail" placeholder="Enter your PayPal email">
                        </div>
                    </div>

                    <!-- Save Button -->
                    <button type="submit" class="btn btn-primary">Save Payment Preferences</button>
                </form>
            </div>
        </div>
    </div>