<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'welcome';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

//home controller routes
$route['home/eligibility'] = 'HomeController';
$route['home/about-us'] = 'HomeController/aboutUs';
$route['home/delivery'] = 'HomeController/deliveryPage';
$route['home/contact-us'] = 'HomeController/contactUs';
$route['home/how-it-works'] = 'HomeController/howItWorks';
$route['home/reviews'] = 'HomeController/reviews';
$route['home/faqs'] = 'HomeController/faqs';
$route['home/user-account'] = 'HomeController/accountPage';
$route['home/calculate-BMI'] = 'HomeController/calculateBMI';
$route['home/product-detail'] = 'HomeController/productDetail';

//user account routes
// Login and Logout endpoints
$route['home/login'] = 'HomeController/login';
$route['home/logout'] = 'HomeController/logout';

// Create account endpoint
$route['home/createAccount'] = 'HomeController/createAccount';



//eligibility form submission routes
$route['recommend/product/(:any)'] = 'HomeController/recommendedProduct/$1';
$route['api/submit'] = 'HomeController/submit';
$route['api/check-email'] = 'HomeController/checkEmail';
$route['api/create-account'] = 'HomeController/createAccount';
$route['api/submit'] = 'HomeController/submit';

//
$route['stripe/checkout'] = 'StripeController/checkout';
$route['stripe/success'] = 'StripeController/success';
$route['stripe/cancel'] = 'StripeController/cancel';

// $route['order/upload_pictures'] = 'OrderController/upload_pictures';
$route['order/upload_pictures/(:any)'] = 'OrderController/upload_pictures/$1';


$route['order/place_order'] = 'OrderController/place_order';
$route['order/success'] = 'OrderController/order_success';


$route['firebasetest'] = 'firebasetest/index';


//admin routes
$route['admin'] = 'AdminController/index';
$route['admin/customers'] = 'AdminController/Customers';
$route['admin/updateCustomerStatus'] = 'AdminController/updateCustomerStatus';
$route['admin/products'] = 'AdminController/Products';
$route['admin/orders'] = 'AdminController/Orders';
$route['admin/order-details/(:any)'] = 'AdminController/OrderDetails/$1';


$route['order/test'] = 'AdminController/test_add_orders';

// Products Management Routes
$route['admin/products'] = 'Products/index';
$route['admin/products/get-all'] = 'Products/get_all';
$route['admin/products/add'] = 'Products/add';
$route['admin/products/update/(:any)'] = 'Products/update/$1';
$route['admin/products/delete/(:any)'] = 'Products/delete/$1';
$route['admin/products/toggle-status/(:any)'] = 'Products/toggle_status/$1';
$route['admin/upload-image'] = 'Products/upload_image';


//single order (AJAX)
$route['admin/orders/get/(:any)'] = 'OrderController/get/$1';

// Update order status
$route['admin/orders/update-status/(:any)'] = 'OrderController/update_status/$1';

// Accept order
$route['admin/orders/accept/(:any)'] = 'OrderController/accept/$1';

// Reject order
$route['admin/orders/reject/(:any)'] = 'OrderController/reject/$1';

// Delete order (optional)
$route['admin/orders/delete/(:any)'] = 'OrderController/delete/$1';

// Admin login routes
$route['admin/login'] = 'AdminController/login';
$route['admin/login/submit'] = 'AdminController/postLogin';
$route['admin/logout'] = 'AdminController/logout';
$route['admin/update-password'] = 'AdminController/updatePassword';
$route['admin/profile'] = 'AdminController/accountPage';
