<?php
defined('BASEPATH') or exit('No direct script access allowed');

class HomeController extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('firebase');
        $this->load->library('session');
    }
    public function index()
    {


        $this->load->view('layout/app', ['content' => $this->load->view('pages/eligibility', [], true)]);
    }

    public function recommendedProduct($id)
    {
        //the  id is basically the Customer_data_id which then take a product thats recommened base on questions
        // Load the Stripe config
        $this->config->load('stripe', TRUE);
        $publishable_key = $this->config->item('stripe_publishable_key', 'stripe');

        $recommendedProduct = $this->getRecommenedProduct("9406223a23514993bdc1");


        // Load the product page view and pass the publishable key
        $this->load->view('layout/app', [
            'content' => $this->load->view('pages/product', [
                'stripe_publishable_key' => $publishable_key,
                'recommendedProduct' => $recommendedProduct,
                'Customer_data_id' => $id
            ], true)
        ]);
    }
    public function getRecommenedProduct($id)
    {
        try {
            // Initialize Firestore
            $firestore = $this->firebase->getFirestore();

            // Reference the Customer_data collection and get the document by ID
            $docRef = $firestore->collection('Products')->document($id);
            $snapshot = $docRef->snapshot();

            if ($snapshot->exists()) {
                // If the document exists, return its data
                return [
                    'id' => $id,
                    'data' => $snapshot->data()
                ];
            } else {
                // If document doesn't exist, handle gracefully
                return [
                    'id' => $id,
                    'error' => true,
                    'message' => 'Recommended product not found for this ID.'
                ];
            }
        } catch (Exception $e) {
            // Handle errors like network issues or Firestore errors
            return [
                'id' => $id,
                'error' => true,
                'message' => 'Error fetching recommended product: ' . $e->getMessage()
            ];
        }
    }


    public function submit()
    {
        try {
            // Get form data from POST request
            $formData = $this->input->post();


            // If data comes as JSON (fetch API se)
            if (empty($formData)) {
                $jsonData = file_get_contents('php://input');
                $formData = json_decode($jsonData, true);
            }

            // Validate data
            if (empty($formData)) {
                throw new Exception('No form data received');
            }

            // Process and sanitize all form fields
            $processedData = $this->processFormData($formData);

            $user_id = $this->session->userdata('user_id') ?? null;
            if ($user_id) {
                $processedData['user_id'] = $user_id;
            }
            // Add timestamps
            $processedData['created_at'] = round(microtime(true) * 1000); // Milliseconds
            $processedData['updated_at'] = null;

            // Firebase Firestore mein save karein
            $firestore = $this->firebase->getFirestore();

            // New document create karein with auto-generated ID
            $docRef = $firestore->collection('Customer_data')->add($processedData);


            // Get the auto-generated document ID
            $submissionId = $docRef->id();

            // Success response
            $response = [
                'success' => true,
                'message' => 'Form successfully submitted!',
                'Customer_data_id' => $submissionId,
                // 'redirect' => base_url('recommend/product')
                'redirect' => base_url('recommend/product/' . $submissionId)

            ];

            echo json_encode($response);
        } catch (Exception $e) {
            // Error handling - return same data for auto-fill
            $response = [
                'success' => false,
                'message' => 'Submission failed: ' . $e->getMessage(),
                'form_data' => $formData ?? [],
                'error' => true
            ];

            http_response_code(500);
            echo json_encode($response);
        }
    }
    // Check if email exists
    public function checkEmail()
    {
        $email = $this->input->post('email');
        $email = filter_var(trim($email), FILTER_VALIDATE_EMAIL);

        if (!$email) {
            echo json_encode(['success' => false, 'message' => 'Invalid email']);
            return;
        }

        try {
            $firestore = $this->firebase->getFirestore();
            $usersRef = $firestore->collection('Users');
            $query = $usersRef->where('email', '=', $email)->limit(1)->documents();

            foreach ($query as $doc) {
                if ($doc->exists()) {
                    $user = $doc->data();
                    echo json_encode([
                        'success' => true,
                        'exists' => true,
                        'user_id' => $doc->id(),
                        'isActive' => $user['isActive'] ?? true
                    ]);
                    return;
                }
            }

            // Email not found
            echo json_encode(['success' => true, 'exists' => false]);
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    // Create a new user account// Create a new user account
    public function createAccount()
    {
        $data = json_decode(file_get_contents('php://input'), true);

        // Basic validation
        if (empty($data['name']) || empty($data['email']) || empty($data['password']) || empty($data['phone'])) {
            echo json_encode(['success' => false, 'message' => 'Missing required fields']);
            return;
        }

        $email = filter_var(trim($data['email']), FILTER_VALIDATE_EMAIL);
        if (!$email) {
            echo json_encode(['success' => false, 'message' => 'Invalid email address']);
            return;
        }

        try {
            $firestore = $this->firebase->getFirestore();
            $usersRef = $firestore->collection('Users');

            // 🔹 1️⃣ Check if email already exists
            $query = $usersRef->where('email', '=', $email)->limit(1)->documents();
            foreach ($query as $doc) {
                if ($doc->exists()) {
                    echo json_encode(['success' => false, 'message' => 'An account with this email already exists.']);
                    return;
                }
            }

            // 🔹 2️⃣ Create the new user document
            $newUser = [
                'name' => htmlspecialchars($data['name'], ENT_QUOTES, 'UTF-8'),
                'email' => strtolower($email),
                'password' => $data['password'],
                'phone' => htmlspecialchars($data['phone'], ENT_QUOTES, 'UTF-8'),
                'isActive' => true,
                'userType' => 'customer',
                'created_at' => round(microtime(true) * 1000)
            ];

            $docRef = $usersRef->add($newUser);

            // 🔹 3️⃣ Automatically create session (auto-login)
            $this->session->set_userdata([
                'user_id' => $docRef->id(),
                'name' => $newUser['name'],
                'email' => $newUser['email'],
                'phone' => $newUser['phone']
            ]);

            // 🔹 4️⃣ Send success response
            echo json_encode([
                'success' => true,
                'user_id' => $docRef->id(),
                'message' => 'Account created successfully. You are now logged in.'
            ]);
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }



    // Form data processing function
    private function processFormData($rawData)
    {
        $processed = [];

        // Step 1: Customer Type
        $processed['customer_type'] = isset($rawData['customer']) ? $this->sanitizeInput($rawData['customer']) : null;

        // Step 2: Existing Customer Email (if applicable)
        if (isset($rawData['existingEmail'])) {
            $processed['existing_email'] = $this->sanitizeEmail($rawData['existingEmail']);
        }

        // Step 3: Treatment Type
        $processed['treatment_type'] = isset($rawData['treatment_type']) ? $this->sanitizeInput($rawData['treatment_type']) : null;

        // Step 4: Height & Weight
        $processed['height'] = $this->processHeightData($rawData);
        $processed['weight'] = $this->processWeightData($rawData);

        // Step 5: Medical Conditions
        $processed['medical_conditions'] = isset($rawData['conditions']) ? $this->processArrayData($rawData['conditions']) : [];

        // Step 6: Ethnicity
        $processed['ethnicity'] = isset($rawData['ethnicity']) ? $this->sanitizeInput($rawData['ethnicity']) : null;

        // Step 7: Age
        $processed['age'] = isset($rawData['age']) ? $this->sanitizeInput($rawData['age']) : null;

        // Step 8: Allergic Reactions
        $processed['allergies'] = isset($rawData['allergy']) ? $this->processArrayData($rawData['allergy']) : [];

        // Step 9: Pregnancy
        $processed['pregnancy_status'] = isset($rawData['pregnancy']) ? $this->sanitizeInput($rawData['pregnancy']) : null;

        // Step 10: Medical History
        $processed['medical_history'] = isset($rawData['medical_history']) ? $this->processArrayData($rawData['medical_history']) : [];

        // Step 11: Thyroid/Liver Disease
        $processed['thyroid_liver_disease'] = isset($rawData['thyroid_liver_disease']) ? $this->sanitizeInput($rawData['thyroid_liver_disease']) : null;

        // Step 12: Gallbladder Issues
        $processed['gallbladder_issues'] = isset($rawData['gallbladder_issues']) ? $this->sanitizeInput($rawData['gallbladder_issues']) : null;

        // Step 13: Other Health Issues
        $processed['other_health_issues'] = isset($rawData['other_health_issues']) ? $this->processArrayData($rawData['other_health_issues']) : [];

        // Step 14: Insulin Use
        $processed['insulin_use'] = isset($rawData['insulin_use']) ? $this->sanitizeInput($rawData['insulin_use']) : null;

        // Step 15: Other Diabetes Medication
        $processed['other_diabetes_med'] = isset($rawData['other_diabetes_med']) ? $this->sanitizeInput($rawData['other_diabetes_med']) : null;

        // Step 16: Current Medications
        $processed['current_medications'] = isset($rawData['medication_use']) ? $this->sanitizeInput($rawData['medication_use']) : null;

        // Step 17: Smoking
        $processed['smoking_status'] = isset($rawData['smoker']) ? $this->sanitizeInput($rawData['smoker']) : null;

        // Step 18: Recent Medication
        $processed['recent_weightloss_med'] = isset($rawData['recent_medication']) ? $this->sanitizeInput($rawData['recent_medication']) : null;

        // Step 19: Dose Understanding
        $processed['dose_understanding'] = isset($rawData['dose_understanding']) ? $this->sanitizeInput($rawData['dose_understanding']) : null;

        // Step 20: Contraceptive Agreement
        $processed['contraceptive_agreement'] = isset($rawData['contraceptive_agreement']) ? $this->sanitizeInput($rawData['contraceptive_agreement']) : null;

        // Step 21: Information Agreement
        $processed['information_agreement'] = isset($rawData['agreement_confirmation']) ? $this->sanitizeInput($rawData['agreement_confirmation']) : null;

        // Step 22: Treatment Information
        $processed['treatment_agreement'] = isset($rawData['treatment_agreement']) ? $this->sanitizeInput($rawData['treatment_agreement']) : null;

        // Step 23: Final Consent
        $processed['final_consent'] = isset($rawData['final_consent']) ? $this->sanitizeInput($rawData['final_consent']) : null;

        // Step 24: Assisted Prescribing
        $processed['assisted_prescribing'] = isset($rawData['assisted_prescribing']) ? $this->sanitizeInput($rawData['assisted_prescribing']) : null;

        // Step 25: Privacy
        $processed['privacy_consent'] = isset($rawData['privacy_consent']) ? $this->sanitizeInput($rawData['privacy_consent']) : null;

        // Step 26: Terms
        $processed['terms_consent'] = isset($rawData['terms_consent']) ? $this->sanitizeInput($rawData['terms_consent']) : null;

        return $processed;
    }

    // Height data processing
    private function processHeightData($data)
    {
        $height = [];

        // Check if using CM or Feet/Inches
        if (isset($data['heightCm']) && !empty($data['heightCm'])) {
            $height['value'] = floatval($data['heightCm']);
            $height['unit'] = 'cm';
            $height['type'] = 'metric';
        } elseif (isset($data['heightFeet']) && isset($data['heightInches'])) {
            $height['feet'] = intval($data['heightFeet']);
            $height['inches'] = floatval($data['heightInches']);
            $height['unit'] = 'ft_in';
            $height['type'] = 'imperial';

            // Calculate total inches for easy conversion
            $height['total_inches'] = ($height['feet'] * 12) + $height['inches'];
        }

        return !empty($height) ? $height : null;
    }


    // Weight data processing
    private function processWeightData($data)
    {
        $weight = [];

        // Check if using KG or Stone/Pounds
        if (isset($data['weightKg']) && !empty($data['weightKg'])) {
            $weight['value'] = floatval($data['weightKg']);
            $weight['unit'] = 'kg';
            $weight['type'] = 'metric';
        } elseif (isset($data['weightStone']) && isset($data['weightPound'])) {
            $weight['stone'] = intval($data['weightStone']);
            $weight['pounds'] = floatval($data['weightPound']);
            $weight['unit'] = 'st_lb';
            $weight['type'] = 'imperial';

            // Calculate total pounds for easy conversion
            $weight['total_pounds'] = ($weight['stone'] * 14) + $weight['pounds'];
        }

        return !empty($weight) ? $weight : null;
    }

    // Process array data (checkboxes)
    private function processArrayData($arrayData)
    {
        if (empty($arrayData)) return [];

        // If it's a single value, convert to array
        if (!is_array($arrayData)) {
            return [$this->sanitizeInput($arrayData)];
        }

        // Sanitize each array element
        return array_map([$this, 'sanitizeInput'], $arrayData);
    }

    // Sanitize input
    private function sanitizeInput($input)
    {
        if (is_array($input)) {
            return array_map([$this, 'sanitizeInput'], $input);
        }

        $input = trim($input);
        $input = stripslashes($input);
        $input = htmlspecialchars($input, ENT_QUOTES, 'UTF-8');

        return $input;
    }

    // Sanitize email
    private function sanitizeEmail($email)
    {
        $email = filter_var($email, FILTER_SANITIZE_EMAIL);
        return filter_var($email, FILTER_VALIDATE_EMAIL) ? $email : null;
    }

    public function aboutUs()
    {


        $this->load->view('layout/app', ['content' => $this->load->view('pages/about_us', [], true)]);
    }

    public function deliveryPage()
    {


        $this->load->view('layout/app', ['content' => $this->load->view('pages/delivery_page', [], true)]);
    }

    public function contactUs()
    {


        $this->load->view('layout/app', ['content' => $this->load->view('pages/contact_us', [], true)]);
    }
    public function howItWorks()
    {
        $this->load->view('layout/app', ['content' => $this->load->view('pages/how_it_works', [], true)]);
    }

    public function accountPage()
    {
        $user = $this->session->userdata();

        // Check if user is logged in
        $isLoggedIn = !empty($user['user_id']);
        $orders = [];

        if ($isLoggedIn) {
            // Load user’s orders (for now using your sample data)
            $orders = $this->getUserOrders($user['user_id']);
        }

        // Pass both $user and $orders to the view
        $this->load->view('layout/app', [
            'content' => $this->load->view('pages/account_page', [
                'user' => $user,
                'orders' => $orders,
                'isLoggedIn' => $isLoggedIn
            ], true)
        ]);
    }

    public function faqs()
    {
        $this->load->view('layout/app', ['content' => $this->load->view('pages/faqs', [], true)]);
    }
    public function reviews()
    {
        $this->load->view('layout/app', ['content' => $this->load->view('pages/review_page', [], true)]);
    }

    public function calculateBMI()
    {
        $this->load->view('layout/app', ['content' => $this->load->view('pages/bmi_calculator', [], true)]);
    }
    public function productDetail()
    {
        $this->load->view('layout/app', ['content' => $this->load->view('pages/product_detail', [], true)]);
    }

    public function login()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        $email = trim($data['email'] ?? '');
        $password = trim($data['password'] ?? '');

        if (!$email || !$password) {
            echo json_encode(['success' => false, 'message' => 'Email and password required']);
            return;
        }

        try {
            $firestore = $this->firebase->getFirestore();
            $usersRef = $firestore->collection('Users');
            $query = $usersRef->where('email', '=', $email)->limit(1)->documents();

            foreach ($query as $doc) {
                if ($doc->exists()) {
                    $user = $doc->data();

                    // For demo: direct compare. (In production: use password_hash / verify)
                    if ($user['password'] === $password) {
                        // Save session
                        $this->session->set_userdata([
                            'user_id' => $doc->id(),
                            'name' => $user['name'],
                            'email' => $user['email'],
                            'phone' => $user['phone']
                        ]);

                        echo json_encode(['success' => true, 'message' => 'Login successful']);
                        return;
                    } else {
                        echo json_encode(['success' => false, 'message' => 'Invalid password']);
                        return;
                    }
                }
            }

            echo json_encode(['success' => false, 'message' => 'User not found']);
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        }
    }


    // GET: /home/logout
    public function logout()
    {

        // Optionally, set a flash message
        $this->session->set_flashdata('success', 'You have been logged out successfully.');

        $this->session->sess_destroy();
        redirect(base_url('home/user-account'));
    }


    public function getUserOrders($userId)
    {
        try {
            $firestore = $this->firebase->getFirestore();
            $ordersRef = $firestore->collection('Orders');

            // Query orders where user_id == $userId
            $query = $ordersRef->where('user_id', '=', $userId)->documents();

            $formattedOrders = [];

            foreach ($query as $doc) {
                if ($doc->exists()) {
                    $order = $doc->data();
                    $formattedOrders[] = [
                        'order_no'      => $order['order_no'] ?? $doc->id(),
                        'date'          => isset($order['created_at']) ? date('d-M-Y', $order['created_at'] / 1000) : '',
                        'prescription'  => $order['prescription'] ?? '',
                        'status'        => ucfirst($order['status'] ?? 'Pending'),
                        'customer_name' => $order['customer_name'] ?? '',
                        'address'       => $order['address'] ?? '',
                        'phone'         => $order['phone'] ?? '',
                        'images'        => $order['images'] ?? [],
                        'notes'         => $order['notes'] ?? ''
                    ];
                }
            }

            return $formattedOrders;
        } catch (Exception $e) {
            // Optional: log the error or return empty array
            log_message('error', 'Failed to fetch user orders: ' . $e->getMessage());
            return [];
        }
    }
}
