<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once FCPATH . 'vendor/autoload.php'; // load Stripe SDK

class StripeController extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->config('stripe');
        \Stripe\Stripe::setApiKey($this->config->item('stripe_secret_key'));
    }

    public function checkout()
    {
        $price = $this->input->post('price');
        $Customer_data_id = $this->input->post('Customer_data_id');
        $userId = $this->session->userdata('user_id');

        $session = \Stripe\Checkout\Session::create([
            'payment_method_types' => ['card'],
            'line_items' => [[
                'price_data' => [
                    'currency' => 'eur',
                    'product_data' => [
                        'name' => 'Orlistat 120mg',
                        'images' => [base_url('assets/images/p1.png')],
                    ],
                    'unit_amount' => intval($price * 100),
                ],
                'quantity' => 1,
            ]],
            'mode' => 'payment',
            // 'success_url' => base_url('stripe/success'),
            'success_url' => base_url('stripe/success?user_id=' . $userId . '&Customer_data_id=' . $Customer_data_id),

            'cancel_url' => base_url('stripe/cancel'),
        ]);

        echo json_encode(['id' => $session->id]);
    }


    public function success()
    {
        // Get IDs from URL
        $Customer_data_id = $this->input->get('Customer_data_id');
        $user_id = $this->input->get('user_id');

        // Pass them to the view
        $this->load->view('layout/app', [
            'content' => $this->load->view('pages/success', [
                'Customer_data_id' => $Customer_data_id,
                'user_id' => $user_id
            ], true)
        ]);
    }


    public function cancel()
    {
        $this->load->view('cancel'); // create a cancel view
    }
}
