<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once FCPATH . 'vendor/autoload.php';

use Kreait\Firebase\Factory;

class Firebase
{
    protected $factory;
    protected $firestore;
    protected $auth;

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->config->load('firebase', TRUE);

        $serviceAccountPath = $this->CI->config->item('firebase_app_key', 'firebase');

        $this->factory = (new Factory)->withServiceAccount($serviceAccountPath);

        $this->firestore = $this->factory->createFirestore()->database();
        $this->auth = $this->factory->createAuth();
    }

    public function getFirestore()
    {
        return $this->firestore;
    }

    public function auth()
    {
        return $this->auth;
    }

    public function storage()
    {
        return $this->factory->createStorage();
    }
}
