<!-- Main Content -->
<main>
    <!-- Dashboard Content -->
    <div class="content-section" id="dashboard-content">
        <h2 class="mb-4">Dashboard Overview</h2>

        <!-- Stats Grid -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon primary">
                    <i class="fas fa-dollar-sign"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-label">Total Revenue</div>
                    <div class="stat-value">$45,890</div>
                    <div class="stat-change positive">
                        <i class="fas fa-arrow-up"></i> 12.5% from last month
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon success">
                    <i class="fas fa-shopping-bag"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-label">Total Orders</div>
                    <div class="stat-value"><?= isset($recent_orders) ? count($recent_orders) : '0' ?></div>
                    <div class="stat-change positive">
                        <i class="fas fa-arrow-up"></i> 8.2% from last month
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon warning">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-label">Active Users</div>
                    <div class="stat-value">856</div>
                    <div class="stat-change positive">
                        <i class="fas fa-arrow-up"></i> 5.1% from last month
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon danger">
                    <i class="fas fa-chart-pie"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-label">Conversion Rate</div>
                    <div class="stat-value">3.4%</div>
                    <div class="stat-change negative">
                        <i class="fas fa-arrow-down"></i> 2.1% from last month
                    </div>
                </div>
            </div>
        </div>

        <div class="card shadow-sm mt-4">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Recent Orders</h5>
                <a href="<?php echo base_url('admin/orders'); ?>" class="btn btn-sm btn-primary">View All</a>
            </div>

            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Order ID</th>
                                <th>Customer</th>
                                <th>City</th>
                                <th>Phone</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php if (!empty($recent_orders)): ?>
                                <?php foreach ($recent_orders as $order): ?>
                                    <tr>
                                        <td>#<?= substr($order['id'], 0, 8) ?></td>
                                        <td><?= htmlspecialchars($order['customer_name'] ?? 'N/A') ?></td>
                                        <td><?= htmlspecialchars($order['city'] ?? '-') ?></td>
                                        <td><?= htmlspecialchars($order['phone'] ?? '-') ?></td>
                                        <td>
                                            <?php
                                            $status = strtolower($order['status'] ?? 'pending');
                                            switch ($status) {
                                                case 'accepted':
                                                case 'completed':
                                                    $badge_class = 'bg-success';
                                                    break;
                                                case 'rejected':
                                                    $badge_class = 'bg-danger';
                                                    break;
                                                case 'pending':
                                                    $badge_class = 'bg-warning text-dark';
                                                    break;
                                                default:
                                                    $badge_class = 'bg-secondary';
                                            }
                                            ?>
                                            <span class="badge <?= $badge_class ?> px-3 py-2 rounded-pill">
                                                <?= ucfirst($status) ?>
                                            </span>
                                        </td>
                                        <td><?= date('M d, Y h:i A', ($order['created_at'] ?? time()) / 1000) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" class="text-center text-muted py-4">
                                        No recent orders found.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</main>

<!-- Minimal CSS -->
<style>
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 1.5rem;
    }

    .stat-card {
        background: #fff;
        border-radius: 16px;
        padding: 20px;
        display: flex;
        align-items: center;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 15px;
        color: #fff;
    }

    .stat-icon.primary {
        background: #007bff;
    }

    .stat-icon.success {
        background: #28a745;
    }

    .stat-icon.warning {
        background: #ffc107;
        color: #000;
    }

    .stat-icon.danger {
        background: #dc3545;
    }

    .content-card {
        background: #fff;
        border-radius: 16px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    }

    .status-badge {
        padding: 5px 10px;
        border-radius: 12px;
        font-size: 0.85rem;
        color: #fff;
        text-transform: capitalize;
    }

    .status-badge.success {
        background-color: #28a745;
    }

    .status-badge.danger {
        background-color: #dc3545;
    }

    .status-badge.warning {
        background-color: #ffc107;
        color: #000;
    }

    .status-badge.secondary {
        background-color: #6c757d;
    }
</style>