<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($page_title) ? $page_title . ' - ' : '' ?>Ritecare Admin</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        :root {
            --sidebar-width: 260px;
            --header-height: 70px;
            --primary-color: #4e73df;
            --secondary-color: #858796;
            --success-color: #1cc88a;
            --danger-color: #e74a3b;
            --warning-color: #f6c23e;
            --sidebar-bg: #1a1d2e;
            --sidebar-hover: #252a3d;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fc;
            overflow-x: hidden;
        }

        /* Header */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: var(--header-height);
            background: #fff;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            z-index: 1000;
            transition: all 0.3s ease;
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .menu-toggle {
            background: none;
            border: none;
            font-size: 24px;
            color: var(--secondary-color);
            cursor: pointer;
            transition: all 0.3s;
            padding: 8px;
            border-radius: 8px;
        }

        .menu-toggle:hover {
            color: var(--primary-color);
            background: #f8f9fc;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 12px;
            text-decoration: none;
            color: var(--primary-color);
            font-weight: 700;
            font-size: 22px;
        }

        .logo-icon {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--primary-color), #224abe);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .notification-icon {
            position: relative;
            font-size: 20px;
            color: var(--secondary-color);
            cursor: pointer;
            transition: color 0.3s;
            padding: 8px;
            border-radius: 8px;
        }

        .notification-icon:hover {
            color: var(--primary-color);
            background: #f8f9fc;
        }

        .notification-badge {
            position: absolute;
            top: 2px;
            right: 2px;
            background: var(--danger-color);
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }

        .user-menu {
            position: relative;
        }

        .user-toggle {
            display: flex;
            align-items: center;
            gap: 12px;
            cursor: pointer;
            padding: 8px 15px;
            border-radius: 50px;
            transition: background 0.3s;
            background: transparent;
            border: none;
        }

        .user-toggle:hover {
            background: #f8f9fc;
        }

        .user-avatar {
            width: 42px;
            height: 42px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--primary-color);
        }

        .user-info {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 600;
            font-size: 14px;
            color: #333;
        }

        .user-role {
            font-size: 12px;
            color: var(--secondary-color);
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: var(--header-height);
            width: var(--sidebar-width);
            height: calc(100vh - var(--header-height));
            background: var(--sidebar-bg);
            transition: transform 0.3s ease;
            overflow-y: auto;
            z-index: 999;
        }

        .sidebar.collapsed {
            transform: translateX(-100%);
        }

        .sidebar-nav {
            padding: 20px 0;
        }

        .nav-section {
            margin-bottom: 30px;
        }

        .nav-section-title {
            color: #6c757d;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 1px;
            padding: 0 25px;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .nav-link-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 14px 25px;
            color: #b8bcc8;
            text-decoration: none;
            transition: all 0.3s;
            position: relative;
        }

        .nav-link-item:hover {
            background: var(--sidebar-hover);
            color: #fff;
        }

        .nav-link-item.active {
            background: var(--sidebar-hover);
            color: #fff;
        }

        .nav-link-item.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background: var(--primary-color);
        }

        .nav-icon {
            font-size: 18px;
            width: 20px;
            text-align: center;
        }

        .nav-text {
            font-size: 15px;
            font-weight: 500;
        }

        .nav-badge {
            margin-left: auto;
            background: var(--danger-color);
            color: white;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 600;
        }

        /* Main Content - THIS IS THE FIX */
        .main-content {
            margin-left: var(--sidebar-width);
            margin-top: var(--header-height);
            padding: 30px;
            min-height: calc(100vh - var(--header-height));
            transition: margin-left 0.3s ease;
        }

        .main-content.expanded {
            margin-left: 0;
        }

        /* Mobile Overlay */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: var(--header-height);
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 998;
            opacity: 0;
            transition: opacity 0.3s;
        }

        .sidebar-overlay.active {
            display: block;
            opacity: 1;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }

            .user-info {
                display: none;
            }

            .header {
                padding: 0 15px;
            }

            .main-content {
                padding: 15px;
            }

            .logo span {
                display: none;
            }
        }

        /* Scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: var(--sidebar-bg);
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: #4a4e69;
            border-radius: 3px;
        }
    </style>
</head>

<body>

    <!-- Header -->
    <header class="header" id="header">
        <div class="header-left">
            <button class="menu-toggle" id="menuToggle">
                <i class="fas fa-bars"></i>
            </button>
            <a href="<?= base_url('admin/') ?>" class="logo">
                <div class="logo-icon">
                    <i class="fas fa-rocket"></i>
                </div>
                <span>Ritecare</span>
            </a>
        </div>

        <div class="header-right">
            <!-- <div class="notification-icon">
            <i class="far fa-bell"></i>
            <span class="notification-badge">5</span>
        </div> -->

            <div class="user-menu dropdown">
                <?php
                $admin_name = $this->session->userdata('admin_name') ?? 'Admin';
                $admin_role = $this->session->userdata('admin_role') ?? 'Admin';
                $avatar_url = "https://ui-avatars.com/api/?name=" . urlencode($admin_name) . "&background=4e73df&color=fff&size=128";
                ?>
                <div class="user-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                    <img src="<?= $avatar_url ?>" alt="User" class="user-avatar">
                    <div class="user-info">
                        <div class="user-name"><?= htmlspecialchars($admin_name) ?></div>
                        <div class="user-role"><?= htmlspecialchars($admin_role) ?></div>
                    </div>
                    <i class="fas fa-chevron-down" style="color: #858796; font-size: 12px;"></i>
                </div>
                <ul class="dropdown-menu dropdown-menu-end shadow">
                    <li><a class="dropdown-item" href="<?= base_url('admin/profile') ?>"><i class="fas fa-user me-2"></i> Profile</a></li>
                    <li>
                        <hr class="dropdown-divider">
                    </li>
                    <li><a class="dropdown-item text-danger" href="<?= base_url('admin/logout') ?>"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <nav class="sidebar-nav">
            <div class="nav-section">
                <div class="nav-section-title">Main</div>

                <?php
                // Helper for active link detection
                function isActive($path)
                {
                    $base = base_url($path);
                    $current = current_url();

                    if ($path === 'admin' || $path === 'admin/') {
                        return ($current === $base || rtrim($current, '/') === rtrim($base, '/')) ? 'active' : '';
                    }

                    return (strpos($current, $base) === 0) ? 'active' : '';
                }
                ?>

                <a href="<?= base_url('admin/') ?>" class="nav-link-item <?= isActive('admin') ?>">
                    <i class="nav-icon fas fa-th-large"></i>
                    <span class="nav-text">Dashboard</span>
                </a>

                <a href="<?= base_url('admin/orders') ?>" class="nav-link-item <?= isActive('admin/orders') ?>">
                    <i class="nav-icon fas fa-shopping-cart"></i>
                    <span class="nav-text">Orders</span>
                    <span class="nav-badge">12</span>
                </a>

                <a href="<?= base_url('admin/customers') ?>" class="nav-link-item <?= isActive('admin/customers') ?>">
                    <i class="nav-icon fas fa-users"></i>
                    <span class="nav-text">Customers</span>
                </a>
            </div>

            <div class="nav-section">
                <div class="nav-section-title">Account</div>

                <a href="<?= base_url('admin/profile') ?>" class="nav-link-item <?= isActive('admin/profile') ?>">
                    <i class="nav-icon fas fa-user-circle"></i>
                    <span class="nav-text">Profile</span>
                </a>

                <a href="<?= base_url('admin/logout') ?>" class="nav-link-item">
                    <i class="nav-icon fas fa-sign-out-alt"></i>
                    <span class="nav-text">Logout</span>
                </a>
            </div>
        </nav>
    </aside>

    <!-- Mobile Overlay -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent'); // ✅ Correct selector
        const overlay = document.getElementById('sidebarOverlay');

        menuToggle.addEventListener('click', () => {
            const isMobile = window.innerWidth <= 768;

            if (isMobile) {
                sidebar.classList.toggle('show');
                overlay.classList.toggle('active');
                // On mobile: main-content always full width
                mainContent.classList.add('expanded');
            } else {
                sidebar.classList.toggle('collapsed');
                mainContent.classList.toggle('expanded');
            }
        });

        // Mobile: clicking overlay closes sidebar
        overlay.addEventListener('click', () => {
            sidebar.classList.remove('show');
            overlay.classList.remove('active');
            mainContent.classList.add('expanded');
        });

        // Close sidebar on mobile when clicking outside
        document.addEventListener('click', (e) => {
            if (window.innerWidth <= 768) {
                if (!sidebar.contains(e.target) && !menuToggle.contains(e.target)) {
                    sidebar.classList.remove('show');
                    sidebar.classList.add('collapsed');
                    overlay.classList.remove('active');
                }
            }
        });

        // Handle window resize
        window.addEventListener('resize', () => {
            if (window.innerWidth > 768) {
                sidebar.classList.remove('show');
                overlay.classList.remove('active');
            }
        });
    </script>