<!-- Main Content -->
<main>
    <div class="page-header">
        <h1 class="page-title">
            <i class="fas fa-users me-2"></i>Customers Management
        </h1>
    </div>

    <!-- Stats Cards -->
    <?php
    $total = count($customers ?? []);
    $active = count(array_filter($customers ?? [], fn($c) => ($c['status'] ?? '') === 'active'));
    $inactive = count(array_filter($customers ?? [], fn($c) => ($c['status'] ?? '') === 'inactive'));
    $new_today = count(array_filter(
        $customers ?? [],
        function ($c) {
            if (empty($c['created_at']) || !is_numeric($c['created_at'])) {
                return false;
            }
            $timestamp = intval($c['created_at']) / 1000;
            return date('Y-m-d', $timestamp) === date('Y-m-d');
        }
    ));

    ?>

    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-icon all">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-info">
                <h6>Total Customers</h6>
                <h3><?= $total ?></h3>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon completed">
                <i class="fas fa-user-check"></i>
            </div>
            <div class="stat-info">
                <h6>Active</h6>
                <h3><?= $active ?></h3>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon rejected">
                <i class="fas fa-user-times"></i>
            </div>
            <div class="stat-info">
                <h6>Inactive</h6>
                <h3><?= $inactive ?></h3>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon processing">
                <i class="fas fa-user-plus"></i>
            </div>
            <div class="stat-info">
                <h6>New Today</h6>
                <h3><?= $new_today ?></h3>
            </div>
        </div>
    </div>

    <!-- Simple Customers Table -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Customers</h3>
            <div class="card-actions">
                <div class="filter-buttons">
                    <button class="filter-btn active" data-status="all">All</button>
                    <button class="filter-btn" data-status="active">Active</button>
                    <button class="filter-btn" data-status="inactive">Inactive</button>
                </div>
                <div class="search-box">
                    <input type="text" id="searchInput" placeholder="Search customers..." class="form-control">
                </div>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Customer Info</th>
                            <th>Contact</th>
                            <th>Orders</th>
                            <th>Status</th>
                            <th>Joined</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="customersTableBody">
                        <?php if (empty($customers)): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted py-4">
                                    <i class="fas fa-users fa-2x mb-3"></i>
                                    <p>No customers found</p>
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($customers as $index => $customer): ?>
                                <tr>
                                    <td><?= $index + 1 ?></td>
                                    <td>
                                        <strong><?= htmlspecialchars($customer['name'] ?? 'N/A') ?></strong><br>
                                    </td>
                                    <td>
                                        <strong><?= htmlspecialchars($customer['email'] ?? 'N/A') ?></strong><br>
                                        <small class="text-muted"><?= htmlspecialchars($customer['phone'] ?? '') ?></small>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary"><?= $customer['total_orders'] ?? 0 ?> orders</span>
                                    </td>
                                    <td>
                                        <?php
                                        $status = $customer['status'] ?? 'active';
                                        $statusClass = [
                                            'active' => 'bg-success',
                                            'inactive' => 'bg-danger'
                                        ][$status] ?? 'bg-secondary';
                                        ?>
                                        <span class="badge <?= $statusClass ?>"><?= ucfirst($status) ?></span>
                                    </td>
                                    <td>
                                        <?php
                                        if (!empty($customer['created_at']) && is_numeric($customer['created_at'])) {
                                            $timestamp = intval($customer['created_at']) / 1000;
                                            echo date('d M Y', $timestamp);
                                        } else {
                                            echo '—';
                                        }
                                        ?>

                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-outline-info" onclick="viewCustomer('<?= $customer['id'] ?>')" title="View">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary" onclick="viewCustomerOrders('<?= $customer['id'] ?>')" title="View Orders">
                                                <i class="fas fa-shopping-cart"></i>
                                            </button>
                                            <?php if ($status === 'active'): ?>
                                                <button class="btn btn-sm btn-outline-warning" onclick="deactivateCustomer('<?= $customer['id'] ?>')" title="Deactivate">
                                                    <i class="fas fa-user-times"></i>
                                                </button>
                                            <?php else: ?>
                                                <button class="btn btn-sm btn-outline-success" onclick="activateCustomer('<?= $customer['id'] ?>')" title="Activate">
                                                    <i class="fas fa-user-check"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card-footer">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="text-muted">Total: <?= $pagination['total_customers'] ?? 0 ?> customers</div>
                </div>
                <div class="col-md-6">
                    <!-- Server-side Pagination -->
                    <nav class="d-flex justify-content-end">
                        <ul class="pagination pagination-sm mb-0">
                            <?php if (($pagination['current_page'] ?? 1) > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?= $pagination['current_page'] - 1 ?>" aria-label="Previous">
                                        <span aria-hidden="true">&laquo; Previous</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php for ($i = 1; $i <= ($pagination['total_pages'] ?? 1); $i++): ?>
                                <li class="page-item <?= $i == ($pagination['current_page'] ?? 1) ? 'active' : '' ?>">
                                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                </li>
                            <?php endfor; ?>

                            <?php if (($pagination['current_page'] ?? 1) < ($pagination['total_pages'] ?? 1)): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?= $pagination['current_page'] + 1 ?>" aria-label="Next">
                                        <span aria-hidden="true">Next &raquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>

</main>

<!-- View Customer Modal -->
<div class="modal fade" id="viewCustomerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-user me-2"></i>Customer Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="customer-detail-row">
                            <div class="customer-detail-label">Customer ID:</div>
                            <div class="customer-detail-value" id="modal-customer-id"></div>
                        </div>
                        <div class="customer-detail-row">
                            <div class="customer-detail-label">Full Name:</div>
                            <div class="customer-detail-value" id="modal-customer-name"></div>
                        </div>
                        <div class="customer-detail-row">
                            <div class="customer-detail-label">Email:</div>
                            <div class="customer-detail-value" id="modal-email"></div>
                        </div>
                        <div class="customer-detail-row">
                            <div class="customer-detail-label">Phone:</div>
                            <div class="customer-detail-value" id="modal-phone"></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="customer-detail-row">
                            <div class="customer-detail-label">Total Orders:</div>
                            <div class="customer-detail-value" id="modal-total-orders"></div>
                        </div>
                        <div class="customer-detail-row">
                            <div class="customer-detail-label">Status:</div>
                            <div class="customer-detail-value">
                                <span class="status-badge" id="modal-status-badge"></span>
                            </div>
                        </div>
                        <div class="customer-detail-row">
                            <div class="customer-detail-label">Joined Date:</div>
                            <div class="customer-detail-value" id="modal-joined-date"></div>
                        </div>
                        <div class="customer-detail-row">
                            <div class="customer-detail-label">Last Active:</div>
                            <div class="customer-detail-value" id="modal-last-active"></div>
                        </div>
                    </div>
                </div>

                <hr class="my-4">

                <h6 class="mb-3"><i class="fas fa-map-marker-alt me-2"></i>Address Information</h6>
                <div class="customer-detail-row">
                    <div class="customer-detail-label">Address:</div>
                    <div class="customer-detail-value" id="modal-address"></div>
                </div>
                <div class="customer-detail-row">
                    <div class="customer-detail-label">City:</div>
                    <div class="customer-detail-value" id="modal-city"></div>
                </div>
                <div class="customer-detail-row">
                    <div class="customer-detail-label">Postal Code:</div>
                    <div class="customer-detail-value" id="modal-postal-code"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Customer Orders Modal -->
<div class="modal fade" id="customerOrdersModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-shopping-cart me-2"></i>Customer Orders
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="customer-info mb-4 p-3 bg-light rounded">
                    <strong id="orders-customer-name"></strong> -
                    <span id="orders-customer-email"></span> -
                    Total Orders: <span id="orders-total-count" class="badge bg-primary"></span>
                </div>

                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Items</th>
                            </tr>
                        </thead>
                        <tbody id="customerOrdersBody">
                            <!-- Orders will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- SweetAlert -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>
<script>
    // PHP se data le rahe hain
    let customersData = <?php echo json_encode($all_customers ?? []); ?>;

    // Simple filter functionality
    $(document).ready(function() {
        // Search functionality
        $('#searchInput').on('input', function() {
            const searchTerm = $(this).val().toLowerCase();
            filterTable(searchTerm);
        });

        // Filter buttons
        $('.filter-btn').on('click', function() {
            $('.filter-btn').removeClass('active');
            $(this).addClass('active');
            const status = $(this).data('status');
            filterByStatus(status);
        });
    });

    // Simple table filtering
    function filterTable(searchTerm) {
        $('#customersTableBody tr').each(function() {
            const rowText = $(this).text().toLowerCase();
            if (rowText.includes(searchTerm)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    }

    // Filter by status
    function filterByStatus(status) {
        $('#customersTableBody tr').each(function() {
            if (status === 'all') {
                $(this).show();
            } else {
                const rowStatus = $(this).find('.badge').text().toLowerCase();
                if (rowStatus === status) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            }
        });
    }

    // View Customer Details
    window.viewCustomer = function(customerId) {
        const customer = customersData.find(c => c.id === customerId);
        if (!customer) {
            showToast('Error', 'Customer not found', 'danger');
            return;
        }

        $('#modal-customer-id').text(customer.id || 'N/A');
        $('#modal-customer-name').text(customer.name || 'N/A');
        $('#modal-email').text(customer.email || 'N/A');
        $('#modal-phone').text(customer.phone || 'N/A');
        $('#modal-total-orders').text(customer.total_orders || 0);
        $('#modal-address').text(customer.address || 'N/A');
        $('#modal-city').text(customer.city || 'N/A');
        $('#modal-postal-code').text(customer.postal_code || 'N/A');

        // Format dates
        if (customer.created_at) {
            $('#modal-joined-date').text(new Date(parseInt(customer.created_at)).toLocaleDateString('en-GB', {
                day: 'numeric',
                month: 'short',
                year: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            }));
        } else {
            $('#modal-joined-date').text('N/A');
        }

        if (customer.last_active) {
            $('#modal-last-active').text(new Date(parseInt(customer.last_active)).toLocaleDateString('en-GB', {
                day: 'numeric',
                month: 'short',
                year: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            }));
        } else {
            $('#modal-last-active').text('N/A');
        }

        // Status badge
        const statusBadge = $('#modal-status-badge');
        statusBadge.text(capitalizeFirst(customer.status || 'active'));
        statusBadge.attr('class', `status-badge ${customer.status}`);

        new bootstrap.Modal(document.getElementById('viewCustomerModal')).show();
    };

    // View Customer Orders
    window.viewCustomerOrders = function(customerId) {
        const customer = customersData.find(c => c.id === customerId);
        if (!customer) {
            showToast('Error', 'Customer not found', 'danger');
            return;
        }

        // Set customer info at the top of modal
        $('#orders-customer-name').text(customer.name || 'N/A');
        $('#orders-customer-email').text(customer.email || 'N/A');
        $('#orders-total-count').text(customer.orders?.length || 0);

        const ordersBody = $('#customerOrdersBody');
        ordersBody.empty();

        if (!customer.orders || customer.orders.length === 0) {
            ordersBody.html(`
            <tr>
                <td colspan="6" class="text-center py-3 text-muted">
                    <i class="fas fa-shopping-cart fa-2x mb-2"></i>
                    <p>No orders found for this customer</p>
                </td>
            </tr>
        `);
        } else {
            customer.orders.forEach(order => {
                const orderDate = order.created_at ?
                    new Date(parseInt(order.created_at)).toLocaleDateString('en-GB', {
                        day: 'numeric',
                        month: 'short',
                        year: 'numeric'
                    }) :
                    'N/A';

                const statusClass = {
                    'pending': 'bg-warning',
                    'processing': 'bg-info',
                    'completed': 'bg-success',
                    'rejected': 'bg-danger'
                } [order.status] || 'bg-secondary';

                const itemsCount = order.images?.length || 0;

                ordersBody.append(`
                <tr>
                    <td>${order.Customer_data_id || order.id}</td>
                    <td>${orderDate}</td>
                    <td>${order.notes || '-'}</td>
                    <td><span class="badge ${statusClass}">${capitalizeFirst(order.status)}</span></td>
                    <td>${itemsCount} item(s)</td>
                   
                </tr>
            `);
            });
        }

        new bootstrap.Modal(document.getElementById('customerOrdersModal')).show();
    };

    // Activate Customer with API call
    window.activateCustomer = function(customerId) {
        const customer = customersData.find(c => c.id === customerId);
        if (!customer) return;

        Swal.fire({
            title: 'Activate Customer?',
            html: `
                <div class="text-start">
                    <p>Are you sure you want to activate this customer?</p>
                    <div class="alert alert-info mt-2">
                        <strong>${customer.name}</strong><br>
                        <small>${customer.email}</small>
                    </div>
                </div>
            `,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#1cc88a',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Activate!',
            cancelButtonText: 'Cancel',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                // API call to activate customer
                updateCustomerStatus(customerId, 'active')
                    .then(() => {
                        showToast('Success', 'Customer activated successfully', 'success');
                        // Reload page after 2 seconds
                        setTimeout(() => {
                            location.reload();
                        }, 2000);
                    })
                    .catch(error => {
                        showToast('Error', error.message || 'Failed to activate customer', 'danger');
                    });
            }
        });
    };

    // Deactivate Customer with API call
    window.deactivateCustomer = function(customerId) {
        const customer = customersData.find(c => c.id === customerId);
        if (!customer) return;

        Swal.fire({
            title: 'Deactivate Customer?',
            html: `
                <div class="text-start">
                    <p>Are you sure you want to deactivate this customer?</p>
                    <div class="alert alert-warning mt-2">
                        <strong>${customer.name}</strong><br>
                        <small>${customer.email}</small>
                    </div>
                    <div class="mt-3">
                        <label class="form-label">Reason for deactivation (optional):</label>
                        <textarea id="deactivation-reason" class="form-control" rows="3" placeholder="Enter reason for deactivation..."></textarea>
                    </div>
                </div>
            `,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#e74a3b',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Deactivate!',
            cancelButtonText: 'Cancel',
            reverseButtons: true,
            preConfirm: () => {
                const reason = document.getElementById('deactivation-reason').value;
                return {
                    reason: reason
                };
            }
        }).then((result) => {
            if (result.isConfirmed) {
                // API call to deactivate customer
                updateCustomerStatus(customerId, 'inactive', result.value.reason)
                    .then(() => {
                        showToast('Success', 'Customer deactivated successfully', 'success');
                        // Reload page after 2 seconds
                        setTimeout(() => {
                            location.reload();
                        }, 2000);
                    })
                    .catch(error => {
                        showToast('Error', error.message || 'Failed to deactivate customer', 'danger');
                    });
            }
        });
    };

    // API call to update customer status
    // API call to update customer status
    function updateCustomerStatus(customerId, status, reason = '') {
        return new Promise((resolve, reject) => {
            $.ajax({
                url: '<?php echo site_url("admin/updateCustomerStatus"); ?>',
                type: 'POST',
                data: {
                    customer_id: customerId,
                    status: status,
                    reason: reason
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        resolve(response);
                    } else {
                        reject(new Error(response.message));
                    }
                },
                error: function(xhr, status, error) {
                    reject(new Error('Network error: ' + error));
                }
            });
        });
    }
    // View Order (placeholder)
    window.viewOrder = function(orderId) {
        showToast('Info', `View order ${orderId} - This would open order details`, 'info');
    };

    // Helper functions
    function capitalizeFirst(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
    }

    function showToast(title, message, type = 'info') {
        const colors = {
            success: '#1cc88a',
            danger: '#e74a3b',
            warning: '#f6c23e',
            info: '#4e73df'
        };
        const icons = {
            success: 'check-circle',
            danger: 'times-circle',
            warning: 'exclamation-circle',
            info: 'info-circle'
        };

        const toastHtml = `
            <div class="toast-notification" style="position: fixed; top: 20px; right: 20px; z-index: 9999; 
                        background: white; border-left: 4px solid ${colors[type]}; 
                        padding: 15px 20px; border-radius: 8px; 
                        box-shadow: 0 5px 20px rgba(0,0,0,0.2); min-width: 300px;
                        animation: slideIn 0.3s ease;">
                <div style="display: flex; align-items: center; gap: 12px;">
                    <i class="fas fa-${icons[type]}" style="color: ${colors[type]}; font-size: 20px;"></i>
                    <div>
                        <strong style="display: block; margin-bottom: 3px;">${title}</strong>
                        <span style="font-size: 14px; color: #666;">${message}</span>
                    </div>
                </div>
            </div>
        `;

        const $toast = $(toastHtml);
        $('body').append($toast);
        setTimeout(() => {
            $toast.css('animation', 'slideOut 0.3s ease');
            setTimeout(() => $toast.remove(), 300);
        }, 3000);
    }
</script>

<style>
    /* Simple card styles */
    .card {
        background: white;
        border-radius: 10px;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        margin-bottom: 30px;
    }

    .card-header {
        padding: 20px 25px;
        border-bottom: 1px solid #e3e6f0;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 15px;
    }

    .card-title {
        color: #333;
        font-weight: 600;
        margin: 0;
    }

    .card-actions {
        display: flex;
        align-items: center;
        gap: 15px;
        flex-wrap: wrap;
    }

    .card-body {
        padding: 0;
    }

    .card-footer {
        padding: 15px 25px;
        border-top: 1px solid #e3e6f0;
        background: #f8f9fc;
    }

    /* Filter buttons */
    .filter-buttons {
        display: flex;
        background: #f8f9fc;
        border-radius: 8px;
        padding: 4px;
    }

    .filter-btn {
        border: none;
        padding: 8px 16px;
        border-radius: 6px;
        background: transparent;
        font-size: 0.85rem;
        font-weight: 600;
        color: var(--secondary-color);
        transition: all 0.3s;
        cursor: pointer;
    }

    .filter-btn.active {
        background: white;
        color: var(--primary-color);
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }

    .search-box {
        min-width: 250px;
    }

    /* Table styles */
    .table-responsive {
        padding: 0 25px;
    }

    .table {
        margin-bottom: 0;
    }

    .table thead th {
        background: #f8f9fc;
        border-bottom: 2px solid #e3e6f0;
        font-weight: 600;
        color: var(--secondary-color);
        padding: 15px 10px;
    }

    .table tbody td {
        padding: 15px 10px;
        vertical-align: middle;
        border-bottom: 1px solid #e3e6f0;
    }

    .table tbody tr:hover {
        background: #f8f9fc;
    }

    /* Stats cards */
    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-card {
        background: white;
        border-radius: 10px;
        padding: 20px;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        display: flex;
        align-items: center;
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 15px;
        color: white;
        font-size: 1.5rem;
    }

    .stat-icon.all {
        background: linear-gradient(135deg, #4e73df, #2e59d9);
    }

    .stat-icon.completed {
        background: linear-gradient(135deg, #1cc88a, #17a673);
    }

    .stat-icon.rejected {
        background: linear-gradient(135deg, #e74a3b, #c9302c);
    }

    .stat-icon.processing {
        background: linear-gradient(135deg, #36b9cc, #2c9faf);
    }

    .stat-info h6 {
        color: var(--secondary-color);
        font-size: 0.8rem;
        margin-bottom: 5px;
        text-transform: uppercase;
        font-weight: 700;
    }

    .stat-info h3 {
        color: #333;
        font-weight: 700;
        margin: 0;
    }

    /* Customer detail styles */
    .customer-detail-row {
        display: flex;
        padding: 12px 0;
        border-bottom: 1px solid #f0f0f0;
    }

    .customer-detail-row:last-child {
        border-bottom: none;
    }

    .customer-detail-label {
        font-weight: 600;
        color: var(--secondary-color);
        width: 150px;
        font-size: 14px;
    }

    .customer-detail-value {
        flex: 1;
        color: #333;
        font-size: 14px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .card-actions {
            flex-direction: column;
            align-items: stretch;
        }

        .search-box {
            min-width: auto;
        }

        .filter-buttons {
            order: -1;
        }

        .stats-row {
            grid-template-columns: 1fr;
        }

        .card-header {
            flex-direction: column;
            align-items: stretch;
        }
    }
</style>