<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Ritecare Pharmacy</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        :root {
            --primary-color: #0d6efd;
            --secondary-color: #0d2a5a;
            --text-color: #444;
            --light-bg: #f8f9fa;
            --border-radius: 12px;
        }

        .min-vh-100 {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .bg-main {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }

        /* Card Styling */
        .cardCustom {
            background: #fff;
            border-radius: 20px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            border: 1px solid #e9ecef;
            transition: all 0.3s ease;
            width: 100%;
            max-width: 480px;
            /* ⬅️ Wider card */
            padding: 2rem 2.5rem;
            /* ⬅️ Slightly less vertical padding */
            margin: 0 auto;
        }

        .cardCustom:hover {
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.12);
        }

        /* Typography */
        .mainCustom-heading {
            font-weight: 700;
            font-size: 2.2rem;
            /* ⬅️ Slightly smaller heading */
            color: var(--secondary-color);
            margin-bottom: 0.8rem;
        }

        .mainCustom-heading span {
            color: var(--primary-color);
        }

        .subCustom-text {
            font-size: 1rem;
            color: var(--text-color);
        }

        /* Form Styling */
        .form-control-lg {
            padding: 0.65rem 1rem;
            font-size: 1rem;
            border: 2px solid #e9ecef;
            border-radius: var(--border-radius);
            transition: all 0.3s ease;
        }

        .form-control-lg:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.15rem rgba(13, 110, 253, 0.1);
        }

        .form-label {
            font-weight: 600;
            color: var(--secondary-color);
            margin-bottom: 0.4rem;
        }

        /* Button Styling */
        .btnCustom-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, #0b5ed7 100%);
            color: #fff;
            border: none;
            padding: 0.65rem 2rem;
            font-size: 1.05rem;
            border-radius: 50px;
            transition: all 0.3s ease;
            font-weight: 600;
            width: 100%;
        }

        .btnCustom-primary:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(13, 110, 253, 0.3);
        }

        /* Validation Styles */
        .invalid-feedback {
            display: none;
            font-size: 0.875rem;
            margin-top: 0.25rem;
            color: #dc3545;
        }

        .was-validated .form-control:invalid~.invalid-feedback,
        .form-control.is-invalid~.invalid-feedback {
            display: block;
        }

        /* Alert Styling */
        .alert {
            border-radius: var(--border-radius);
            border: none;
            padding: 0.8rem 1.25rem;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .cardCustom {
                max-width: 90%;
                padding: 1.75rem;
            }

            .mainCustom-heading {
                font-size: 1.9rem;
            }
        }

        @media (max-width: 576px) {
            .cardCustom {
                padding: 1.5rem;
            }

            .mainCustom-heading {
                font-size: 1.7rem;
            }
        }

        /* Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(15px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .cardCustom {
            animation: fadeIn 0.5s ease-out;
        }
    </style>

</head>

<body class="bg-main">
    <div class="container-fluid min-vh-100 py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6 col-lg-5 col-xl-4">
                    <!-- Login Card -->
                    <div class="cardCustom p-4 p-md-5">
                        <!-- Header Section -->
                        <header class="text-center mb-4">
                            <div class="bg-primary rounded-circle p-3 mx-auto mb-3" style="width: 80px; height: 80px;">
                                <span class="text-white fs-2">🔐</span>
                            </div>
                            <h1 class="mainCustom-heading mb-2">Admin <span>Login</span></h1>
                            <p class="subCustom-text">Access your admin dashboard</p>
                        </header>

                        <!-- Main Content -->
                        <main>
                            <!-- Login Form -->
                            <form id="loginForm" novalidate>
                                <!-- Email Input -->
                                <div class="mb-4">
                                    <label for="email" class="form-label fw-semibold d-flex align-items-center">
                                        <span class="me-2">📧</span> Email Address
                                    </label>
                                    <input type="email"
                                        class="form-control form-control-lg"
                                        id="email"
                                        name="email"
                                        placeholder="admin@example.com"
                                        required
                                        autocomplete="email">
                                    <div class="invalid-feedback" id="emailError">
                                        Please enter a valid email address
                                    </div>
                                </div>

                                <!-- Password Input -->
                                <div class="mb-4">
                                    <label for="password" class="form-label fw-semibold d-flex align-items-center">
                                        <span class="me-2">🔒</span> Password
                                    </label>
                                    <input type="password"
                                        class="form-control form-control-lg"
                                        id="password"
                                        name="password"
                                        placeholder="Enter your password"
                                        required
                                        autocomplete="current-password"
                                        minlength="6">
                                    <div class="invalid-feedback" id="passwordError">
                                        Password must be at least 6 characters long
                                    </div>
                                </div>

                                <!-- Error Message Display -->
                                <div id="loginError" class="alert alert-danger d-none" role="alert">
                                    <span id="errorMessage"></span>
                                </div>

                                <!-- Submit Button -->
                                <div class="mt-4">
                                    <button type="submit"
                                        class="btnCustom-primary py-3"
                                        id="loginBtn">
                                        <span class="me-2">🚀</span> Sign In
                                    </button>
                                </div>
                            </form>
                        </main>

                        <!-- Footer Section -->
                        <footer class="text-center mt-4 pt-3 border-top">
                            <small class="text-muted">
                                💡 Forgot your password? Contact system administrator.
                            </small>
                        </footer>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Custom JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // DOM Elements
            const loginForm = document.getElementById('loginForm');
            const loginBtn = document.getElementById('loginBtn');
            const loginError = document.getElementById('loginError');
            const errorMessage = document.getElementById('errorMessage');
            const emailInput = document.getElementById('email');
            const passwordInput = document.getElementById('password');

            // Original button text
            const originalBtnText = loginBtn.innerHTML;

            // Validation Functions
            function validateEmail() {
                const email = emailInput.value.trim();
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                const isValid = emailRegex.test(email);

                if (email && !isValid) {
                    emailInput.classList.add('is-invalid');
                    return false;
                } else {
                    emailInput.classList.remove('is-invalid');
                    emailInput.classList.add('is-valid');
                    return true;
                }
            }

            function validatePassword() {
                const password = passwordInput.value;
                const isValid = password.length >= 6;

                if (password && !isValid) {
                    passwordInput.classList.add('is-invalid');
                    return false;
                } else {
                    passwordInput.classList.remove('is-invalid');
                    passwordInput.classList.add('is-valid');
                    return true;
                }
            }

            // Real-time Validation
            emailInput.addEventListener('input', function() {
                if (this.value.trim()) {
                    validateEmail();
                } else {
                    this.classList.remove('is-invalid', 'is-valid');
                }
            });

            passwordInput.addEventListener('input', function() {
                if (this.value) {
                    validatePassword();
                } else {
                    this.classList.remove('is-invalid', 'is-valid');
                }
            });

            // Form Submission Handler
            loginForm.addEventListener('submit', async function(e) {
                e.preventDefault();

                // Hide previous errors
                hideError();

                // Validate inputs
                const isEmailValid = validateEmail();
                const isPasswordValid = validatePassword();

                if (!isEmailValid || !isPasswordValid) {
                    showError('Please fix the validation errors above.');
                    return;
                }

                // Prepare form data
                const formData = {
                    email: emailInput.value.trim(),
                    password: passwordInput.value
                };

                // Show loading state
                setLoadingState(true);

                try {
                    const response = await fetch('<?php echo base_url("admin/login/submit"); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify(formData)
                    });

                    const data = await response.json();

                    if (data.success) {
                        // Redirect on success
                        window.location.href = data.redirect || '<?php echo base_url("admin/"); ?>';
                    } else {
                        showError(data.message || 'Login failed. Please try again.');
                    }
                } catch (error) {
                    console.error('Login error:', error);
                    showError('Network error. Please check your connection and try again.');
                } finally {
                    setLoadingState(false);
                }
            });

            // Utility Functions
            function showError(message) {
                errorMessage.textContent = message;
                loginError.classList.remove('d-none');

                // Scroll to error message
                loginError.scrollIntoView({
                    behavior: 'smooth',
                    block: 'center'
                });
            }

            function hideError() {
                loginError.classList.add('d-none');
            }

            function setLoadingState(isLoading) {
                if (isLoading) {
                    loginBtn.disabled = true;
                    loginBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span> Signing In...';
                } else {
                    loginBtn.disabled = false;
                    loginBtn.innerHTML = originalBtnText;
                }
            }

            // Enter key support
            loginForm.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    this.dispatchEvent(new Event('submit'));
                }
            });

            // Clear validation on focus
            emailInput.addEventListener('focus', function() {
                this.classList.remove('is-invalid', 'is-valid');
            });

            passwordInput.addEventListener('focus', function() {
                this.classList.remove('is-invalid', 'is-valid');
            });
        });
    </script>
</body>

</html>