<main>
    <div class="container">

        <!-- Order Details Section -->
        <section class="mb-5">
            <h2 class="mb-3"><i class="fas fa-receipt me-2"></i>Order Details</h2>
            <div class="card shadow-sm p-3">
                <div class="row mb-2">
                    <div class="col-md-6"><strong>Order ID:</strong> <?= $order['id'] ?? '-' ?></div>
                    <div class="col-md-6"><strong>Status:</strong> <?= ucfirst($order['status'] ?? '-') ?></div>
                </div>
                <div class="row mb-2">
                    <div class="col-md-6"><strong>Customer Name:</strong> <?= htmlspecialchars($order['customer_name'] ?? '-') ?></div>
                    <div class="col-md-6"><strong>Phone:</strong> <?= htmlspecialchars($order['phone'] ?? '-') ?></div>
                </div>
                <div class="row mb-2">
                    <div class="col-md-6"><strong>City:</strong> <?= htmlspecialchars($order['city'] ?? '-') ?></div>
                    <div class="col-md-6"><strong>Postal Code:</strong> <?= htmlspecialchars($order['postal_code'] ?? '-') ?></div>
                </div>
                <div class="row mb-2">
                    <div class="col-12"><strong>Address:</strong> <?= htmlspecialchars($order['address'] ?? '-') ?></div>
                </div>
                <?php if (!empty($order['images'])): ?>
                    <div class="row mt-3">
                        <div class="col-12"><strong>Order Images:</strong></div>
                        <div class="col-12 d-flex gap-2 flex-wrap mt-2">
                            <?php foreach ($order['images'] as $img): ?>
                                <img src="<?= $img ?>" alt="Order Image" style="height:80px; border-radius:4px; cursor:pointer;" onclick="window.open('<?= $img ?>','_blank')">
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (!empty($order['notes'])): ?>
                    <div class="row mt-2">
                        <div class="col-12"><strong>Notes:</strong> <?= htmlspecialchars($order['notes']) ?></div>
                    </div>
                <?php endif; ?>
            </div>
        </section>

        <!-- Customer Questions Section -->
        <section>
            <h2 class="mb-3"><i class="fas fa-user-md me-2"></i>Customer Eligibility Questions</h2>
            <div class="card shadow-sm p-3">
                <div class="row mb-2">
                    <div class="col-md-6"><strong>Email:</strong> <?= htmlspecialchars($customer['existing_email'] ?? '-') ?></div>
                    <div class="col-md-6"><strong>Customer Type:</strong> <?= htmlspecialchars($customer['customer_type'] ?? '-') ?></div>
                </div>
                <div class="row mb-2">
                    <div class="col-md-6"><strong>Treatment Type:</strong> <?= htmlspecialchars($customer['treatment_type'] ?? '-') ?></div>
                    <div class="col-md-3"><strong>Height:</strong> <?= $customer['height']['value'] ?? '-' ?> <?= $customer['height']['unit'] ?? '' ?></div>
                    <div class="col-md-3"><strong>Weight:</strong> <?= $customer['weight']['value'] ?? '-' ?> <?= $customer['weight']['unit'] ?? '' ?></div>
                </div>

                <!-- Medical Conditions -->
                <?php if (!empty($customer['medical_conditions'])): ?>
                    <div class="mb-2">
                        <strong>Medical Conditions:</strong>
                        <ul>
                            <?php foreach ($customer['medical_conditions'] as $cond): ?>
                                <li><?= htmlspecialchars($cond) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <!-- Allergies -->
                <?php if (!empty($customer['allergies'])): ?>
                    <div class="mb-2">
                        <strong>Allergies:</strong>
                        <ul>
                            <?php foreach ($customer['allergies'] as $allergy): ?>
                                <li><?= htmlspecialchars($allergy) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <!-- Other Health Issues -->
                <?php if (!empty($customer['other_health_issues'])): ?>
                    <div class="mb-2">
                        <strong>Other Health Issues:</strong>
                        <ul>
                            <?php foreach ($customer['other_health_issues'] as $issue): ?>
                                <li><?= htmlspecialchars($issue) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <!-- Additional Info -->
                <div class="row mb-2">
                    <div class="col-md-4"><strong>Pregnancy Status:</strong> <?= htmlspecialchars($customer['pregnancy_status'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Insulin Use:</strong> <?= htmlspecialchars($customer['insulin_use'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Other Diabetes Med:</strong> <?= htmlspecialchars($customer['other_diabetes_med'] ?? '-') ?></div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-4"><strong>Current Medications:</strong> <?= htmlspecialchars($customer['current_medications'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Smoking Status:</strong> <?= htmlspecialchars($customer['smoking_status'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Recent Weight Loss Med:</strong> <?= htmlspecialchars($customer['recent_weightloss_med'] ?? '-') ?></div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-4"><strong>Dose Understanding:</strong> <?= htmlspecialchars($customer['dose_understanding'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Contraceptive Agreement:</strong> <?= htmlspecialchars($customer['contraceptive_agreement'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Information Agreement:</strong> <?= htmlspecialchars($customer['information_agreement'] ?? '-') ?></div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-4"><strong>Treatment Agreement:</strong> <?= htmlspecialchars($customer['treatment_agreement'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Final Consent:</strong> <?= htmlspecialchars($customer['final_consent'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Assisted Prescribing:</strong> <?= htmlspecialchars($customer['assisted_prescribing'] ?? '-') ?></div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-4"><strong>Privacy Consent:</strong> <?= htmlspecialchars($customer['privacy_consent'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Terms Consent:</strong> <?= htmlspecialchars($customer['terms_consent'] ?? '-') ?></div>
                    <div class="col-md-4"><strong>Ethnicity:</strong> <?= htmlspecialchars($customer['ethnicity'] ?? '-') ?></div>
                </div>
            </div>
        </section>

    </div>
</main>