<!-- Main Content -->
<main>
    <div class="page-header">
        <h1 class="page-title">
            <i class="fas fa-capsules me-2"></i>Products Management
        </h1>
    </div>

    <!-- Stats Cards -->
    <?php
    $total = count($products);
    $active = count(array_filter($products, fn($p) => ($p['status'] ?? '') === 'active'));
    $inactive = count(array_filter($products, fn($p) => ($p['status'] ?? '') === 'inactive'));
    $featured = count(array_filter($products, fn($p) => ($p['is_best_seller'] ?? false) === true));
    ?>

    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-icon all">
                <i class="fas fa-box"></i>
            </div>
            <div class="stat-info">
                <h6>Total Products</h6>
                <h3 id="total-products"><?= $total ?></h3>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon active">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-info">
                <h6>Active</h6>
                <h3 id="active-products"><?= $active ?></h3>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon inactive">
                <i class="fas fa-pause-circle"></i>
            </div>
            <div class="stat-info">
                <h6>Inactive</h6>
                <h3 id="inactive-products"><?= $inactive ?></h3>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon featured">
                <i class="fas fa-star"></i>
            </div>
            <div class="stat-info">
                <h6>Best Sellers</h6>
                <h3 id="featured-products"><?= $featured ?></h3>
            </div>
        </div>
    </div>

    <!-- Products Table Card -->
    <div class="datatable-card">
        <div class="datatable-header">
            <h3 class="datatable-title">All Products</h3>
            <div class="header-actions">
                <button class="btn btn-primary" id="addProductBtn" onclick="openProductForm()">
                    <i class="fas fa-plus me-1"></i>Add Product
                </button>
                <div class="filter-buttons">
                    <button class="filter-btn active" data-status="all">All</button>
                    <button class="filter-btn" data-status="active">Active</button>
                    <button class="filter-btn" data-status="inactive">Inactive</button>
                </div>
                <div class="search-box">
                    <input type="text" id="searchInput" placeholder="Search products..." class="form-control">
                </div>
            </div>
        </div>

        <!-- Table -->
        <div class="table-responsive">
            <table id="productsTable" class="table table-hover" style="width:100%">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Price</th>
                        <th>Images</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="productsTableBody">
                    <?php if (empty($products)): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">No products found.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($products as $index => $p): ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($p['name'] ?? 'N/A') ?></strong><br>
                                    <small class="text-muted"><?= htmlspecialchars($p['subtitle'] ?? '') ?></small>
                                </td>
                                <td>£<?= isset($p['price']) ? number_format($p['price'], 2) : '0.00' ?></td>
                                <td>
                                    <?php if (!empty($p['image'])): ?>
                                        <img src="<?= $p['image'] ?>" alt="Image" class="rounded" width="50" height="50">
                                    <?php else: ?>
                                        <span class="text-muted">No Image</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (($p['status'] ?? '') === 'active'): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                    if (!empty($p['created_at'])) {
                                        // Convert Firestore timestamp (ms) → seconds
                                        $timestamp = (int) ($p['created_at'] / 1000);
                                        echo date('d M Y, h:i A', $timestamp);
                                    } else {
                                        echo '—';
                                    }
                                    ?>
                                </td>

                                <td>
                                    <div class="btn-group">
                                        <a href="#" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="#" class="btn btn-sm btn-outline-danger">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Footer -->
        <div class="table-footer">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="table-info" id="tableInfo">Showing <?= $total ?> products</div>
                </div>
                <div class="col-md-6">
                    <nav>
                        <ul class="pagination justify-content-end" id="pagination">
                            <li class="page-item disabled"><a class="page-link">Prev</a></li>
                            <li class="page-item active"><a class="page-link">1</a></li>
                            <li class="page-item disabled"><a class="page-link">Next</a></li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</main>


<!-- View Product Modal -->
<div class="modal fade" id="viewProductModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-info-circle me-2"></i>Product Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="product-detail-row">
                            <div class="product-detail-label">Product ID:</div>
                            <div class="product-detail-value" id="modal-product-id"></div>
                        </div>
                        <div class="product-detail-row">
                            <div class="product-detail-label">Product Name:</div>
                            <div class="product-detail-value" id="modal-product-name"></div>
                        </div>
                        <div class="product-detail-row">
                            <div class="product-detail-label">Subtitle:</div>
                            <div class="product-detail-value" id="modal-subtitle"></div>
                        </div>
                        <div class="product-detail-row">
                            <div class="product-detail-label">Price:</div>
                            <div class="product-detail-value" id="modal-price"></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="product-detail-row">
                            <div class="product-detail-label">Description:</div>
                            <div class="product-detail-value" id="modal-description"></div>
                        </div>
                        <div class="product-detail-row">
                            <div class="product-detail-label">Status:</div>
                            <div class="product-detail-value">
                                <span class="status-badge" id="modal-status-badge"></span>
                            </div>
                        </div>
                    </div>
                </div>

                <hr class="my-4">

                <h6 class="mb-3"><i class="fas fa-images me-2"></i>Product Images</h6>
                <div class="image-gallery" id="modal-images"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Add/Edit Product Modal -->
<div class="modal fade" id="productFormModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="productModalTitle">
                    <i class="fas fa-plus me-2"></i>Add New Product
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="productForm">
                    <input type="hidden" id="product-id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Product Name *</label>
                                <input type="text" class="form-control" id="product-name" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Subtitle *</label>
                                <input type="text" class="form-control" id="product-subtitle" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Price (£) *</label>
                                <input type="number" class="form-control" id="product-price" step="0.01" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Description *</label>
                                <textarea class="form-control" id="product-description" rows="3" required></textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-select" id="product-status">
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Image Upload Section -->
                    <div class="mb-3">
                        <label class="form-label">Main Image *</label>
                        <div class="image-upload-container" id="mainImageUpload">
                            <i class="fas fa-cloud-upload-alt fa-2x text-muted mb-3"></i>
                            <p class="text-muted mb-2">Drag & drop main image here or click to browse</p>
                            <input type="file" id="main-image-file" accept="image/*" class="d-none">
                            <button type="button" class="btn btn-outline-primary btn-sm" onclick="document.getElementById('main-image-file').click()">
                                <i class="fas fa-folder-open me-1"></i>Browse Files
                            </button>
                            <div class="upload-preview" id="mainImagePreview"></div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Additional Images</label>
                        <div class="image-upload-container" id="additionalImagesUpload">
                            <i class="fas fa-cloud-upload-alt fa-2x text-muted mb-3"></i>
                            <p class="text-muted mb-2">Drag & drop additional images here or click to browse</p>
                            <input type="file" id="additional-images-file" accept="image/*" multiple class="d-none">
                            <button type="button" class="btn btn-outline-primary btn-sm" onclick="document.getElementById('additional-images-file').click()">
                                <i class="fas fa-folder-open me-1"></i>Browse Files
                            </button>
                            <div class="upload-preview" id="additionalImagesPreview"></div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="saveProductBtn">
                    <i class="fas fa-save me-1"></i>Save Product
                </button>
            </div>
        </div>
    </div>
</div>s
<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteProductModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">
                    <i class="fas fa-exclamation-triangle me-2"></i>Confirm Delete
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this product? This action cannot be undone.</p>
                <div class="product-detail-row">
                    <div class="product-detail-label">Product ID:</div>
                    <div class="product-detail-value" id="delete-product-id"></div>
                </div>
                <div class="product-detail-row">
                    <div class="product-detail-label">Product Name:</div>
                    <div class="product-detail-value" id="delete-product-name"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                    <i class="fas fa-trash me-1"></i>Delete Product
                </button>
            </div>
        </div>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Optional: SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>

<script>
    let productsData = <?php echo json_encode($products ?? []); ?>;
    let currentFilter = 'all';
    let currentPage = 1;
    const itemsPerPage = 10;
    let filteredData = [];
    let currentMainImage = null;
    let currentAdditionalImages = [];

    // Fix for stuck backdrop after closing modal
    $(document).on('hidden.bs.modal', function() {
        $('body').removeClass('modal-open');
        $('.modal-backdrop').remove();
    });

    // Initialize when document is ready
    $(document).ready(function() {
        initializeWithServerData();
        initializeImageUpload();

        // Event Listeners
        $('#addProductBtn').on('click', openProductForm);
        $('#saveProductBtn').on('click', saveProduct);
        $('#confirmDeleteBtn').on('click', confirmDelete);
        $('#searchInput').on('input', filterProducts);

        $('.filter-btn').on('click', function() {
            $('.filter-btn').removeClass('active');
            $(this).addClass('active');
            currentFilter = $(this).data('status');
            filterProducts();
        });
    });

    // Initialize with server-side data
    function initializeWithServerData() {
        productsData = productsData.map((product, index) => ({
            ...product,
            serial: index + 1
        }));
        filteredData = [...productsData];
        filterProducts();
    }

    // Filter and display products
    function filterProducts() {
        const searchTerm = $('#searchInput').val().toLowerCase();
        filteredData = productsData.filter(product => {
            const matchesSearch = !searchTerm ||
                (product.name?.toLowerCase().includes(searchTerm)) ||
                (product.subtitle?.toLowerCase().includes(searchTerm)) ||
                (product.description?.toLowerCase().includes(searchTerm));
            const matchesFilter = currentFilter === 'all' || product.status === currentFilter;
            return matchesSearch && matchesFilter;
        });
        renderTable();
        updatePagination();
        updateTableInfo();
    }

    // Render table with data
    function renderTable() {
        const startIndex = (currentPage - 1) * itemsPerPage;
        const endIndex = startIndex + itemsPerPage;
        const pageData = filteredData.slice(startIndex, endIndex);
        const tbody = $('#productsTableBody');

        tbody.empty();

        if (pageData.length === 0) {
            tbody.html(`
                <tr>
                    <td colspan="7" class="text-center py-4">
                        <i class="fas fa-box-open fa-2x text-muted mb-3"></i>
                        <p class="text-muted">No products found</p>
                    </td>
                </tr>
            `);
            return;
        }

        pageData.forEach(product => tbody.append(createTableRow(product)));
    }

    // Create table row HTML
    function createTableRow(product) {
        const createdDate = product.created_at ?
            new Date(product.created_at).toLocaleDateString('en-GB') : '—';

        return `
            <tr>
                <td><strong>#${product.serial}</strong></td>
                <td>
                    <div class="product-info">
                        <div class="product-name">${escapeHtml(product.name || 'N/A')}</div>
                        <div class="product-subtitle">${escapeHtml(product.subtitle || '')}</div>
                    </div>
                </td>
                <td><strong>£${parseFloat(product.price || 0).toFixed(2)}</strong></td>
                <td>${createImagesHtml(product)}</td>
                <td>${createStatusHtml(product.status)}</td>
                <td>${createdDate}</td>
                <td>${createActionsHtml(product.id)}</td>
            </tr>
        `;
    }

    // Create images HTML
    function createImagesHtml(product) {
        const images = [product.image, ...(product.thumbnails || [])].filter(img => img);
        if (images.length === 0) return '<span class="text-muted">No Image</span>';

        let html = '<div class="product-images">';
        html += `<img src="${images[0]}" alt="Product Image" class="product-image-thumb" onclick="viewProduct('${product.id}')">`;
        if (images.length > 1) html += `<div class="images-count">+${images.length - 1}</div>`;
        html += '</div>';
        return html;
    }

    // Create status HTML
    function createStatusHtml(status) {
        const statusText = status ? status.charAt(0).toUpperCase() + status.slice(1) : 'Unknown';
        const badgeClass = status === 'active' ? 'bg-success' : 'bg-secondary';
        return `<span class="badge ${badgeClass}">${statusText}</span>`;
    }

    // Create actions HTML
    function createActionsHtml(productId) {
        return `
            <div class="btn-group btn-group-sm">
                <button class="btn btn-outline-primary" onclick="editProduct('${productId}')" title="Edit">
                    <i class="fas fa-edit"></i>
                </button>
                <button class="btn btn-outline-danger" onclick="deleteProduct('${productId}')" title="Delete">
                    <i class="fas fa-trash"></i>
                </button>
                <button class="btn btn-outline-info" onclick="viewProduct('${productId}')" title="View">
                    <i class="fas fa-eye"></i>
                </button>
            </div>
        `;
    }

    // Update pagination
    function updatePagination() {
        const totalPages = Math.ceil(filteredData.length / itemsPerPage);
        const pagination = $('#pagination');
        pagination.empty();

        if (totalPages <= 1) {
            pagination.html('<li class="page-item disabled"><a class="page-link">1</a></li>');
            return;
        }

        // Previous button
        const prevDisabled = currentPage === 1 ? 'disabled' : '';
        pagination.append(`
            <li class="page-item ${prevDisabled}">
                <a class="page-link" href="#" onclick="changePage(${currentPage - 1}); return false;">Previous</a>
            </li>
        `);

        // Page numbers
        for (let i = 1; i <= totalPages; i++) {
            const active = i === currentPage ? 'active' : '';
            pagination.append(`
                <li class="page-item ${active}">
                    <a class="page-link" href="#" onclick="changePage(${i}); return false;">${i}</a>
                </li>
            `);
        }

        // Next button
        const nextDisabled = currentPage === totalPages ? 'disabled' : '';
        pagination.append(`
            <li class="page-item ${nextDisabled}">
                <a class="page-link" href="#" onclick="changePage(${currentPage + 1}); return false;">Next</a>
            </li>
        `);
    }

    // Change page
    function changePage(page) {
        currentPage = page;
        renderTable();
        updatePagination();
        updateTableInfo();
    }

    // Update table information
    function updateTableInfo() {
        const startIndex = (currentPage - 1) * itemsPerPage + 1;
        const endIndex = Math.min(currentPage * itemsPerPage, filteredData.length);
        $('#tableInfo').text(`Showing ${startIndex}-${endIndex} of ${filteredData.length} products`);
    }

    // View Product Details
    window.viewProduct = function(productId) {
        const product = productsData.find(p => p.id === productId);
        if (!product) {
            showToast('Error', 'Product not found', 'danger');
            return;
        }

        $('#modal-product-id').text(product.id);
        $('#modal-product-name').text(product.name || 'N/A');
        $('#modal-subtitle').text(product.subtitle || '');
        $('#modal-price').text(`£${parseFloat(product.price || 0).toFixed(2)}`);
        $('#modal-description').text(product.description || 'No description');

        const statusBadge = $('#modal-status-badge');
        const statusText = product.status ? product.status.charAt(0).toUpperCase() + product.status.slice(1) : 'Unknown';
        statusBadge.text(statusText).attr('class', `status-badge ${product.status}`);

        // Render Images
        const allImages = [product.image, ...(product.thumbnails || [])].filter(img => img);
        let imagesHtml = allImages.length > 0 ?
            allImages.map(img => `<img src="${img}" class="gallery-image" onclick="window.open('${img}', '_blank')">`).join('') :
            '<p class="text-muted">No images available</p>';
        $('#modal-images').html(imagesHtml);

        new bootstrap.Modal(document.getElementById('viewProductModal')).show();
    };


    // Open Product Form (Add/Edit)
    function openProductForm(productId = null) {
        console.log('openProductForm called with productId:', productId);

        const modal = $('#productFormModal');
        const title = $('#productModalTitle');
        const form = $('#productForm')[0];

        form.reset();
        resetImageUploads();

        $('#product-id').val('');
        $('#product-name').val('');
        $('#product-subtitle').val('');
        $('#product-price').val('');
        $('#product-description').val('');
        $('#product-status').val('active');

        // ✅ FIXED: only enter edit mode if a valid ID is passed
        if (typeof productId === 'string' && productId.trim() !== '') {
            console.log('Edit mode - Looking for product:', productId);
            const product = productsData.find(p => p.id === productId);

            if (!product) {
                console.log('Product not found in productsData:', productsData);
                showToast('Error', 'Product not found', 'danger');
                return;
            }

            title.html('<i class="fas fa-edit me-2"></i>Edit Product');
            $('#product-id').val(product.id);
            $('#product-name').val(product.name || '');
            $('#product-subtitle').val(product.subtitle || '');
            $('#product-price').val(product.price || '');
            $('#product-description').val(product.description || '');
            $('#product-status').val(product.status || 'active');

            if (product.image) {
                setMainImagePreview(product.image);
                currentMainImage = {
                    preview: product.image
                };
            }

            if (product.thumbnails && product.thumbnails.length > 0) {
                product.thumbnails.forEach(url => {
                    addAdditionalImagePreview(url);
                    currentAdditionalImages.push({
                        preview: url
                    });
                });
            }
        } else {
            // ✅ ADD MODE
            console.log('Add mode - Opening empty form');
            title.html('<i class="fas fa-plus me-2"></i>Add New Product');
        }

        new bootstrap.Modal(modal[0]).show();
    }

    // Edit Product function
    window.editProduct = function(productId) {
        console.log('editProduct called with:', productId);
        openProductForm(productId);
    };

    // Image Upload Functions
    function initializeImageUpload() {
        const mainImageUpload = document.getElementById('mainImageUpload');
        const additionalImagesUpload = document.getElementById('additionalImagesUpload');

        ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
            [mainImageUpload, additionalImagesUpload].forEach(el =>
                el.addEventListener(eventName, preventDefaults, false)
            );
        });

        ['dragenter', 'dragover'].forEach(eventName => {
            [mainImageUpload, additionalImagesUpload].forEach(el =>
                el.addEventListener(eventName, () => el.classList.add('dragover'), false)
            );
        });

        ['dragleave', 'drop'].forEach(eventName => {
            [mainImageUpload, additionalImagesUpload].forEach(el =>
                el.addEventListener(eventName, () => el.classList.remove('dragover'), false)
            );
        });

        mainImageUpload.addEventListener('drop', e => handleMainImageFiles(e.dataTransfer.files));
        additionalImagesUpload.addEventListener('drop', e => handleAdditionalImageFiles(e.dataTransfer.files));

        document.getElementById('main-image-file').addEventListener('change', e => handleMainImageFiles(e.target.files));
        document.getElementById('additional-images-file').addEventListener('change', e => handleAdditionalImageFiles(e.target.files));
    }

    function preventDefaults(e) {
        e.preventDefault();
        e.stopPropagation();
    }

    function handleMainImageFiles(files) {
        if (files.length > 0 && files[0].type.startsWith('image/')) {
            const previewUrl = URL.createObjectURL(files[0]);
            currentMainImage = {
                file: files[0],
                preview: previewUrl
            };
            setMainImagePreview(previewUrl);
        }
    }

    function handleAdditionalImageFiles(files) {
        for (let file of files) {
            if (file.type.startsWith('image/')) {
                const previewUrl = URL.createObjectURL(file);
                currentAdditionalImages.push({
                    file: file,
                    preview: previewUrl
                });
                addAdditionalImagePreview(previewUrl);
            }
        }
    }

    function setMainImagePreview(url) {
        document.getElementById('mainImagePreview').innerHTML = `
            <div class="preview-item">
                <img src="${url}" class="preview-image">
                <button type="button" class="remove-image" onclick="removeMainImage()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
    }

    function addAdditionalImagePreview(url) {
        const preview = document.getElementById('additionalImagesPreview');
        const previewId = 'preview-' + Math.random().toString(36).substr(2, 9);
        const previewItem = document.createElement('div');
        previewItem.className = 'preview-item';
        previewItem.innerHTML = `
            <img src="${url}" class="preview-image">
            <button type="button" class="remove-image" onclick="removeAdditionalImage('${previewId}')">
                <i class="fas fa-times"></i>
            </button>
        `;
        previewItem.id = previewId;
        preview.appendChild(previewItem);
    }

    function resetImageUploads() {
        currentMainImage = null;
        currentAdditionalImages = [];
        document.getElementById('mainImagePreview').innerHTML = '';
        document.getElementById('additionalImagesPreview').innerHTML = '';
    }

    window.removeMainImage = function() {
        currentMainImage = null;
        document.getElementById('mainImagePreview').innerHTML = '';
    }

    window.removeAdditionalImage = function(previewId) {
        const previewItem = document.getElementById(previewId);
        if (previewItem) {
            const index = currentAdditionalImages.findIndex(img => img.preview === previewItem.querySelector('img').src);
            if (index !== -1) currentAdditionalImages.splice(index, 1);
            previewItem.remove();
        }
    }

    // Upload image to server
    async function uploadImage(file) {
        const formData = new FormData();
        formData.append('image', file);

        const response = await fetch('<?php echo site_url('admin/upload-image'); ?>', {
            method: 'POST',
            body: formData
        });

        const result = await response.json();
        if (result.status === 'success') return result.image_url;
        throw new Error(result.message);
    }

    // Save Product
    async function saveProduct() {
        const form = $('#productForm')[0];
        if (!form.checkValidity()) {
            form.reportValidity();
            return;
        }

        if (!currentMainImage) {
            showToast('Error', 'Please upload a main image', 'danger');
            return;
        }

        try {
            showToast('Info', 'Saving product...', 'info');

            // Upload main image
            let mainImageUrl = currentMainImage.preview;
            if (currentMainImage.file) {
                mainImageUrl = await uploadImage(currentMainImage.file);
            }

            // Upload additional images
            const additionalImageUrls = [];
            for (const image of currentAdditionalImages) {
                let url = image.preview;
                if (image.file) {
                    url = await uploadImage(image.file);
                }
                additionalImageUrls.push(url);
            }

            const productData = {
                name: $('#product-name').val(),
                subtitle: $('#product-subtitle').val(),
                price: parseFloat($('#product-price').val()),
                description: $('#product-description').val(),
                image: mainImageUrl,
                thumbnails: additionalImageUrls,
                status: $('#product-status').val()
            };

            const productId = $('#product-id').val();
            const url = productId ?
                `<?php echo site_url('admin/products/update/'); ?>${productId}` :
                '<?php echo site_url('admin/products/add'); ?>';
            const method = 'POST';

            const response = await fetch(url, {
                method: method,
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(productData)
            });

            const result = await response.json();
            if (result.status === 'success') {
                showToast('Success', result.message, 'success');
                setTimeout(() => window.location.reload(), 1500);
            } else {
                throw new Error(result.message);
            }

        } catch (error) {
            console.error('Error saving product:', error);
            showToast('Error', error.message, 'danger');
        }
    }

    // Delete Product
    window.deleteProduct = function(productId) {
        const product = productsData.find(p => p.id === productId);
        if (!product) {
            showToast('Error', 'Product not found', 'danger');
            return;
        }

        $('#delete-product-id').text(product.id);
        $('#delete-product-name').text(product.name || 'Unknown Product');
        $('#confirmDeleteBtn').data('product-id', productId);
        new bootstrap.Modal(document.getElementById('deleteProductModal')).show();
    };

    // Confirm Delete
    async function confirmDelete() {
        const productId = $('#confirmDeleteBtn').data('product-id');
        try {
            const response = await fetch(`<?php echo site_url('admin/products/delete/'); ?>${productId}`, {
                method: 'POST'
            });
            const result = await response.json();
            if (result.status === 'success') {
                showToast('Deleted', result.message, 'success');
                setTimeout(() => window.location.reload(), 1500);
            } else {
                throw new Error(result.message);
            }
        } catch (error) {
            console.error('Error deleting product:', error);
            showToast('Error', error.message, 'danger');
        }
        bootstrap.Modal.getInstance(document.getElementById('deleteProductModal')).hide();
    }

    // Toggle Status
    window.toggleStatus = async function(productId) {
        try {
            const response = await fetch(`<?php echo site_url('admin/products/toggle-status/'); ?>${productId}`, {
                method: 'POST'
            });
            const result = await response.json();
            if (result.status === 'success') {
                showToast('Status Updated', result.message, 'info');
                setTimeout(() => window.location.reload(), 1500);
            } else {
                throw new Error(result.message);
            }
        } catch (error) {
            console.error('Error toggling status:', error);
            showToast('Error', error.message, 'danger');
        }
    };

    // Helper function to escape HTML
    function escapeHtml(unsafe) {
        if (!unsafe) return '';
        return unsafe
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    }

    // Toast Notification
    function showToast(title, message, type = 'info') {
        const colors = {
            success: '#1cc88a',
            danger: '#e74a3b',
            warning: '#f6c23e',
            info: '#4e73df'
        };
        const icons = {
            success: 'check-circle',
            danger: 'times-circle',
            warning: 'exclamation-circle',
            info: 'info-circle'
        };

        const toastHtml = `
            <div class="toast-notification" style="position: fixed; top: 20px; right: 20px; z-index: 9999; 
                        background: white; border-left: 4px solid ${colors[type]}; 
                        padding: 15px 20px; border-radius: 8px; 
                        box-shadow: 0 5px 20px rgba(0,0,0,0.2); min-width: 300px;
                        animation: slideIn 0.3s ease;">
                <div style="display: flex; align-items: center; gap: 12px;">
                    <i class="fas fa-${icons[type]}" style="color: ${colors[type]}; font-size: 20px;"></i>
                    <div>
                        <strong style="display: block; margin-bottom: 3px;">${title}</strong>
                        <span style="font-size: 14px; color: #666;">${message}</span>
                    </div>
                </div>
            </div>
        `;

        const $toast = $(toastHtml);
        $('body').append($toast);
        setTimeout(() => {
            $toast.css('animation', 'slideOut 0.3s ease');
            setTimeout(() => $toast.remove(), 300);
        }, 3000);
    }
</script>
<style>
    /* Add these new styles to your existing CSS */

    /* Search Box */
    .search-box {
        min-width: 250px;
    }

    /* Loading Spinner */
    #loadingSpinner {
        background: white;
    }

    /* Table Footer */
    .table-footer {
        padding: 15px 25px;
        border-top: 1px solid #e3e6f0;
        background: #f8f9fc;
    }

    .table-info {
        font-size: 0.875rem;
        color: var(--secondary-color);
    }

    /* Pagination */
    .pagination {
        margin-bottom: 0;
    }

    .page-link {
        color: var(--primary-color);
        border: 1px solid #e3e6f0;
    }

    .page-item.active .page-link {
        background-color: var(--primary-color);
        border-color: var(--primary-color);
    }

    .page-link:hover {
        color: var(--primary-color);
        background-color: #e9ecef;
        border-color: #dee2e6;
    }

    /* Responsive improvements */
    @media (max-width: 768px) {
        .header-actions {
            flex-direction: column;
            gap: 10px;
            align-items: stretch;
        }

        .search-box {
            min-width: auto;
        }

        .filter-buttons {
            order: -1;
        }
    }

    /* Keep all your existing styles from the previous CSS */
</style>
<style>
    /* Image Upload Styles */
    .image-upload-container {
        border: 2px dashed #dee2e6;
        border-radius: 8px;
        padding: 20px;
        text-align: center;
        background: #f8f9fa;
        transition: all 0.3s;
        cursor: pointer;
    }

    .image-upload-container.dragover {
        border-color: var(--primary-color);
        background: #e3f2fd;
    }

    .upload-preview {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-top: 15px;
    }

    .preview-item {
        position: relative;
        width: 80px;
        height: 80px;
    }

    .preview-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 6px;
    }

    .remove-image {
        position: absolute;
        top: -5px;
        right: -5px;
        width: 20px;
        height: 20px;
        background: var(--danger-color);
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        cursor: pointer;
        border: none;
    }

    .page-header {
        margin-bottom: 25px;
    }

    .page-title {
        color: #333;
        font-weight: 600;
        font-size: 1.8rem;
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-card {
        background: white;
        border-radius: 10px;
        padding: 20px;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        display: flex;
        align-items: center;
        transition: transform 0.3s;
    }

    .stat-card:hover {
        transform: translateY(-5px);
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 15px;
        color: white;
        font-size: 1.5rem;
    }

    .stat-icon.all {
        background: linear-gradient(135deg, var(--primary-color), #2e59d9);
    }

    .stat-icon.active {
        background: linear-gradient(135deg, var(--success-color), #17a673);
    }

    .stat-icon.inactive {
        background: linear-gradient(135deg, var(--danger-color), #c9302c);
    }

    .stat-icon.featured {
        background: linear-gradient(135deg, #ffd700, #ffa500);
    }

    .stat-info h6 {
        color: var(--secondary-color);
        font-size: 0.8rem;
        margin-bottom: 5px;
        text-transform: uppercase;
        font-weight: 700;
    }

    .stat-info h3 {
        color: #333;
        font-weight: 700;
        margin: 0;
    }

    .datatable-card {
        background: white;
        border-radius: 10px;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        overflow: hidden;
    }

    .datatable-header {
        padding: 20px 25px;
        border-bottom: 1px solid #e3e6f0;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .datatable-title {
        color: #333;
        font-weight: 600;
        margin: 0;
    }

    .header-actions {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .filter-buttons {
        display: flex;
        background: #f8f9fc;
        border-radius: 8px;
        padding: 4px;
    }

    .filter-btn {
        border: none;
        padding: 8px 16px;
        border-radius: 6px;
        background: transparent;
        font-size: 0.85rem;
        font-weight: 600;
        color: var(--secondary-color);
        transition: all 0.3s;
    }

    .filter-btn.active {
        background: white;
        color: var(--primary-color);
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }

    /* Products Specific Styles */
    .product-info {
        line-height: 1.4;
    }

    .product-name {
        font-weight: 600;
        color: #333;
        margin-bottom: 2px;
    }

    .product-subtitle {
        font-size: 12px;
        color: #666;
    }

    .product-images {
        display: flex;
        gap: 5px;
        flex-wrap: wrap;
    }

    .product-image-thumb {
        width: 35px;
        height: 35px;
        border-radius: 6px;
        object-fit: cover;
        cursor: pointer;
        border: 2px solid #e3e6f0;
        transition: transform 0.3s;
    }

    .product-image-thumb:hover {
        transform: scale(1.2);
        border-color: var(--primary-color);
    }

    .images-count {
        width: 35px;
        height: 35px;
        border-radius: 6px;
        background: #f8f9fc;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        color: var(--secondary-color);
        font-weight: 600;
    }

    /* Status Badges */
    .status-badge {
        padding: 6px 12px;
        border-radius: 50px;
        font-size: 12px;
        font-weight: 600;
        display: inline-block;
    }

    .status-badge.active {
        background: #d4edda;
        color: #155724;
    }

    .status-badge.inactive {
        background: #f8d7da;
        color: #721c24;
    }

    /* Action Buttons */
    .action-btn {
        width: 32px;
        height: 32px;
        border-radius: 6px;
        border: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        margin: 2px;
        transition: all 0.3s;
    }

    .action-btn.view {
        background: #e3f2fd;
        color: #1976d2;
    }

    .action-btn.view:hover {
        background: #1976d2;
        color: white;
    }

    .action-btn.edit {
        background: #e8f5e9;
        color: #388e3c;
    }

    .action-btn.edit:hover {
        background: #388e3c;
        color: white;
    }

    .action-btn.delete {
        background: #f8d7da;
        color: #721c24;
    }

    .action-btn.delete:hover {
        background: #721c24;
        color: white;
    }

    .action-btn.status {
        background: #fff3e0;
        color: #f57c00;
    }

    .action-btn.status:hover {
        background: #f57c00;
        color: white;
    }

    /* Product Detail Rows */
    .product-detail-row {
        display: flex;
        padding: 12px 0;
        border-bottom: 1px solid #f0f0f0;
    }

    .product-detail-row:last-child {
        border-bottom: none;
    }

    .product-detail-label {
        font-weight: 600;
        color: var(--secondary-color);
        width: 150px;
        font-size: 14px;
    }

    .product-detail-value {
        flex: 1;
        color: #333;
        font-size: 14px;
    }

    /* Image Gallery */
    .image-gallery {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }

    .gallery-image {
        width: 100px;
        height: 100px;
        object-fit: cover;
        border-radius: 8px;
        cursor: pointer;
        transition: transform 0.3s;
    }

    .gallery-image:hover {
        transform: scale(1.05);
    }




    /* Toast Notification */
    @keyframes slideIn {
        from {
            transform: translateX(400px);
            opacity: 0;
        }

        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    @keyframes slideOut {
        from {
            transform: translateX(0);
            opacity: 1;
        }

        to {
            transform: translateX(400px);
            opacity: 0;
        }
    }
</style>