<div class="container-fluid py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-7">
                <form id="multiStepForm">
                    <!-- Logged-in User Banner -->
                    <div id="loggedInBanner" class="alert alert-success mb-4" style="display: none;">
                        <div class="d-flex justify-content-between align-items-center">
                            <span><i class="bi bi-check-circle-fill me-2"></i>Logged in as <strong id="loggedInUserName"></strong></span>
                            <button type="button" class="btn btn-sm btn-outline-danger" id="logoutBtn">Logout</button>
                        </div>
                    </div>



                    <!-- Step 1: Customer Type -->
                    <div class="form-step active" data-step="1">
                        <h2>Have you shopped with us before?</h2>
                        <div class="error-message" id="error-step-1"></div>
                        <div class="option-box" data-radio="new">
                            <label>I'm a new Customer</label>
                            <input type="radio" name="customer" value="new" />
                        </div>
                        <div class="option-box" data-radio="existing">
                            <label>I'm an existing Customer</label>
                            <input type="radio" name="customer" value="existing" />
                        </div>
                    </div>

                    <!-- Step 2: Login for Existing Customer -->
                    <div class="form-step" data-step="2" id="existingUserStep">
                        <h2>Welcome back!</h2>
                        <p class="text-muted mb-3">Please login to continue with your order.</p>
                        <div class="error-message" id="error-step-2"></div>

                        <div class="mb-3 text-start">
                            <label for="existingEmail" class="form-label">Email address</label>
                            <input type="email" id="existingEmail" class="form-control" placeholder="Enter your email" />
                            <div class="invalid-feedback">Please enter a valid email address</div>
                        </div>

                        <div class="mb-3 text-start">
                            <label for="existingPassword" class="form-label">Password</label>
                            <input type="password" id="existingPassword" class="form-control" placeholder="Enter your password" />
                            <div class="invalid-feedback">Please enter your password</div>
                        </div>

                        <button type="button" class="btn btn-primary w-100 mb-3" id="continueExistingBtn">Login & Continue</button>
                    </div>

                    <!-- Step 3: Registration Choice (New Customers) -->
                    <div class="form-step" data-step="3" id="registrationChoiceStep">
                        <h2>Would you like to create an account?</h2>
                        <p class="text-muted mb-3">Creating an account lets you save your progress and track your orders.</p>
                        <div class="error-message" id="error-step-3"></div>

                        <div class="option-box" data-radio="register">
                            <label>Yes, create an account</label>
                            <input type="radio" name="registration_choice" value="register" />
                        </div>
                        <div class="option-box" data-radio="continue">
                            <label>No, continue without registration</label>
                            <input type="radio" name="registration_choice" value="continue" />
                        </div>
                    </div>

                    <!-- Step 4: Account Creation -->
                    <div class="form-step" data-step="4" id="createAccountStep">
                        <h2>Create Your Account</h2>
                        <p class="text-muted mb-3">Please fill in your details to continue.</p>
                        <div class="error-message" id="error-step-4"></div>

                        <div class="mb-3 text-start">
                            <label for="accountName" class="form-label">Full Name</label>
                            <input type="text" id="accountName" class="form-control" placeholder="Enter your name" />
                        </div>

                        <div class="mb-3 text-start">
                            <label for="accountEmail" class="form-label">Email Address</label>
                            <input type="email" id="accountEmail" class="form-control" placeholder="Enter your email" />
                        </div>

                        <div class="mb-3 text-start">
                            <label for="accountPassword" class="form-label">Password</label>
                            <input type="password" id="accountPassword" class="form-control" placeholder="Enter your password" />
                        </div>

                        <div class="mb-3 text-start">
                            <label for="accountPhone" class="form-label">Phone Number</label>
                            <input type="text" id="accountPhone" class="form-control" placeholder="Enter your phone number" />
                        </div>

                        <button type="button" class="btn btn-primary w-100" id="createAccountBtn">Create Account</button>
                    </div>

                    <!-- Step 5: Type of treatment -->
                    <div class="form-step" data-step="5">
                        <h2 class="mb-4">Choose the type of treatment you're looking for</h2>
                        <div class="error-message" id="error-step-5"></div>
                        <div class="row g-3">
                            <div class="col-12">
                                <div class="option-card" data-value="injectable">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <p class="mb-0">Injectable pens</p>
                                        <span>💉</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="option-card" data-value="oral">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <p class="mb-0">Oral tablets</p>
                                        <span>💊</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="treatment_type" id="treatment_type" />
                    </div>

                    <!-- Step 6: Height & Weight -->
                    <div class="form-step" data-step="6">
                        <h2>What's your height?</h2>
                        <div class="error-message" id="error-step-6"></div>

                        <div id="heightCmDiv" class="height-group d-flex align-items-center mb-2">
                            <input type="number" id="heightCm" placeholder="Enter height" class="form-control me-2" min="1" step="0.1" />
                            <span class="unit-text">centimeters</span>
                        </div>

                        <div id="heightFtDiv" class="height-group d-flex align-items-center mb-2 hidden">
                            <input type="number" id="heightFeet" placeholder="Feet" class="form-control me-2" min="1" style="max-width:120px;" />
                            <input type="number" id="heightInches" placeholder="Inches" class="form-control me-2" min="0" max="11" style="max-width:120px;" />
                            <span class="unit-text">ft/in</span>
                        </div>

                        <div class="switch-link text-primary" id="switchHeight" style="cursor:pointer;">Switch to feet/inches</div>

                        <h2 class="mt-4">What's your weight?</h2>

                        <div id="weightKgDiv" class="weight-group d-flex align-items-center mb-2">
                            <input type="number" id="weightKg" placeholder="Enter weight" class="form-control me-2" min="1" step="0.1" />
                            <span class="unit-text">kilograms</span>
                        </div>

                        <div id="weightStDiv" class="weight-group d-flex align-items-center mb-2 hidden">
                            <input type="number" id="weightStone" placeholder="Stone" class="form-control me-2" min="0" style="max-width:120px;" />
                            <input type="number" id="weightPound" placeholder="Pounds" class="form-control me-2" min="0" max="13" style="max-width:120px;" />
                            <span class="unit-text">st/lb</span>
                        </div>

                        <div class="switch-link text-primary" id="switchWeight" style="cursor:pointer;">Switch to stones/pounds</div>
                    </div>

                    <!-- Step 7: Medical Conditions -->
                    <div class="form-step" data-step="7">
                        <h2>Have you been diagnosed with any of the following conditions?</h2>
                        <p class="text-muted mb-3">These health conditions are often linked to weight, and may be improved with weight loss.</p>
                        <div class="error-message" id="error-step-7"></div>

                        <div class="option-box"><label>Prediabetes</label><input type="checkbox" name="conditions[]" value="Prediabetes" /></div>
                        <div class="option-box"><label>Type 2 diabetes</label><input type="checkbox" name="conditions[]" value="Type 2 diabetes" /></div>
                        <div class="option-box"><label>High blood pressure</label><input type="checkbox" name="conditions[]" value="High blood pressure" /></div>
                        <div class="option-box"><label>High cholesterol</label><input type="checkbox" name="conditions[]" value="High cholesterol" /></div>
                        <div class="option-box"><label>Heart or blood vessel disease</label><input type="checkbox" name="conditions[]" value="Heart or blood vessel disease" /></div>
                        <div class="option-box"><label>Previous stroke</label><input type="checkbox" name="conditions[]" value="Previous stroke" /></div>
                        <div class="option-box"><label>Obstructive sleep apnoea</label><input type="checkbox" name="conditions[]" value="Obstructive sleep apnoea" /></div>
                        <div class="option-box"><label>Acid reflux or GORD</label><input type="checkbox" name="conditions[]" value="Acid reflux or GORD" /></div>
                        <div class="option-box"><label>MASLD</label><input type="checkbox" name="conditions[]" value="MASLD" /></div>
                        <div class="option-box"><label>Osteoarthritis</label><input type="checkbox" name="conditions[]" value="Osteoarthritis" /></div>
                        <div class="option-box"><label>Depression</label><input type="checkbox" name="conditions[]" value="Depression" /></div>
                        <div class="option-box"><label>Erectile dysfunction</label><input type="checkbox" name="conditions[]" value="Erectile dysfunction" /></div>
                        <div class="option-box"><label>PCOS</label><input type="checkbox" name="conditions[]" value="PCOS" /></div>

                        <hr class="my-3" />

                        <div class="option-box"><label><strong>None of the above</strong></label><input type="checkbox" name="conditions[]" value="None of the above" id="noneCondition" /></div>
                    </div>

                    <!-- Step 8: Ethnicity -->
                    <div class="form-step" data-step="8">
                        <h2>What is your ethnicity?</h2>
                        <p class="text-muted mb-3">We ask this because healthy weight ranges vary for different ethnic backgrounds.</p>
                        <div class="error-message" id="error-step-8"></div>

                        <div class="option-box"><label>Asian or Asian British</label><input type="radio" name="ethnicity" value="Asian or Asian British" /></div>
                        <div class="option-box"><label>Black, African, Caribbean or Black British</label><input type="radio" name="ethnicity" value="Black, African, Caribbean or Black British" /></div>
                        <div class="option-box"><label>Middle Eastern</label><input type="radio" name="ethnicity" value="Middle Eastern" /></div>
                        <div class="option-box"><label>Mixed or multiple ethnicities</label><input type="radio" name="ethnicity" value="Mixed or multiple ethnicities" /></div>
                        <div class="option-box"><label>White</label><input type="radio" name="ethnicity" value="White" /></div>
                        <div class="option-box"><label>Other ethnic group</label><input type="radio" name="ethnicity" value="Other" /></div>
                        <div class="option-box"><label>Prefer not to say</label><input type="radio" name="ethnicity" value="Prefer not to say" /></div>
                    </div>

                    <!-- Step 9: Age -->
                    <div class="form-step" data-step="9">
                        <h2>Are you aged 18 to 74 years old?</h2>
                        <div class="error-message" id="error-step-9"></div>
                        <div class="option-box"><label>Yes</label><input type="radio" name="age" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="age" value="No" /></div>
                    </div>

                    <!-- Step 10: Allergic Reactions -->
                    <div class="form-step" data-step="10">
                        <h2>Have you ever experienced an allergic reaction to any of the following medications?</h2>
                        <p class="text-muted mb-3">Select all that apply.</p>
                        <div class="error-message" id="error-step-10"></div>

                        <div class="option-box"><label>Wegovy/Ozempic (semaglutide)</label><input type="checkbox" name="allergy[]" value="Wegovy/Ozempic" /></div>
                        <div class="option-box"><label>Mounjaro (tirzepatide)</label><input type="checkbox" name="allergy[]" value="Mounjaro" /></div>
                        <div class="option-box"><label>Saxenda/Nevolat/Victoza (liraglutide)</label><input type="checkbox" name="allergy[]" value="Saxenda/Nevolat/Victoza" /></div>
                        <div class="option-box"><label>I have other allergies</label><input type="checkbox" name="allergy[]" value="Other allergies" /></div>

                        <hr class="my-3" />

                        <div class="option-box"><label><strong>None of the above</strong></label><input type="checkbox" name="allergy[]" value="None of the above" id="noneAllergy" /></div>
                    </div>

                    <!-- Step 11: Pregnancy -->
                    <div class="form-step" data-step="11">
                        <h2>Are you currently pregnant, breastfeeding, or planning a pregnancy in the next 3 months?</h2>
                        <p class="text-muted mb-3">GLP-1 medications should not be used during pregnancy or while breastfeeding.</p>
                        <div class="error-message" id="error-step-11"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="pregnancy" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="pregnancy" value="No" /></div>
                    </div>

                    <!-- Step 12: Medical History -->
                    <div class="form-step" data-step="12">
                        <h2>Do you have, or have you ever had, any of the following conditions?</h2>
                        <p class="text-muted mb-3">For your safety, it's important to tell us about your medical history.</p>
                        <div class="error-message" id="error-step-12"></div>

                        <div class="option-box"><label>Pancreatitis</label><input type="checkbox" name="medical_history[]" value="Pancreatitis" /></div>
                        <div class="option-box"><label>Type 1 diabetes</label><input type="checkbox" name="medical_history[]" value="Type 1 diabetes" /></div>
                        <div class="option-box"><label>Eating disorder</label><input type="checkbox" name="medical_history[]" value="Eating disorder" /></div>
                        <div class="option-box"><label>Recent weight loss surgery</label><input type="checkbox" name="medical_history[]" value="Recent weight loss surgery" /></div>
                        <div class="option-box"><label>Thyroid cancer or MEN2</label><input type="checkbox" name="medical_history[]" value="Thyroid cancer or MEN2" /></div>
                        <div class="option-box"><label>Active cancer</label><input type="checkbox" name="medical_history[]" value="Active cancer" /></div>
                        <div class="option-box"><label>Active retinopathy</label><input type="checkbox" name="medical_history[]" value="Active retinopathy" /></div>
                        <div class="option-box"><label>Heart failure</label><input type="checkbox" name="medical_history[]" value="Heart failure" /></div>

                        <hr class="my-3" />

                        <div class="option-box"><label><strong>None of the above</strong></label><input type="checkbox" id="noneMedical" name="medical_history[]" value="None of the above" /></div>
                    </div>

                    <!-- Step 13: Thyroid/Liver Disease -->
                    <div class="form-step" data-step="13">
                        <h2>Have you been diagnosed with either thyroid disease, or liver disease or impairment?</h2>
                        <div class="error-message" id="error-step-13"></div>
                        <div class="option-box"><label>Yes</label><input type="radio" name="thyroid_liver_disease" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="thyroid_liver_disease" value="No" /></div>
                    </div>

                    <!-- Step 14: Gallbladder Issues -->
                    <div class="form-step" data-step="14">
                        <h2>Do you have any of the following gallbladder issues?</h2>
                        <ul class="text-muted mb-3" style="list-style-type: disc; padding-left: 20px;">
                            <li>Gallstones that have not been removed</li>
                            <li>Blocked bile flow</li>
                            <li>Gallbladder infection</li>
                            <li>Gallbladder surgery in the past 12 months</li>
                        </ul>
                        <div class="error-message" id="error-step-14"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="gallbladder_issues" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="gallbladder_issues" value="No" /></div>
                    </div>

                    <!-- Step 15: Other Health Issues -->
                    <div class="form-step" data-step="15">
                        <h2>Do you have, or have you ever had, any of these conditions?</h2>
                        <p class="text-muted mb-3">It's important to tell us about your medical history.</p>
                        <div class="error-message" id="error-step-15"></div>

                        <div class="option-box"><label>Chronic kidney disease</label><input type="checkbox" name="other_health_issues[]" value="Chronic kidney disease" /></div>
                        <div class="option-box"><label>Severe gastrointestinal disease</label><input type="checkbox" name="other_health_issues[]" value="Severe gastrointestinal disease" /></div>
                        <div class="option-box"><label>Chronic malabsorption syndrome</label><input type="checkbox" name="other_health_issues[]" value="Chronic malabsorption syndrome" /></div>
                        <div class="option-box"><label>Liver cirrhosis or transplant</label><input type="checkbox" name="other_health_issues[]" value="Liver cirrhosis or transplant" /></div>
                        <div class="option-box"><label>Endocrine disorder</label><input type="checkbox" name="other_health_issues[]" value="Endocrine disorder" /></div>
                        <div class="option-box"><label>Excessive alcohol use</label><input type="checkbox" name="other_health_issues[]" value="Excessive alcohol use" /></div>
                        <div class="option-box"><label>Cognitive or memory impairment</label><input type="checkbox" name="other_health_issues[]" value="Cognitive or memory impairment" /></div>

                        <hr class="my-3" />

                        <div class="option-box"><label><strong>None of the above</strong></label><input type="checkbox" name="other_health_issues[]" id="noneOtherHealth" value="None of the above" /></div>
                    </div>

                    <!-- Step 16: Insulin Use -->
                    <div class="form-step" data-step="16">
                        <h2>If you have type 2 diabetes, are you using insulin?</h2>
                        <p class="text-muted mb-3">This treatment can affect insulin requirement and blood sugar regulation.</p>
                        <div class="error-message" id="error-step-16"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="insulin_use" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="insulin_use" value="No" /></div>
                    </div>

                    <!-- Step 17: Other Diabetes Medication -->
                    <div class="form-step" data-step="17">
                        <h2>If you have type 2 diabetes, are you taking any oral or injectable medication (other than metformin and insulin)?</h2>
                        <div class="error-message" id="error-step-17"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="other_diabetes_med" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="other_diabetes_med" value="No" /></div>
                    </div>

                    <!-- Step 18: Current Medications -->
                    <div class="form-step" data-step="18">
                        <h2>Are you currently taking any of the following medications?</h2>
                        <ul class="text-muted mb-3" style="list-style-type: disc; padding-left: 20px; font-size: 0.9rem;">
                            <li>Amiodarone, Carbamazepine, Ciclosporin, Clozapine, Digoxin</li>
                            <li>Fenfluramine, Lithium, Mycophenolate, Methotrexate</li>
                            <li>Phenobarbital, Phenytoin, Tacrolimus, Theophylline, Warfarin</li>
                        </ul>
                        <div class="error-message" id="error-step-18"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="medication_use" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="medication_use" value="No" /></div>
                    </div>

                    <!-- Step 19: Smoking -->
                    <div class="form-step" data-step="19">
                        <h2>Are you currently a smoker?</h2>
                        <div class="error-message" id="error-step-19"></div>
                        <div class="option-box"><label>Yes</label><input type="radio" name="smoker" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="smoker" value="No" /></div>
                    </div>

                    <!-- Step 20: Recent Medication -->
                    <div class="form-step" data-step="20">
                        <h2>Have you taken injectable weight loss medication in the last 6 months?</h2>
                        <p class="text-muted mb-3">This can be with us or another provider.</p>
                        <div class="error-message" id="error-step-20"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="recent_medication" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="recent_medication" value="No" /></div>
                    </div>

                    <!-- Step 21: Dose Understanding -->
                    <div class="form-step" data-step="21">
                        <h2>Do you understand you may need to provide evidence of prescription if ordering a non-starter dose?</h2>
                        <div class="error-message" id="error-step-21"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="dose_understanding" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="dose_understanding" value="No" /></div>
                    </div>

                    <!-- Step 22: Contraceptive Agreement -->
                    <div class="form-step" data-step="22">
                        <h2>If sexually active, Mounjaro may reduce oral contraceptive effectiveness. Do you agree to use alternative contraception?</h2>
                        <div class="error-message" id="error-step-22"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="contraceptive_agreement" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="contraceptive_agreement" value="No" /></div>
                    </div>

                    <!-- Step 23: Information Agreement -->
                    <div class="form-step" data-step="23">
                        <h2>Do you agree to the following?</h2>
                        <ul class="text-muted mb-3">
                            <li>The information I have provided is true and accurate</li>
                            <li>I understand failure to give accurate information may result in refusal</li>
                        </ul>
                        <div class="error-message" id="error-step-23"></div>

                        <div class="option-box"><label>Yes</label><input type="radio" name="agreement_confirmation" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="agreement_confirmation" value="No" /></div>
                    </div>

                    <!-- Step 24: Treatment Information -->
                    <div class="form-step" data-step="24">
                        <h2>Please check you understand this treatment information:</h2>
                        <ul class="text-muted mb-3" style="font-size: 0.9rem;">
                            <li>I understand rapid weight loss can raise risk of pancreatitis and gallbladder issues</li>
                            <li>I understand severe diarrhoea can reduce contraceptive effectiveness</li>
                            <li>I will not combine with other weight loss medications</li>
                            <li>I recognize these treatments may affect my mood</li>
                        </ul>
                        <div class="error-message" id="error-step-24"></div>

                        <div class="option-box"><label><strong>I confirm understanding</strong></label><input type="radio" name="treatment_agreement" value="I agree" /></div>
                    </div>

                    <!-- Step 25: Final Consent -->
                    <div class="form-step" data-step="25">
                        <h2>Final consent:</h2>
                        <ul class="text-muted mb-3" style="font-size: 0.9rem;">
                            <li>Treatment is for my own use only</li>
                            <li>I will read the patient information leaflet</li>
                            <li>I will contact provider about side effects</li>
                            <li>I agree to GP notification</li>
                        </ul>
                        <div class="error-message" id="error-step-25"></div>

                        <div class="option-box"><label><strong>I agree</strong></label><input type="radio" name="final_consent" value="I agree" /></div>
                    </div>

                    <!-- Step 26: Assisted Prescribing -->
                    <div class="form-step" data-step="26">
                        <h2>I agree to my prescription being issued faster via the assisted prescribing service, if eligible.</h2>
                        <p class="text-muted mb-3">(Optional)</p>
                        <div class="error-message" id="error-step-26"></div>

                        <div class="option-box"><label>Yes, I agree</label><input type="radio" name="assisted_prescribing" value="Yes" /></div>
                        <div class="option-box"><label>No</label><input type="radio" name="assisted_prescribing" value="No" /></div>
                    </div>

                    <!-- Step 27: Privacy -->
                    <div class="form-step" data-step="27">
                        <h2>I understand my data is processed as described in the privacy policy.</h2>
                        <div class="error-message" id="error-step-27"></div>

                        <div class="option-box"><label><strong>I agree</strong></label><input type="radio" name="privacy_consent" value="I agree" /></div>
                    </div>

                    <!-- Step 28: Terms -->
                    <div class="form-step" data-step="28">
                        <h2>I agree to the Terms and Conditions and confirm I am over 18.</h2>
                        <div class="error-message" id="error-step-28"></div>

                        <div class="option-box"><label><strong>I agree</strong></label><input type="radio" name="terms_consent" value="I agree" /></div>
                    </div>

                    <!-- Navigation -->
                    <div class="form-navigation">
                        <button type="button" class="btn-nav" id="prevBtn">Back</button>
                        <button type="button" class="btn-nav" id="nextBtn">Next</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.bundle.min.js"></script>
<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const continueExistingBtn = document.getElementById('continueExistingBtn');
        const existingEmail = document.getElementById('existingEmail');
        const createAccountBtn = document.getElementById('createAccountBtn');
        const accountCreationStep = document.getElementById('accountCreationStep');
        const existingUserStep = document.getElementById('existingUserStep');

        const multiStepForm = {
            customer: '',
            email: '',
            name: '',
            password: '',
            phone: ''
        };

        // =======================
        // Navigate to next step
        // =======================
        function goToNextStep() {
            // Replace with your next step selector
            const nextStep = document.querySelector('.form-step.next');
            if (nextStep) {
                document.querySelectorAll('.form-step').forEach(step => step.classList.add('hidden'));
                nextStep.classList.remove('hidden');
                Swal.fire('Success!', 'You can continue filling your data.', 'success');
            }
        }

        // =======================
        // Existing Customer Check
        // =======================
        continueExistingBtn?.addEventListener('click', async () => {
            const emailValue = existingEmail.value.trim();
            if (!validateEmail(emailValue)) {
                existingEmail.classList.add('is-invalid');
                Swal.fire('Oops!', 'Please enter a valid email!', 'error');
                return;
            }
            existingEmail.classList.remove('is-invalid');
            multiStepForm.email = emailValue;

            try {
                const res = await fetch('/api/check-email', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        email: emailValue
                    })
                });
                const data = await res.json();

                if (data.success && data.exists) {
                    // Store user session
                    sessionStorage.setItem('user', JSON.stringify({
                        user_id: data.user_id,
                        email: multiStepForm.email,
                        name: data.name || ''
                    }));
                    Swal.fire('Welcome back!', 'Email exists, continue filling your data.', 'success')
                        .then(() => goToNextStep());
                } else {
                    Swal.fire('Info', 'Email not found, please create an account.', 'info');
                    showAccountCreationStep();
                }
            } catch (err) {
                console.error(err);
                Swal.fire('Error', 'Network error. Please try again.', 'error');
            }
        });

        // =======================
        // Account Creation
        // =======================
        createAccountBtn?.addEventListener('click', async () => {
            const name = document.getElementById('accountName').value.trim();
            const email = document.getElementById('accountEmail').value.trim();
            const password = document.getElementById('accountPassword').value.trim();
            const phone = document.getElementById('accountPhone').value.trim();

            if (!name || !email || !password || !phone) {
                Swal.fire('Oops!', 'Please fill all required fields.', 'error');
                return;
            }

            multiStepForm.name = name;
            multiStepForm.email = email;
            multiStepForm.password = password;
            multiStepForm.phone = phone;

            try {
                const res = await fetch('/api/create-account', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(multiStepForm)
                });
                const data = await res.json();

                if (data.success) {
                    // Auto-login: store session
                    sessionStorage.setItem('user', JSON.stringify({
                        user_id: data.user_id,
                        email: multiStepForm.email,
                        name: multiStepForm.name
                    }));

                    Swal.fire('Success!', 'Account created & logged in successfully.', 'success')
                        .then(() => goToNextStep());
                } else {
                    Swal.fire('Error', data.message || 'Failed to create account.', 'error');
                }
            } catch (err) {
                console.error(err);
                Swal.fire('Error', 'Network error. Please try again.', 'error');
            }
        });

        // =======================
        // Submit Eligibility
        // =======================
        async function submitEligibility(userId) {
            const eligibilityData = collectEligibilityData();
            eligibilityData.user_id = userId;

            try {
                const res = await fetch('/api/submit-eligibility', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(eligibilityData)
                });
                const data = await res.json();

                if (data.success) {
                    Swal.fire('Well done!', 'Eligibility submitted successfully!', 'success')
                        .then(() => {
                            window.location.href = `/recommend/product/${data.eligibility_id}`;
                        });
                } else {
                    Swal.fire('Oops!', data.message || 'Submission failed!', 'error');
                }
            } catch (err) {
                console.error(err);
                Swal.fire('Error', 'Network error. Please try again.', 'error');
            }
        }

        // =======================
        // Utility Functions
        // =======================
        function validateEmail(email) {
            return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
        }

        function showAccountCreationStep() {
            existingUserStep?.classList.add('hidden');
            accountCreationStep?.classList.remove('hidden');

            const accountEmailInput = document.getElementById('accountEmail');
            if (accountEmailInput && multiStepForm.email) accountEmailInput.value = multiStepForm.email;
        }

        existingEmail?.addEventListener('input', () => {
            const accountEmailInput = document.getElementById('accountEmail');
            if (accountEmailInput) accountEmailInput.value = existingEmail.value.trim();
        });

        // =======================
        // Placeholder: Collect eligibility form data
        // =======================
        function collectEligibilityData() {
            const data = {};
            // Replace with all your form fields
            const treatmentType = document.getElementById('treatment_type');
            if (treatmentType) data.treatment_type = treatmentType.value;

            const heightCm = document.getElementById('heightCm');
            if (heightCm) data.height_cm = parseFloat(heightCm.value);

            const weightKg = document.getElementById('weightKg');
            if (weightKg) data.weight_kg = parseFloat(weightKg.value);

            return data;
        }
    });
</script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        /* ==========================================================================
       GLOBAL VARIABLES
    ========================================================================== */
        const steps = document.querySelectorAll(".form-step");
        const nextBtn = document.getElementById("nextBtn");
        const prevBtn = document.getElementById("prevBtn");
        const continueExistingBtn = document.getElementById("continueExistingBtn");
        const existingEmail = document.getElementById("existingEmail");
        const existingPassword = document.getElementById("existingPassword");
        const createAccountBtn = document.getElementById("createAccountBtn");

        let currentStep = 0;
        let currentUserId = null;
        const formData = {};

        /* ==========================================================================
           SESSION CHECK
        ========================================================================== */
        function checkUserSession() {
            const user = sessionStorage.getItem('user');
            if (user) {
                const userData = JSON.parse(user);
                currentUserId = userData.user_id;
                formData.user_id = userData.user_id;
                return true;
            }
            return false;
        }

        const isLoggedIn = checkUserSession();

        // Show logged-in banner if user is logged in
        if (isLoggedIn) {
            const user = JSON.parse(sessionStorage.getItem('user'));
            const banner = document.getElementById('loggedInBanner');
            if (banner) {
                banner.style.display = 'block';
                document.getElementById('loggedInUserName').textContent = user.email;

                document.getElementById('logoutBtn').addEventListener('click', () => {
                    sessionStorage.removeItem('user');
                    fetch("<?php echo base_url('home/logout'); ?>")
                        .then(() => location.reload());
                });
            }
        }

        /* ==========================================================================
           AUTO-ADVANCE FOR RADIO BUTTONS (Except Final Step)
        ========================================================================== */
        function setupAutoAdvanceForRadioButtons() {
            document.querySelectorAll('input[type="radio"]').forEach(radio => {
                radio.addEventListener('change', function() {
                    const currentActiveStep = document.querySelector('.form-step.active');
                    if (currentActiveStep && currentActiveStep.contains(this)) {
                        // Only auto-advance for steps before the final consent steps
                        if (currentStep <= 23) { // Steps 0-23 auto-advance, 24+ don't
                            setTimeout(() => {
                                nextStep();
                            }, 300);
                        }
                    }
                });
            });
        }

        /* ==========================================================================
       STEP NAVIGATION
    ========================================================================== */
        function showStep(index) {
            steps.forEach((step, i) => step.classList.toggle("active", i === index));
            window.scrollTo({
                top: 0,
                behavior: "smooth"
            });
            nextBtn.textContent = index === steps.length - 1 ? "Submit" : "Next";

            // Show/hide back button on first step
            if (index === 0) {
                prevBtn.style.display = 'none';
            } else {
                prevBtn.style.display = 'block';
            }
        }

        function nextStep() {
            if (!validateCurrentStep()) return;

            // Step 0: Customer Type Selection
            if (currentStep === 0) {
                const selected = document.querySelector('input[name="customer"]:checked');
                if (selected) {
                    // Check if user is already logged in
                    if (isLoggedIn || checkUserSession()) {
                        // User is logged in - skip directly to treatment type (Step 4)
                        currentStep = 4;
                        showStep(currentStep);
                        return;
                    }

                    // User not logged in
                    if (selected.value === 'existing') {
                        currentStep = 1; // Go to login step
                    } else {
                        currentStep = 2; // Go to registration choice step
                    }
                    showStep(currentStep);
                }
                return;
            }

            // Step 1: Login (Existing customers)
            if (currentStep === 1) {
                loginExistingUser();
                return;
            }

            // Step 2: Registration Choice (New customers)
            if (currentStep === 2) {
                const registrationChoice = document.querySelector('input[name="registration_choice"]:checked');
                if (registrationChoice) {
                    if (registrationChoice.value === 'register') {
                        currentStep = 3; // Go to account creation
                    } else {
                        // Continue without registration - skip to treatment type
                        currentStep = 4;
                    }
                    showStep(currentStep);
                }
                return;
            }

            // Step 3: Account Creation
            if (currentStep === 3) {
                if (validateAccountCreation()) {
                    createAccountAndProceed();
                    return;
                } else {
                    return;
                }
            }

            // Normal step progression (Steps 4+)
            if (currentStep < steps.length - 1) {
                currentStep++;
                showStep(currentStep);
            } else {
                submitForm();
            }
        }

        function prevStep() {
            // From Step 4 (Treatment Type) - smart back navigation
            if (currentStep === 4) {
                // Check if user is logged in
                if (isLoggedIn || sessionStorage.getItem('user')) {
                    currentStep = 0; // Go back to customer type
                } else {
                    // User is not logged in - check how they got here
                    const customerType = document.querySelector('input[name="customer"]:checked');
                    if (customerType && customerType.value === 'new') {
                        // New customer path
                        const registrationChoice = document.querySelector('input[name="registration_choice"]:checked');
                        if (registrationChoice && registrationChoice.value === 'register') {
                            currentStep = 3; // Go back to account creation
                        } else {
                            currentStep = 2; // Go back to registration choice
                        }
                    } else {
                        // Existing customer path
                        currentStep = 1; // Go back to login
                    }
                }
            }
            // From Step 3 (Account Creation)
            else if (currentStep === 3) {
                currentStep = 2; // Go back to registration choice
            }
            // From Step 2 (Registration Choice)
            else if (currentStep === 2) {
                currentStep = 0; // Go back to customer type
            }
            // From Step 1 (Login)
            else if (currentStep === 1) {
                currentStep = 0; // Go back to customer type
            }
            // Normal back navigation
            else if (currentStep > 0) {
                currentStep--;
            }

            showStep(currentStep);
        }


        /* ==========================================================================
           EXISTING CUSTOMER EMAIL CHECK API
        ========================================================================== */
        async function loginExistingUser() {
            const emailValue = existingEmail.value.trim();
            const passwordValue = existingPassword.value.trim();

            if (!validateEmail(emailValue)) {
                existingEmail.classList.add('is-invalid');
                showError(1, 'Please enter a valid email address');
                return false;
            }

            if (!passwordValue) {
                existingPassword.classList.add('is-invalid');
                showError(1, 'Please enter your password');
                return false;
            }

            continueExistingBtn.disabled = true;
            continueExistingBtn.textContent = 'Logging in...';
            nextBtn.disabled = true;

            try {
                const response = await fetch("<?php echo base_url('home/login'); ?>", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({
                        email: emailValue,
                        password: passwordValue
                    })
                });

                const data = await response.json();

                if (data.success) {
                    currentUserId = data.user_id;
                    formData.user_id = data.user_id;
                    formData.existingEmail = emailValue;

                    sessionStorage.setItem('user', JSON.stringify({
                        user_id: data.user_id,
                        email: emailValue,
                        name: data.name || ''
                    }));

                    Swal.fire({
                        icon: 'success',
                        title: 'Welcome back!',
                        text: 'Login successful. Continuing to the form...',
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        currentStep = 4; // Go to treatment type
                        showStep(currentStep);
                    });
                } else {
                    showError(1, data.message || 'Invalid email or password');
                }
            } catch (error) {
                console.error('Error:', error);
                showError(1, 'Network error. Please try again.');
            } finally {
                continueExistingBtn.disabled = false;
                continueExistingBtn.textContent = 'Login & Continue';
                nextBtn.disabled = false;
            }

            return true;
        }

        /* ==========================================================================
           ACCOUNT CREATION FUNCTIONS
        ========================================================================== */
        function validateAccountCreation() {
            const step = steps[currentStep];
            const errorDiv = step.querySelector('.error-message');
            let isValid = true;
            let errorMessage = '';

            if (errorDiv) {
                errorDiv.classList.remove('show');
                errorDiv.textContent = '';
            }

            const name = document.getElementById('accountName');
            const email = document.getElementById('accountEmail');
            const password = document.getElementById('accountPassword');
            const phone = document.getElementById('accountPhone');

            if (!name || !name.value.trim()) {
                isValid = false;
                name?.classList.add('is-invalid');
                errorMessage = 'Please enter your full name';
            } else {
                name?.classList.remove('is-invalid');
            }

            if (!email || !validateEmail(email.value.trim())) {
                isValid = false;
                email?.classList.add('is-invalid');
                errorMessage = 'Please enter a valid email address';
            } else {
                email?.classList.remove('is-invalid');
            }

            if (!password || !password.value.trim()) {
                isValid = false;
                password?.classList.add('is-invalid');
                errorMessage = 'Please enter a password';
            } else {
                password?.classList.remove('is-invalid');
            }

            if (!phone || !phone.value.trim()) {
                isValid = false;
                phone?.classList.add('is-invalid');
                errorMessage = 'Please enter your phone number';
            } else {
                phone?.classList.remove('is-invalid');
            }

            if (!isValid && errorDiv) {
                errorDiv.textContent = errorMessage;
                errorDiv.classList.add('show');
            }

            return isValid;
        }

        async function createAccountAndProceed() {
            const name = document.getElementById('accountName').value.trim();
            const email = document.getElementById('accountEmail').value.trim();
            const password = document.getElementById('accountPassword').value.trim();
            const phone = document.getElementById('accountPhone').value.trim();

            createAccountBtn.disabled = true;
            createAccountBtn.textContent = 'Creating Account...';

            try {
                const response = await fetch("<?php echo base_url('home/createAccount'); ?>", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({
                        name,
                        email,
                        password,
                        phone
                    })
                });

                const data = await response.json();

                if (data.success) {
                    currentUserId = data.user_id;
                    formData.account = {
                        name,
                        email,
                        phone
                    };
                    formData.user_id = data.user_id;

                    sessionStorage.setItem('user', JSON.stringify({
                        user_id: data.user_id,
                        email: email,
                        name: name
                    }));

                    Swal.fire({
                        icon: 'success',
                        title: 'Account Created!',
                        text: 'You are now logged in.',
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        currentStep = 4; // Go to treatment type
                        showStep(currentStep);
                    });
                } else {
                    showError(3, data.message || 'Failed to create account');
                }
            } catch (error) {
                console.error('Error:', error);
                showError(3, 'Network error. Please try again.');
            } finally {
                createAccountBtn.textContent = 'Create Account';
                createAccountBtn.disabled = false;
            }
        }

        /* ==========================================================================
           HELPER FUNCTIONS
        ========================================================================== */
        function showError(stepId, message) {
            const errorDiv = document.getElementById(`error-step-${stepId}`) ||
                document.getElementById(`error-${stepId}`);
            if (errorDiv) {
                errorDiv.textContent = message;
                errorDiv.classList.add('show');
            }
        }

        function showAccountCreationStep() {
            // Update the flow to show account creation
            const existingUserStep = document.getElementById('existingUserStep');
            const createAccountStep = document.getElementById('createAccountStep');

            if (existingUserStep && createAccountStep) {
                existingUserStep.classList.remove('active');
                createAccountStep.classList.add('active');
                currentStep = 3; // Update current step to account creation

                // Pre-fill email if available
                const accountEmail = document.getElementById('accountEmail');
                if (accountEmail && existingEmail.value) {
                    accountEmail.value = existingEmail.value;
                }
            }
        }

        function validateEmail(email) {
            return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
        }

        function validateCurrentStep() {
            const step = steps[currentStep];
            const errorDiv = step.querySelector('.error-message');
            let isValid = true;
            let errorMessage = '';

            if (errorDiv) {
                errorDiv.classList.remove('show');
                errorDiv.textContent = '';
            }
            clearValidationClasses(step);

            switch (currentStep) {
                case 0: // Customer type
                    isValid = validateRadioGroup(step, 'customer');
                    errorMessage = 'Please select whether you are a new or existing customer';
                    break;
                case 1: // Existing customer login
                    const email = existingEmail?.value.trim();
                    const password = document.getElementById('existingPassword')?.value.trim();

                    isValid = email && validateEmail(email) && password;

                    if (!isValid) {
                        if (!email || !validateEmail(email)) {
                            existingEmail?.classList.add('is-invalid');
                        }
                        if (!password) {
                            document.getElementById('existingPassword')?.classList.add('is-invalid');
                        }
                    }
                    errorMessage = 'Please enter valid email and password';
                    break;
                case 2: // Existing email
                    isValid = existingEmail && validateEmail(existingEmail.value.trim());
                    if (!isValid && existingEmail) existingEmail.classList.add('is-invalid');
                    errorMessage = 'Please enter a valid email address';
                    break;
                case 3: // Registration choice
                    isValid = validateRadioGroup(step, 'registration_choice');
                    errorMessage = 'Please select whether to register or continue without registration';
                    break;
                case 4: // Account creation - handled separately
                    isValid = true; // Skip validation here, handled in validateAccountCreation()
                    break;
                case 4: // Treatment type
                    const treatmentType = document.getElementById('treatment_type');
                    isValid = treatmentType && treatmentType.value !== '';
                    errorMessage = 'Please select a treatment type';
                    break;
                case 5: // Height & Weight
                    isValid = validateHeightAndWeight();
                    errorMessage = 'Please enter valid height and weight';
                    break;
                case 6:
                    isValid = validateCheckboxGroup(step, 'conditions[]');
                    errorMessage = 'Please select at least one option';
                    break;
                case 7:
                    isValid = validateRadioGroup(step, 'ethnicity');
                    errorMessage = 'Please select your ethnicity';
                    break;
                case 8:
                    isValid = validateRadioGroup(step, 'age');
                    errorMessage = 'Please confirm your age';
                    break;
                case 9:
                    isValid = validateCheckboxGroup(step, 'allergy[]');
                    errorMessage = 'Please select at least one option';
                    break;
                case 10:
                    isValid = validateRadioGroup(step, 'pregnancy');
                    errorMessage = 'Please select an option';
                    break;
                case 11:
                    isValid = validateCheckboxGroup(step, 'medical_history[]');
                    errorMessage = 'Please select at least one option';
                    break;
                case 12:
                    isValid = validateRadioGroup(step, 'thyroid_liver_disease');
                    errorMessage = 'Please select an option';
                    break;
                case 13:
                    isValid = validateRadioGroup(step, 'gallbladder_issues');
                    errorMessage = 'Please select an option';
                    break;
                case 14:
                    isValid = validateCheckboxGroup(step, 'other_health_issues[]');
                    errorMessage = 'Please select at least one option';
                    break;
                case 15:
                    isValid = validateRadioGroup(step, 'insulin_use');
                    errorMessage = 'Please select an option';
                    break;
                case 16:
                    isValid = validateRadioGroup(step, 'other_diabetes_med');
                    errorMessage = 'Please select an option';
                    break;
                case 17:
                    isValid = validateRadioGroup(step, 'medication_use');
                    errorMessage = 'Please select an option';
                    break;
                case 18:
                    isValid = validateRadioGroup(step, 'smoker');
                    errorMessage = 'Please select an option';
                    break;
                case 19:
                    isValid = validateRadioGroup(step, 'recent_medication');
                    errorMessage = 'Please select an option';
                    break;
                case 20:
                    isValid = validateRadioGroup(step, 'dose_understanding');
                    errorMessage = 'Please select an option';
                    break;
                case 21:
                    isValid = validateRadioGroup(step, 'contraceptive_agreement');
                    errorMessage = 'Please select an option';
                    break;
                case 22:
                    isValid = validateRadioGroup(step, 'agreement_confirmation');
                    errorMessage = 'Please select an option';
                    break;
                case 23:
                    isValid = validateRadioGroup(step, 'treatment_agreement');
                    errorMessage = 'Please confirm you understand';
                    break;
                case 24:
                    isValid = validateRadioGroup(step, 'final_consent');
                    errorMessage = 'Please confirm you agree';
                    break;
                case 25:
                    isValid = validateRadioGroup(step, 'assisted_prescribing');
                    errorMessage = 'Please select an option';
                    break;
                case 26:
                    isValid = validateRadioGroup(step, 'privacy_consent');
                    errorMessage = 'Please agree to the privacy policy';
                    break;
                case 27:
                    isValid = validateRadioGroup(step, 'terms_consent');
                    errorMessage = 'Please agree to the terms and conditions';
                    break;
            }

            if (!isValid && errorDiv) {
                errorDiv.textContent = errorMessage;
                errorDiv.classList.add('show');
            }

            return isValid;
        }

        function validateRadioGroup(step, name) {
            const checked = step.querySelector(`input[name="${name}"]:checked`);
            highlightRadioGroup(step, name, !checked);
            return !!checked;
        }

        function validateCheckboxGroup(step, name) {
            const checked = step.querySelectorAll(`input[name="${name}"]:checked`);
            highlightCheckboxGroup(step, name, checked.length === 0);
            return checked.length > 0;
        }

        function validateHeightAndWeight() {
            let heightValid = false,
                weightValid = false;
            const heightCm = document.getElementById('heightCm');
            const heightFeet = document.getElementById('heightFeet');
            const heightInches = document.getElementById('heightInches');
            const weightKg = document.getElementById('weightKg');
            const weightStone = document.getElementById('weightStone');
            const weightPound = document.getElementById('weightPound');

            if (!document.getElementById('heightCmDiv').classList.contains('hidden')) {
                heightValid = heightCm.value.trim() !== '' && parseFloat(heightCm.value) > 0;
                if (!heightValid) heightCm.classList.add('is-invalid');
            } else {
                heightValid = heightFeet.value.trim() !== '' && parseFloat(heightFeet.value) > 0 &&
                    heightInches.value.trim() !== '' && parseFloat(heightInches.value) >= 0;
                if (!heightValid) {
                    heightFeet.classList.add('is-invalid');
                    heightInches.classList.add('is-invalid');
                }
            }

            if (!document.getElementById('weightKgDiv').classList.contains('hidden')) {
                weightValid = weightKg.value.trim() !== '' && parseFloat(weightKg.value) > 0;
                if (!weightValid) weightKg.classList.add('is-invalid');
            } else {
                weightValid = weightStone.value.trim() !== '' && parseFloat(weightStone.value) >= 0 &&
                    weightPound.value.trim() !== '' && parseFloat(weightPound.value) >= 0;
                if (!weightValid) {
                    weightStone.classList.add('is-invalid');
                    weightPound.classList.add('is-invalid');
                }
            }

            return heightValid && weightValid;
        }

        function highlightRadioGroup(step, name, invalid) {
            const boxes = step.querySelectorAll(`input[name="${name}"]`);
            boxes.forEach(input => {
                const box = input.closest('.option-box');
                if (box) box.classList.toggle('invalid', invalid);
            });
        }

        function highlightCheckboxGroup(step, name, invalid) {
            const boxes = step.querySelectorAll(`input[name="${name}"]`);
            boxes.forEach(input => {
                const box = input.closest('.option-box');
                if (box) box.classList.toggle('invalid', invalid);
            });
        }

        function clearValidationClasses(step) {
            step.querySelectorAll('.option-box').forEach(box => box.classList.remove('invalid'));
            step.querySelectorAll('input').forEach(input => input.classList.remove('is-invalid'));
        }

        /* ==========================================================================
           OPTION-BOX & OPTION-CARD INTERACTIONS
        ========================================================================== */
        document.querySelectorAll('.option-box').forEach(box => {
            box.addEventListener('click', function(e) {
                if (e.target.tagName !== 'INPUT') {
                    const input = this.querySelector('input');
                    if (input) {
                        if (input.type === 'radio') {
                            input.checked = true;
                            document.querySelectorAll(`input[name="${input.name}"]`).forEach(r => {
                                r.closest('.option-box').classList.remove('selected');
                            });
                            this.classList.add('selected');
                        } else if (input.type === 'checkbox') {
                            input.checked = !input.checked;
                            this.classList.toggle('selected', input.checked);
                        }
                        input.dispatchEvent(new Event('change'));
                    }
                } else {
                    if (e.target.type === 'radio') {
                        document.querySelectorAll(`input[name="${e.target.name}"]`).forEach(r => {
                            r.closest('.option-box').classList.remove('selected');
                        });
                        this.classList.add('selected');
                    }
                    if (e.target.type === 'checkbox') {
                        this.classList.toggle('selected', e.target.checked);
                    }
                }
            });
        });

        document.querySelectorAll('.option-card').forEach(card => {
            card.addEventListener('click', function() {
                const value = this.getAttribute('data-value');
                document.querySelectorAll('.option-card').forEach(c => c.classList.remove('active'));
                this.classList.add('active');
                const treatmentType = document.getElementById('treatment_type');
                if (treatmentType) treatmentType.value = value;
            });
        });

        /* ==========================================================================
           HEIGHT & WEIGHT SWITCHING
        ========================================================================== */
        const switchHeight = document.getElementById('switchHeight');
        if (switchHeight) {
            switchHeight.addEventListener('click', function() {
                document.getElementById('heightCmDiv').classList.toggle('hidden');
                document.getElementById('heightFtDiv').classList.toggle('hidden');
                this.textContent = document.getElementById('heightCmDiv').classList.contains('hidden') ?
                    'Switch to centimeters' : 'Switch to feet/inches';
            });
        }

        const switchWeight = document.getElementById('switchWeight');
        if (switchWeight) {
            switchWeight.addEventListener('click', function() {
                document.getElementById('weightKgDiv').classList.toggle('hidden');
                document.getElementById('weightStDiv').classList.toggle('hidden');
                this.textContent = document.getElementById('weightKgDiv').classList.contains('hidden') ?
                    'Switch to kilograms' : 'Switch to stones/pounds';
            });
        }

        /* ==========================================================================
           "NONE OF THE ABOVE" CHECKBOX LOGIC
        ========================================================================== */
        function setupNoneCheckbox(noneId, groupName) {
            const noneBox = document.getElementById(noneId);
            if (!noneBox) return;
            const otherBoxes = document.querySelectorAll(`input[name="${groupName}"]:not(#${noneId})`);

            noneBox.addEventListener('change', function() {
                if (this.checked) {
                    otherBoxes.forEach(cb => {
                        cb.checked = false;
                        cb.closest('.option-box').classList.remove('selected');
                    });
                }
            });

            otherBoxes.forEach(cb => {
                cb.addEventListener('change', function() {
                    if (this.checked) {
                        noneBox.checked = false;
                        noneBox.closest('.option-box').classList.remove('selected');
                    }
                });
            });
        }

        setupNoneCheckbox('noneCondition', 'conditions[]');
        setupNoneCheckbox('noneAllergy', 'allergy[]');
        setupNoneCheckbox('noneMedical', 'medical_history[]');
        setupNoneCheckbox('noneOtherHealth', 'other_health_issues[]');

        /* ==========================================================================
           EXISTING CUSTOMER FLOW
        ========================================================================== */
        if (continueExistingBtn) {
            continueExistingBtn.addEventListener('click', function() {
                loginExistingUser();
            });
        }

        if (googleLoginBtn) {
            googleLoginBtn.addEventListener('click', function() {
                alert('Google Sign-In integration coming soon!');
            });
        }

        /* ==========================================================================
           CLEAR ERRORS ON INPUT
        ========================================================================== */
        document.querySelectorAll('input, select, textarea').forEach(el => {
            el.addEventListener('input', function() {
                this.classList.remove('is-invalid');
                const box = this.closest('.option-box');
                if (box) box.classList.remove('invalid');
            });
        });

        /* ==========================================================================
           FORM SUBMISSION
        ========================================================================== */
        function submitForm() {
            const finalFormData = collectFormData();
            // Ensure user_id is included
            if (currentUserId) {
                finalFormData.user_id = currentUserId;
            } else if (formData.user_id) {
                finalFormData.user_id = formData.user_id;
            }

            console.log('Form Data:', finalFormData);

            // Send data to backend
            fetch("<?php echo base_url('api/submit'); ?>", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify(finalFormData)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        console.log('Form successfully submitted! ID:', data.submission_id);

                        // Success case - redirect to product page
                        window.location.href = `<?php echo base_url('recommend/product/'); ?>${data.Customer_data_id}`;
                    } else {
                        // Failed case - show error
                        console.error('Submission failed:', data.message);
                        alert('Submission failed: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Network error:', error);
                    alert('Network error. Please try again.');
                });
        }

        // Proper form data collection function
        function collectFormData() {
            const data = {};

            // Step 1: Customer Type
            const customerType = document.querySelector('input[name="customer"]:checked');
            if (customerType) data.customer = customerType.value;

            // Step 2: Existing Customer Email
            const existingEmail = document.getElementById('existingEmail');
            if (existingEmail && existingEmail.value) {
                data.existingEmail = existingEmail.value.trim();
            }

            // Step 3: Account Data
            if (formData.account) {
                data.account = formData.account;
            }

            // Step 4: Treatment Type
            const treatmentType = document.getElementById('treatment_type');
            if (treatmentType && treatmentType.value) {
                data.treatment_type = treatmentType.value;
            }

            // Step 5: Height & Weight
            collectHeightWeightData(data);

            // Step 6: Medical Conditions
            data.conditions = getCheckedValues('conditions[]');

            // Step 7: Ethnicity
            const ethnicity = document.querySelector('input[name="ethnicity"]:checked');
            if (ethnicity) data.ethnicity = ethnicity.value;

            // Step 8: Age
            const age = document.querySelector('input[name="age"]:checked');
            if (age) data.age = age.value;

            // Step 9: Allergic Reactions
            data.allergy = getCheckedValues('allergy[]');

            // Step 10: Pregnancy
            const pregnancy = document.querySelector('input[name="pregnancy"]:checked');
            if (pregnancy) data.pregnancy = pregnancy.value;

            // Step 11: Medical History
            data.medical_history = getCheckedValues('medical_history[]');

            // Step 12: Thyroid/Liver Disease
            const thyroidLiver = document.querySelector('input[name="thyroid_liver_disease"]:checked');
            if (thyroidLiver) data.thyroid_liver_disease = thyroidLiver.value;

            // Step 13: Gallbladder Issues
            const gallbladder = document.querySelector('input[name="gallbladder_issues"]:checked');
            if (gallbladder) data.gallbladder_issues = gallbladder.value;

            // Step 14: Other Health Issues
            data.other_health_issues = getCheckedValues('other_health_issues[]');

            // Step 15: Insulin Use
            const insulin = document.querySelector('input[name="insulin_use"]:checked');
            if (insulin) data.insulin_use = insulin.value;

            // Step 16: Other Diabetes Medication
            const otherDiabetesMed = document.querySelector('input[name="other_diabetes_med"]:checked');
            if (otherDiabetesMed) data.other_diabetes_med = otherDiabetesMed.value;

            // Step 17: Current Medications
            const medicationUse = document.querySelector('input[name="medication_use"]:checked');
            if (medicationUse) data.medication_use = medicationUse.value;

            // Step 18: Smoking
            const smoker = document.querySelector('input[name="smoker"]:checked');
            if (smoker) data.smoker = smoker.value;

            // Step 19: Recent Medication
            const recentMed = document.querySelector('input[name="recent_medication"]:checked');
            if (recentMed) data.recent_medication = recentMed.value;

            // Step 20: Dose Understanding
            const doseUnderstanding = document.querySelector('input[name="dose_understanding"]:checked');
            if (doseUnderstanding) data.dose_understanding = doseUnderstanding.value;

            // Step 21: Contraceptive Agreement
            const contraceptive = document.querySelector('input[name="contraceptive_agreement"]:checked');
            if (contraceptive) data.contraceptive_agreement = contraceptive.value;

            // Step 22: Information Agreement
            const agreement = document.querySelector('input[name="agreement_confirmation"]:checked');
            if (agreement) data.agreement_confirmation = agreement.value;

            // Step 23: Treatment Information
            const treatmentAgreement = document.querySelector('input[name="treatment_agreement"]:checked');
            if (treatmentAgreement) data.treatment_agreement = treatmentAgreement.value;

            // Step 24: Final Consent
            const finalConsent = document.querySelector('input[name="final_consent"]:checked');
            if (finalConsent) data.final_consent = finalConsent.value;

            // Step 25: Assisted Prescribing
            const assistedPrescribing = document.querySelector('input[name="assisted_prescribing"]:checked');
            if (assistedPrescribing) data.assisted_prescribing = assistedPrescribing.value;

            // Step 26: Privacy
            const privacy = document.querySelector('input[name="privacy_consent"]:checked');
            if (privacy) data.privacy_consent = privacy.value;

            // Step 27: Terms
            const terms = document.querySelector('input[name="terms_consent"]:checked');
            if (terms) data.terms_consent = terms.value;

            return data;
        }

        // Helper function to get checked checkbox values
        function getCheckedValues(name) {
            const checkboxes = document.querySelectorAll(`input[name="${name}"]:checked`);
            return Array.from(checkboxes).map(cb => cb.value);
        }

        // Height and Weight data collection
        function collectHeightWeightData(data) {
            // Height - Check which system is active
            if (!document.getElementById('heightCmDiv').classList.contains('hidden')) {
                const heightCm = document.getElementById('heightCm');
                if (heightCm && heightCm.value) {
                    data.heightCm = parseFloat(heightCm.value);
                }
            } else {
                const heightFeet = document.getElementById('heightFeet');
                const heightInches = document.getElementById('heightInches');
                if (heightFeet && heightFeet.value) {
                    data.heightFeet = parseInt(heightFeet.value);
                }
                if (heightInches && heightInches.value) {
                    data.heightInches = parseFloat(heightInches.value);
                }
            }

            // Weight - Check which system is active
            if (!document.getElementById('weightKgDiv').classList.contains('hidden')) {
                const weightKg = document.getElementById('weightKg');
                if (weightKg && weightKg.value) {
                    data.weightKg = parseFloat(weightKg.value);
                }
            } else {
                const weightStone = document.getElementById('weightStone');
                const weightPound = document.getElementById('weightPound');
                if (weightStone && weightStone.value) {
                    data.weightStone = parseInt(weightStone.value);
                }
                if (weightPound && weightPound.value) {
                    data.weightPound = parseFloat(weightPound.value);
                }
            }
        }

        /* ==========================================================================
           BUTTON EVENT LISTENERS
        ========================================================================== */
        if (nextBtn) nextBtn.addEventListener('click', nextStep);
        if (prevBtn) prevBtn.addEventListener('click', prevStep);

        if (createAccountBtn) {
            createAccountBtn.addEventListener('click', function() {
                if (validateAccountCreation()) {
                    createAccountAndProceed();
                }
            });
        }

        /* ==========================================================================
           INITIALIZE
        ========================================================================== */
        setupAutoAdvanceForRadioButtons();
        showStep(currentStep);
    });
</script>
<style>
    /* Small helper for hidden fields */
    .hidden {
        display: none !important;
    }

    /* Invalid input visual */
    .is-invalid {
        border-color: #dc3545 !important;
    }


    .form-step {
        display: none;
    }

    .form-step.active {
        display: block;
    }

    .option-box {
        border: 2px solid #dee2e6;
        padding: 15px;
        margin-bottom: 10px;
        border-radius: 8px;
        cursor: pointer;
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: all 0.3s;
    }

    .option-box:hover {
        border-color: #0d6efd;
        background-color: #f0f7ff;
    }

    .option-box.selected {
        border-color: #0d6efd;
        background-color: #e7f3ff;
    }

    .option-box.invalid {
        border-color: #dc3545;
        background-color: #ffe6e6;
    }

    .option-card {
        border: 2px solid #dee2e6;
        padding: 20px;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s;
    }

    .option-card:hover {
        border-color: #0d6efd;
        background-color: #f0f7ff;
    }

    .option-card.active {
        border-color: #0d6efd;
        background-color: #e7f3ff;
    }

    .form-navigation {
        display: flex;
        justify-content: space-between;
        margin-top: 30px;
    }

    .btn-nav {
        padding: 12px 30px;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
    }

    #prevBtn {
        background-color: #6c757d;
        color: white;
    }

    #nextBtn {
        background-color: #0d6efd;
        color: white;
    }

    .is-invalid {
        border-color: #dc3545 !important;
    }

    .invalid-feedback {
        display: block;
        color: #dc3545;
        font-size: 0.875rem;
        margin-top: 5px;
    }

    .hidden {
        display: none !important;
    }

    .error-message {
        color: #dc3545;
        font-size: 0.9rem;
        margin-top: 10px;
        padding: 10px;
        background-color: #ffe6e6;
        border-radius: 5px;
        display: none;
    }

    .error-message.show {
        display: block;
        margin-bottom: 2px;
    }

    .unit-text {
        white-space: nowrap;
        color: #6c757d;
    }
</style>

<script>
    // Show banner if logged in
    if (checkUserSession()) {
        const user = JSON.parse(sessionStorage.getItem('user'));
        document.getElementById('loggedInBanner').style.display = 'block';
        document.getElementById('loggedInUserName').textContent = user.email;

        document.getElementById('logoutBtn').addEventListener('click', () => {
            sessionStorage.removeItem('user');
            location.reload();
        });
    }
</script>