<main>
    <!-- Hero Section -->
    <div class="container-fluid pt-5 bg-main pb-4">
        <div class="container mt-5">
            <div class="row align-items-center">
                <!-- Left: Heading -->
                <div class="col-md-6 text-md-start text-center mb-3 mb-md-0">
                    <p class="mainCustom-heading mb-0">
                        About <span>Us</span>
                    </p>
                </div>

                <!-- Right: Paragraph -->
                <div class="col-md-6 text-md-end text-center">
                    <p class="subCustom-text mb-0" style="max-width: 800px; margin-left: auto; margin-right: auto;">
                        We are your dedicated online partner for clinically-approved weight management solutions.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Our Commitment Section -->
    <div class="container-fluid pt-5 bg-sec pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-3">
                Our Commitment: <span>Trusted Care, Delivered</span>
            </p>
            <p class="subCustom-text text-center mx-auto" style="max-width: 900px;">
                Achieving sustainable weight loss is a personal journey that requires expert guidance and accessible care. Our mission is simple: to provide a safe, discreet, and highly professional service that brings the highest standard of pharmaceutical care directly to you, all without the need for traditional GP appointments or waiting lists.
            </p>
        </div>
    </div>

    <!-- Who We Are Section -->
    <div class="container-fluid pt-5 bg-main2 pb-4">
        <div class="container">
            <div class="row g-4 align-items-center">
                <div class="col-md-6">
                    <p class="mainCustom-heading mb-3">
                        Who <span>We Are</span>
                    </p>
                    <p class="subCustom-text mb-2">
                        Ritecare is a licensed and regulated online pharmacy built on a foundation of clinical excellence. We are a team of UK-based medical prescribers and pharmacists committed to upholding the rigorous standards of patient safety and clinical governance.
                    </p>
                    <p class="subCustom-text">
                        We specialise in prescribing breakthrough weight loss treatments utilising modern technology to deliver personalised healthcare while maintaining the human touch that every patient deserves.
                    </p>
                </div>
                <div class="col-md-6">
                    <div class="cardCustom p-0 overflow-hidden">
                        <img
                            src="<?php echo base_url('assets/images/wieght-loss.jpg'); ?>"
                            alt="Who We Are"
                            class="img-fluid w-100"
                            style="height: 350px; object-fit: cover; border-radius: 15px;" />
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Our Pillars of Trust Section -->
    <div class="container-fluid pt-5 bg-main2 pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-3">
                Our <span>Pillars of Trust</span>
            </p>
            <p class="subCustom-text text-center mb-4">
                Our service is built on three core principles designed to ensure safety, reliability, and lasting results.
            </p>

            <div class="row g-4 mt-2">
                <!-- Pillar 1 -->
                <div class="col-md-4">
                    <div class="cardCustom text-center p-4 h-100">
                        <div class="cardCustom-image mb-3">
                            <img src="<?php echo base_url('assets/images/trust1.jpg'); ?>" alt="Clinical Expertise" class="img-fluid rounded" />
                        </div>
                        <h3 class="cardCustom-title mb-3">UK-Licensed Clinical Expertise</h3>
                        <p class="cardCustom-subtext">
                            Every treatment and dosage recommendation is overseen by our team of GPhC-registered pharmacists and licensed prescribers. We conduct thorough online consultations to ensure the treatment is medically appropriate and safe for your specific health profile. Your well-being is our primary focus.
                        </p>
                    </div>
                </div>

                <!-- Pillar 2 -->
                <div class="col-md-4">
                    <div class="cardCustom text-center p-4 h-100">
                        <div class="cardCustom-image mb-3">
                            <img src="<?php echo base_url('assets/images/trust2.png'); ?>" alt="Reliable Service" class="img-fluid rounded" />
                        </div>
                        <h3 class="cardCustom-title mb-3">Reliable Service</h3>
                        <p class="cardCustom-subtext">
                            We prioritize your privacy. All medications are dispensed from our UK pharmacy and delivered directly to your door in unbranded, temperature-controlled packaging. You receive essential medication without compromising your confidentiality.
                        </p>
                    </div>
                </div>

                <!-- Pillar 3 -->
                <div class="col-md-4">
                    <div class="cardCustom text-center p-4 h-100">
                        <div class="cardCustom-image mb-3">
                            <img src="<?php echo base_url('assets/images/trust3.jpeg'); ?>" alt="Support and Monitoring" class="img-fluid rounded" />
                        </div>
                        <h3 class="cardCustom-title mb-3">Continuous Support & Monitoring</h3>
                        <p class="cardCustom-subtext">
                            Weight loss is not a one-time transaction. We provide ongoing support, educational resources, and regular clinical monitoring throughout your journey. Our team is available to answer questions and adjust your plan as needed.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- How It Works Section -->
    <div class="container-fluid pt-5 bg-sec pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-3">How It <span>Works</span></p>
            <p class="subCustom-text text-center mb-2">Simple Steps to Better Health</p>
            <p class="subCustom-text text-center mb-4">
                Our secure, proven process connects you with the medical care you need — fast.
            </p>

            <div class="row g-4 mt-2">
                <!-- Step 1 -->
                <div class="col-md-4">
                    <div class="cardCustom mt-4">
                        <div class="cardCustom-image">
                            <img
                                src="<?php echo base_url('assets/images/w1.png'); ?>"
                                alt="Online Consultation"
                                class="img-fluid rounded w-100" />
                        </div>
                        <h3 class="cardCustom-title mt-3 mb-2">1. Start an online consultation</h3>
                        <p class="cardCustom-subtext mb-0">
                            Complete a private medical questionnaire online. No waiting lists or face-to-face appointments required.
                        </p>
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="col-md-4">
                    <div class="cardCustom mt-4">
                        <div class="cardCustom-image">
                            <img
                                src="<?php echo base_url('assets/images/w2.png'); ?>"
                                alt="Clinician Approval"
                                class="img-fluid rounded w-100" />
                        </div>
                        <h3 class="cardCustom-title mt-3 mb-2">2. Get clinician approval</h3>
                        <p class="cardCustom-subtext mb-0">
                            A UK-licensed prescriber reviews your information and issues a prescription for the most suitable treatment, if approved.
                        </p>
                    </div>
                </div>

                <!-- Step 3 -->
                <div class="col-md-4">
                    <div class="cardCustom mt-4">
                        <div class="cardCustom-image">
                            <img
                                src="<?php echo base_url('assets/images/w3.png'); ?>"
                                alt="Discreet Delivery"
                                class="img-fluid rounded w-100" />
                        </div>
                        <h3 class="cardCustom-title mt-3 mb-2">3. Receive discreet delivery</h3>
                        <p class="cardCustom-subtext mb-0">
                            Your treatment is shipped quickly and directly to your home in a temperature-controlled, plain package for maximum discretion.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Convenient Access Section -->
    <div class="container-fluid pt-5 bg-main pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-3">
                Convenient Access to <span>Essential Treatments</span>
            </p>
            <p class="subCustom-text text-center mb-5">
                No doctor's appointment or pharmacy visit required.
            </p>

            <div class="row g-4 mt-2 justify-content-center">
                <div class="col-md-5">
                    <div class="cardCustom p-4 h-100 text-center">
                        <div class="mb-3">
                            <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="#0d6efd" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                <polyline points="9 22 9 12 15 12 15 22"></polyline>
                            </svg>
                        </div>
                        <h4 class="fw-bold mb-3">Discreet Home Delivery</h4>
                        <p class="cardCustom-subtext mb-0">
                            Choose quick, discreet delivery straight to your home in unbranded, temperature-controlled packaging for complete privacy and convenience.
                        </p>
                    </div>
                </div>

                <div class="col-md-5">
                    <div class="cardCustom p-4 h-100 text-center">
                        <div class="mb-3">
                            <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="#0d6efd" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="2" y="7" width="20" height="14" rx="2" ry="2"></rect>
                                <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"></path>
                            </svg>
                        </div>
                        <h4 class="fw-bold mb-3">Post Office Collection</h4>
                        <p class="cardCustom-subtext mb-0">
                            Prefer to collect? Your order can be delivered to your nearest Post Office for flexible, secure pickup at your convenience.
                        </p>
                    </div>
                </div>
            </div>

            <div class="text-center mt-5">
                <a href="<?php echo base_url('home/eligibility'); ?>" class="btn btnCustom-primary btn-lg px-5">
                    Find a Treatment
                </a>
            </div>
        </div>
    </div>

    <!-- Styles -->
    <style>
        /* Typography */
        .mainCustom-heading {
            font-weight: 700;
            font-size: 2rem;
            color: #0d2a5a;
        }

        .mainCustom-heading span {
            color: #0d6efd;
        }

        .subCustom-text {
            font-size: 1rem;
            line-height: 1.6;
            color: #444;
        }

        /* Card Styling */
        .cardCustom {
            border-radius: 15px;
            background: #fff;
            transition: all 0.3s ease;
        }

        .cardCustom:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
        }

        .cardCustom-image {
            width: 100%;
            height: 220px;
            overflow: hidden;
            border-radius: 15px;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #f8f9fa;
        }

        .cardCustom-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }

        .cardCustom:hover .cardCustom-image img {
            transform: scale(1.05);
        }

        .cardCustom-title {
            font-size: 1.25rem;
            font-weight: 600;
        }

        .cardCustom-subtext {
            font-size: 0.95rem;
            color: #555;
        }

        /* Team Member Styling */
        .team-image {
            width: 150px;
            height: 150px;
            margin: 0 auto;
            overflow: hidden;
            border-radius: 50%;
            border: 4px solid #0d6efd;
        }

        .team-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .cardCustom-image {
                height: 180px;
            }

            .team-image {
                width: 120px;
                height: 120px;
            }

            .row.align-items-center {
                flex-direction: column;
                text-align: center;
            }
        }

        @media (max-width: 576px) {
            .cardCustom-image {
                height: 160px;
            }

            .team-image {
                width: 100px;
                height: 100px;
            }
        }
    </style>
</main>