<main class="main-content" id="mainContent">

    <!-- Hero Section -->
    <div class="container-fluid pt-5 bg-main pb-4">
        <div class="container mt-5 text-center">
            <p class="mainCustom-heading mb-3">
                Your Secure <span>Ritecare Patient Account</span>
            </p>
            <p class="subCustom-text mx-auto" style="max-width:850px;">
                Manage Your Health Journey in One Place
            </p>
        </div>
    </div>

    <?php
    $user = $this->session->userdata();
    $isLoggedIn = !empty($user['user_id']);
    ?>


    <div class="container py-5">

        <?php if ($isLoggedIn): ?>

            <!-- ✅ Logged In View -->
            <div class="content-card animate-fade-in">
                <div class="content-card-header mb-4">
                    <h4 class="content-card-title fw-semibold text-primary">
                        <i class="bi bi-person-circle me-2"></i> My Account
                    </h4>
                </div>

                <?php if ($this->session->flashdata('success')): ?>
                    <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
                <?php elseif ($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
                <?php endif; ?>

                <div class="row g-4">
                    <div class="col-md-6">
                        <div class="bg-white p-4 rounded-4 shadow-sm h-100">
                            <h5 class="mb-4 text-primary fw-semibold">
                                <i class="bi bi-person-lines-fill me-2"></i>Account Information
                            </h5>
                            <form>
                                <div class="mb-3">
                                    <label class="form-label fw-semibold">Full Name</label>
                                    <input type="text" class="form-control" value="<?= $user['name'] ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label fw-semibold">Email</label>
                                    <input type="email" class="form-control" value="<?= $user['email'] ?>" readonly>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label fw-semibold">Phone</label>
                                    <input type="text" class="form-control" value="<?= $user['phone'] ?>">
                                </div>
                                <a href="<?= base_url('home/logout') ?>" class="btn btn-danger w-100 mt-3 py-2">
                                    <i class="bi bi-box-arrow-right me-1"></i> Logout
                                </a>
                            </form>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="bg-white p-4 rounded-4 shadow-sm h-100">
                            <h5 class="mb-4 text-success fw-semibold">
                                <i class="bi bi-bag-check-fill me-2"></i>Your Orders
                            </h5>
                            <div class="table-responsive">
                                <table class="table table-hover align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Order #</th>
                                            <th>Date</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (!empty($orders)): ?>
                                            <?php $counter = 1; ?>
                                            <?php foreach ($orders as $o): ?>
                                                <tr>
                                                    <td><?= $counter++ ?></td>
                                                    <td><?= htmlspecialchars($o['date']) ?></td>
                                                    <td>
                                                        <span class="badge bg-<?= $o['status'] === 'Delivered' ? 'success' : ($o['status'] === 'Shipped' ? 'warning text-dark' : 'info text-dark') ?>">
                                                            <?= htmlspecialchars($o['status']) ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="3" class="text-center text-muted py-4">
                                                    <i class="bi bi-bag-x fs-4 d-block mb-2"></i>No orders found.
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php else: ?>

            <!-- 🚀 Not Logged In View -->
            <div class="content-card text-center animate-fade-in">
                <div class="content-card-header mb-3">
                    <h4 class="content-card-title fw-bold text-primary">
                        <i class="bi bi-shield-lock-fill me-2"></i>Welcome to Ritecare
                    </h4>
                </div>

                <div id="responseMsg" class="mb-3"></div>

                <!-- Step 1: Action Buttons -->
                <div id="actionButtons" class="d-flex justify-content-center gap-3 flex-wrap">
                    <button id="showLoginBtn" class="btn btn-primary px-4 py-2 fw-semibold shadow-sm">Login</button>
                    <button id="showSignupBtn" class="btn btn-outline-secondary px-4 py-2 fw-semibold">Create Account</button>
                </div>

                <!-- Step 2: Forms (Hidden Initially) -->
                <div class="form-toggle-container mx-auto mt-4" style="max-width:500px; display:none;">
                    <!-- Login Form -->
                    <form id="loginForm" class="auth-form">
                        <h5 class="text-center mb-4 fw-semibold text-primary">Login to Your Account</h5>
                        <div class="mb-3 text-start">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="mb-3 text-start">
                            <label>Password</label>
                            <input type="password" name="password" class="form-control" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100 py-2">Login</button>
                        <p class="mt-3 small">
                            Don’t have an account?
                            <a href="#" id="switchToSignup" class="fw-semibold text-decoration-none">Create one</a>
                        </p>
                    </form>

                    <!-- Signup Form -->
                    <form id="signupForm" class="auth-form" style="display:none;">
                        <h5 class="text-center mb-4 fw-semibold text-success">Create Your Account</h5>
                        <div class="mb-3 text-start">
                            <label>Full Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="mb-3 text-start">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="mb-3 text-start">
                            <label>Phone</label>
                            <input type="tel" name="phone" class="form-control" required>
                        </div>
                        <div class="mb-3 text-start">
                            <label>Password</label>
                            <input type="password" name="password" class="form-control" required>
                        </div>
                        <button type="submit" class="btn btn-success w-100 py-2">Sign Up</button>
                        <p class="mt-3 small">
                            Already have an account?
                            <a href="#" id="switchToLogin" class="fw-semibold text-decoration-none">Login instead</a>
                        </p>
                    </form>
                </div>
            </div>

        <?php endif; ?>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const actionButtons = document.getElementById('actionButtons');
                const formContainer = document.querySelector('.form-toggle-container');
                const loginForm = document.getElementById('loginForm');
                const signupForm = document.getElementById('signupForm');
                const responseMsg = document.getElementById('responseMsg');

                // Buttons
                const showLoginBtn = document.getElementById('showLoginBtn');
                const showSignupBtn = document.getElementById('showSignupBtn');
                const switchToSignup = document.getElementById('switchToSignup');
                const switchToLogin = document.getElementById('switchToLogin');

                // Show Login
                showLoginBtn?.addEventListener('click', () => {
                    actionButtons.style.display = 'none';
                    formContainer.style.display = 'block';
                    signupForm.style.display = 'none';
                    loginForm.style.display = 'block';
                });

                // Show Signup
                showSignupBtn?.addEventListener('click', () => {
                    actionButtons.style.display = 'none';
                    formContainer.style.display = 'block';
                    loginForm.style.display = 'none';
                    signupForm.style.display = 'block';
                });

                // Switch Between
                switchToSignup?.addEventListener('click', e => {
                    e.preventDefault();
                    loginForm.style.display = 'none';
                    signupForm.style.display = 'block';
                    responseMsg.innerHTML = '';
                });

                switchToLogin?.addEventListener('click', e => {
                    e.preventDefault();
                    signupForm.style.display = 'none';
                    loginForm.style.display = 'block';
                    responseMsg.innerHTML = '';
                });

                // Alerts
                function showAlert(message, type = 'info') {
                    responseMsg.innerHTML = `
                    <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                        ${message}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>`;
                    setTimeout(() => {
                        const alertEl = document.querySelector('.alert');
                        if (alertEl) alertEl.classList.remove('show');
                    }, 4000);
                }

                // Login
                loginForm?.addEventListener('submit', async e => {
                    e.preventDefault();
                    const data = Object.fromEntries(new FormData(loginForm));
                    const res = await fetch('<?= base_url("home/login") ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(data)
                    });
                    const result = await res.json();
                    showAlert(result.message, result.success ? 'success' : 'danger');
                    if (result.success) setTimeout(() => location.reload(), 1500);
                });

                // Signup
                signupForm?.addEventListener('submit', async e => {
                    e.preventDefault();
                    const data = Object.fromEntries(new FormData(signupForm));
                    const res = await fetch('<?= base_url("home/createAccount") ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(data)
                    });
                    const result = await res.json();
                    showAlert(result.message, result.success ? 'success' : 'danger');
                    if (result.success) setTimeout(() => location.reload(), 1500);
                });
            });
        </script>

</main>

<style>
    .content-card {
        background: #fff;
        border-radius: 18px;
        box-shadow: 0 4px 18px rgba(0, 0, 0, 0.07);
        padding: 2.8rem;
        margin-top: 2rem;
        transition: all 0.3s ease;
    }

    .content-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.09);
    }

    .auth-form {
        background: #f8fafc;
        border-radius: 14px;
        padding: 2rem;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        animation: fadeIn 0.4s ease;
    }

    .auth-form input:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.2);
    }

    .alert {
        border-radius: 8px;
        animation: fadeIn 0.3s ease;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(-6px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .animate-fade-in {
        animation: fadeIn 0.6s ease forwards;
    }
</style>