<main>
    <!-- Hero Section -->
    <div class="container-fluid pt-5 bg-main pb-4">
        <div class="container mt-5">
            <div class="row align-items-center">
                <!-- Left: Heading -->
                <div class="col-md-6 text-md-start text-center mb-3 mb-md-0">
                    <p class="mainCustom-heading mb-0">
                        BMI <span>Calculator</span>
                    </p>
                </div>

                <!-- Right: Paragraph -->
                <div class="col-md-6 text-md-end text-center">
                    <p class="subCustom-text mb-0" style="max-width: 800px; margin-left: auto; margin-right: auto;">
                        Calculate your Body Mass Index and understand your health category.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- BMI Calculator Section -->
    <div class="container-fluid pt-5 bg-sec pb-4">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="cardCustom p-4 p-md-5">
                        <div class="row g-5 align-items-start">
                            <!-- Calculator Form -->
                            <div class="col-lg-6">
                                <div class="calculator-form">
                                    <div class="d-flex align-items-center mb-4">
                                        <div class="bg-primary rounded-circle p-3 me-3">
                                            <span class="text-white fs-4">📐</span>
                                        </div>
                                        <div>
                                            <h3 class="cardCustom-title mb-1">Calculate Your BMI</h3>
                                            <p class="text-muted small mb-0">Enter your details and click calculate</p>
                                        </div>
                                    </div>

                                    <!-- Gender Selection -->
                                    <div class="mb-4">
                                        <label class="form-label fw-semibold mb-3">Gender</label>
                                        <div class="btn-group w-100" role="group">
                                            <input type="radio" class="btn-check" name="gender" id="male" checked>
                                            <label class="btn btn-outline-primary" for="male">
                                                <span class="d-block">👨</span>
                                                Male
                                            </label>
                                            <input type="radio" class="btn-check" name="gender" id="female">
                                            <label class="btn btn-outline-primary" for="female">
                                                <span class="d-block">👩</span>
                                                Female
                                            </label>
                                        </div>
                                    </div>

                                    <!-- Age Input -->
                                    <div class="mb-4">
                                        <label for="age" class="form-label fw-semibold d-flex align-items-center">
                                            <span class="me-2">🎂</span> Age
                                        </label>
                                        <div class="input-group">
                                            <input type="number" class="form-control form-control-lg" id="age"
                                                placeholder="25" min="18" max="100" value="25">
                                            <span class="input-group-text">years</span>
                                        </div>
                                    </div>

                                    <!-- Measurement System Toggle -->
                                    <div class="mb-4">
                                        <label class="form-label fw-semibold mb-3">Units</label>
                                        <div class="btn-group w-100" role="group">
                                            <input type="radio" class="btn-check" name="measurementSystem" id="metricSystem" checked>
                                            <label class="btn btn-outline-primary" for="metricSystem">
                                                Metric (kg/cm)
                                            </label>
                                            <input type="radio" class="btn-check" name="measurementSystem" id="imperialSystem">
                                            <label class="btn btn-outline-primary" for="imperialSystem">
                                                Imperial (lbs/ft)
                                            </label>
                                        </div>
                                    </div>

                                    <!-- Metric Inputs -->
                                    <div id="metricInputs">
                                        <div class="mb-4">
                                            <label for="heightCm" class="form-label fw-semibold d-flex align-items-center">
                                                <span class="me-2">📏</span> Height
                                            </label>
                                            <div class="input-group">
                                                <input type="number" class="form-control form-control-lg" id="heightCm"
                                                    placeholder="170" min="100" max="250">
                                                <span class="input-group-text">cm</span>
                                            </div>
                                        </div>

                                        <div class="mb-4">
                                            <label for="weightKg" class="form-label fw-semibold d-flex align-items-center">
                                                <span class="me-2">⚖️</span> Weight
                                            </label>
                                            <div class="input-group">
                                                <input type="number" class="form-control form-control-lg" id="weightKg"
                                                    placeholder="70" min="30" max="300">
                                                <span class="input-group-text">kg</span>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Imperial Inputs -->
                                    <div id="imperialInputs" class="d-none">
                                        <div class="mb-4">
                                            <label class="form-label fw-semibold d-flex align-items-center">
                                                <span class="me-2">📏</span> Height
                                            </label>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <div class="input-group">
                                                        <input type="number" class="form-control" id="heightFeet"
                                                            placeholder="5" min="3" max="8">
                                                        <span class="input-group-text">ft</span>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="input-group">
                                                        <input type="number" class="form-control" id="heightInches"
                                                            placeholder="7" min="0" max="11">
                                                        <span class="input-group-text">in</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mb-4">
                                            <label class="form-label fw-semibold d-flex align-items-center">
                                                <span class="me-2">⚖️</span> Weight
                                            </label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="weightLbs"
                                                    placeholder="154" min="66" max="660">
                                                <span class="input-group-text">lbs</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button id="calculateBtn" class="btnCustom-primary w-100 py-3 mt-2">
                                        <span class="me-2">🧮</span> Calculate BMI
                                    </button>
                                </div>
                            </div>

                            <!-- Results Display -->
                            <div class="col-lg-6">
                                <div class="results-card cardCustom p-4 h-100">
                                    <div class="results-header text-center mb-4">
                                        <div class="bg-light rounded-circle p-3 mx-auto mb-3" style="width: 80px; height: 80px;">
                                            <span class="text-primary fs-2">📊</span>
                                        </div>
                                        <h4 class="cardCustom-title mb-2">Your BMI Result</h4>
                                        <p class="text-muted small">Click calculate to see your results</p>
                                    </div>

                                    <div class="results-content">
                                        <div id="bmiPlaceholder" class="text-center">
                                            <div class="placeholder-content py-5">
                                                <div class="bg-light rounded-circle p-4 mx-auto mb-3" style="width: 100px; height: 100px;">
                                                    <span class="text-muted fs-1">⚖️</span>
                                                </div>
                                                <h5 class="cardCustom-title text-muted mb-2">Ready to Calculate</h5>
                                                <p class="text-muted small px-3">
                                                    Enter your height and weight, then click the calculate button to see your BMI result and personalized health assessment.
                                                </p>
                                            </div>
                                        </div>

                                        <div id="bmiResult" class="text-center d-none">
                                            <div class="bmi-score mb-4">
                                                <div id="bmiValue" class="display-3 fw-bold text-primary mb-3">--</div>
                                                <div id="bmiCategory" class="h5 fw-semibold mb-3 px-4 py-2 rounded-pill d-inline-block">
                                                    --
                                                </div>
                                            </div>

                                            <!-- BMI Scale -->
                                            <div class="bmi-scale mb-4">
                                                <div class="scale-labels d-flex justify-content-between mb-2">
                                                    <small class="text-muted">Underweight</small>
                                                    <small class="text-muted">Normal</small>
                                                    <small class="text-muted">Overweight</small>
                                                    <small class="text-muted">Obese</small>
                                                </div>
                                                <div class="scale-bar position-relative mb-3">
                                                    <div class="scale-background rounded" style="height: 12px; background: linear-gradient(90deg, #0dcaf0 0%, #198754 33%, #ffc107 66%, #dc3545 100%);"></div>
                                                    <div id="bmiIndicator" class="bmi-indicator position-absolute" style="left: 50%; transform: translateX(-50%);">
                                                        <div class="indicator-line bg-dark" style="height: 20px; width: 2px;"></div>
                                                        <div class="indicator-dot bg-dark rounded-circle" style="width: 12px; height: 12px;"></div>
                                                    </div>
                                                </div>
                                                <div class="scale-numbers d-flex justify-content-between">
                                                    <small class="text-muted">&lt;18.5</small>
                                                    <small class="text-muted">18.5-25</small>
                                                    <small class="text-muted">25-30</small>
                                                    <small class="text-muted">30+</small>
                                                </div>
                                            </div>

                                            <!-- Health Assessment -->
                                            <div id="bmiDescription" class="health-assessment">
                                                <p class="mb-3" style="line-height: 1.5;">
                                                    Enter your details and click calculate to see your personalized health assessment.
                                                </p>
                                                <div class="health-tips bg-light rounded p-3">
                                                    <h6 class="fw-semibold mb-2">💡 Health Tips</h6>
                                                    <ul class="small mb-0 ps-3">
                                                        <li>Fill in your details first</li>
                                                        <li>Click calculate button</li>
                                                        <li>Get personalized advice</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="results-footer text-center mt-4 pt-3 border-top">
                                        <small class="text-muted">
                                            💡 <strong>Note:</strong> BMI is a screening tool. Consult healthcare professionals for medical advice.
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- BMI Categories Section -->
    <div class="container-fluid pt-5 bg-main2 pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-3">Understanding <span>BMI Categories</span></p>
            <p class="subCustom-text text-center mb-4">
                Learn what your BMI score means for your health and wellbeing
            </p>

            <div class="row g-4 mt-2">
                <!-- Underweight -->
                <div class="col-md-6 col-lg-3">
                    <div class="cardCustom p-4 text-center h-100 border-start border-5 border-info">
                        <div class="category-icon mb-3">
                            <div class="bg-info rounded-circle p-3 mx-auto" style="width: 70px; height: 70px;">
                                <span class="text-white fs-4">⬇️</span>
                            </div>
                        </div>
                        <h5 class="cardCustom-title mb-2">Underweight</h5>
                        <div class="bmi-range text-info fw-bold mb-3">&lt; 18.5</div>
                        <p class="cardCustom-subtext small mb-0">
                            May indicate inadequate nutrition. Consider consulting a healthcare provider for personalized advice.
                        </p>
                    </div>
                </div>

                <!-- Normal Weight -->
                <div class="col-md-6 col-lg-3">
                    <div class="cardCustom p-4 text-center h-100 border-start border-5 border-success">
                        <div class="category-icon mb-3">
                            <div class="bg-success rounded-circle p-3 mx-auto" style="width: 70px; height: 70px;">
                                <span class="text-white fs-4">✅</span>
                            </div>
                        </div>
                        <h5 class="cardCustom-title mb-2">Normal Weight</h5>
                        <div class="bmi-range text-success fw-bold mb-3">18.5 - 24.9</div>
                        <p class="cardCustom-subtext small mb-0">
                            Healthy weight range. Maintain through balanced diet and regular physical activity.
                        </p>
                    </div>
                </div>

                <!-- Overweight -->
                <div class="col-md-6 col-lg-3">
                    <div class="cardCustom p-4 text-center h-100 border-start border-5 border-warning">
                        <div class="category-icon mb-3">
                            <div class="bg-warning rounded-circle p-3 mx-auto" style="width: 70px; height: 70px;">
                                <span class="text-white fs-4">⚠️</span>
                            </div>
                        </div>
                        <h5 class="cardCustom-title mb-2">Overweight</h5>
                        <div class="bmi-range text-warning fw-bold mb-3">25 - 29.9</div>
                        <p class="cardCustom-subtext small mb-0">
                            Increased health risks. Consider lifestyle changes and consult healthcare providers.
                        </p>
                    </div>
                </div>

                <!-- Obese -->
                <div class="col-md-6 col-lg-3">
                    <div class="cardCustom p-4 text-center h-100 border-start border-5 border-danger">
                        <div class="category-icon mb-3">
                            <div class="bg-danger rounded-circle p-3 mx-auto" style="width: 70px; height: 70px;">
                                <span class="text-white fs-4">🔴</span>
                            </div>
                        </div>
                        <h5 class="cardCustom-title mb-2">Obese</h5>
                        <div class="bmi-range text-danger fw-bold mb-3">30 and Above</div>
                        <p class="cardCustom-subtext small mb-0">
                            High health risk. Recommended to consult healthcare provider for weight management.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
    /* Enhanced Calculator Styles */
    .calculator-form {
        padding: 0.5rem;
    }

    .btn-group .btn {
        padding: 0.75rem 1rem;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 0.25rem;
        font-size: 0.9rem;
    }

    .btn-group .btn span:first-child {
        font-size: 1.2rem;
    }

    .form-control-lg {
        padding: 0.75rem 1rem;
        font-size: 1.1rem;
    }

    .input-group-text {
        background-color: #f8f9fa;
        border-color: #dee2e6;
        color: #495057;
        font-weight: 500;
    }

    /* Results Card Styles */
    .results-card {
        background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
        border: 2px solid #e9ecef;
    }

    .bmi-score {
        padding: 1rem 0;
    }

    /* BMI Scale Styles */
    .bmi-scale {
        background: white;
        padding: 1rem;
        border-radius: 10px;
        border: 1px solid #e9ecef;
    }

    .scale-bar {
        height: 12px;
    }

    .scale-background {
        height: 100%;
    }

    .bmi-indicator {
        top: -8px;
    }

    .indicator-line {
        margin: 0 auto 2px auto;
    }

    .indicator-dot {
        margin: 0 auto;
    }

    /* Category Colors */
    .category-underweight {
        color: #0dcaf0 !important;
        border-color: #0dcaf0 !important;
        background-color: rgba(13, 202, 240, 0.1) !important;
    }

    .category-normal {
        color: #198754 !important;
        border-color: #198754 !important;
        background-color: rgba(25, 135, 84, 0.1) !important;
    }

    .category-overweight {
        color: #ffc107 !important;
        border-color: #ffc107 !important;
        background-color: rgba(255, 193, 7, 0.1) !important;
    }

    .category-obese {
        color: #dc3545 !important;
        border-color: #dc3545 !important;
        background-color: rgba(220, 53, 69, 0.1) !important;
    }

    /* Health Tips */
    .health-tips {
        border-left: 4px solid #0d6efd;
    }

    .health-tips ul {
        margin-bottom: 0;
    }

    .health-tips li {
        margin-bottom: 0.25rem;
    }

    /* Placeholder */
    .placeholder-content {
        opacity: 0.7;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .display-3 {
            font-size: 2.5rem;
        }

        .btn-group .btn {
            padding: 0.5rem 0.75rem;
            font-size: 0.8rem;
        }

        .results-card {
            margin-top: 2rem;
        }

        .scale-labels,
        .scale-numbers {
            font-size: 0.75rem;
        }
    }

    @media (max-width: 576px) {
        .display-3 {
            font-size: 2rem;
        }

        .btn-group {
            flex-direction: column;
        }

        .btn-group .btn {
            border-radius: 0.375rem !important;
            margin-bottom: 0.5rem;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Elements
        const metricSystem = document.getElementById('metricSystem');
        const imperialSystem = document.getElementById('imperialSystem');
        const metricInputs = document.getElementById('metricInputs');
        const imperialInputs = document.getElementById('imperialInputs');
        const calculateBtn = document.getElementById('calculateBtn');
        const bmiValue = document.getElementById('bmiValue');
        const bmiCategory = document.getElementById('bmiCategory');
        const bmiDescription = document.getElementById('bmiDescription');
        const bmiIndicator = document.getElementById('bmiIndicator');
        const bmiResult = document.getElementById('bmiResult');
        const bmiPlaceholder = document.getElementById('bmiPlaceholder');

        // Input elements
        const heightCm = document.getElementById('heightCm');
        const weightKg = document.getElementById('weightKg');
        const heightFeet = document.getElementById('heightFeet');
        const heightInches = document.getElementById('heightInches');
        const weightLbs = document.getElementById('weightLbs');
        const age = document.getElementById('age');

        // Measurement system toggle
        metricSystem.addEventListener('change', toggleMeasurementSystem);
        imperialSystem.addEventListener('change', toggleMeasurementSystem);

        function toggleMeasurementSystem() {
            if (metricSystem.checked) {
                metricInputs.classList.remove('d-none');
                imperialInputs.classList.add('d-none');
            } else {
                metricInputs.classList.add('d-none');
                imperialInputs.classList.remove('d-none');
            }
        }

        // Calculate BMI only when button is clicked
        calculateBtn.addEventListener('click', function() {
            // Validate inputs first
            if (!validateInputs()) {
                alert('Please fill in all required fields with valid values.');
                return;
            }

            calculateBMI();
        });

        function validateInputs() {
            if (metricSystem.checked) {
                if (!heightCm.value || !weightKg.value) {
                    return false;
                }
                const height = parseFloat(heightCm.value);
                const weight = parseFloat(weightKg.value);
                return height >= 100 && height <= 250 && weight >= 30 && weight <= 300;
            } else {
                if (!heightFeet.value || !weightLbs.value) {
                    return false;
                }
                const feet = parseFloat(heightFeet.value);
                const inches = parseFloat(heightInches.value) || 0;
                const weight = parseFloat(weightLbs.value);
                return feet >= 3 && feet <= 8 && inches >= 0 && inches <= 11 && weight >= 66 && weight <= 660;
            }
        }

        // Calculate BMI function
        function calculateBMI() {
            let height, weight, bmi;

            if (metricSystem.checked) {
                // Metric calculation
                const heightCmValue = parseFloat(heightCm.value);
                const weightKgValue = parseFloat(weightKg.value);

                height = heightCmValue / 100; // Convert cm to meters
                weight = weightKgValue;
            } else {
                // Imperial calculation
                const heightFeetValue = parseFloat(heightFeet.value);
                const heightInchesValue = parseFloat(heightInches.value) || 0;
                const weightLbsValue = parseFloat(weightLbs.value);

                // Convert to metric for calculation
                const totalInches = (heightFeetValue * 12) + heightInchesValue;
                height = totalInches * 0.0254; // Convert inches to meters
                weight = weightLbsValue * 0.453592; // Convert pounds to kg
            }

            // Calculate BMI
            bmi = weight / (height * height);
            displayResults(bmi);
        }

        function displayResults(bmi) {
            const roundedBMI = bmi.toFixed(1);

            // Determine category and styling
            let category, description, colorClass, indicatorPosition, healthTips;

            if (bmi < 18.5) {
                category = 'Underweight';
                description = 'Your weight is below the healthy range for your height. Consider consulting a healthcare provider for personalized nutrition advice to reach a healthy weight.';
                colorClass = 'category-underweight';
                indicatorPosition = Math.max(5, (bmi / 18.5) * 33);
                healthTips = [
                    'Focus on nutrient-dense foods',
                    'Consult a healthcare provider',
                    'Consider weight gain strategies'
                ];
            } else if (bmi >= 18.5 && bmi <= 24.9) {
                category = 'Normal Weight';
                description = 'Your weight is within the healthy range for your height. Maintain your current weight through balanced nutrition and regular physical activity.';
                colorClass = 'category-normal';
                indicatorPosition = 33 + ((bmi - 18.5) / (24.9 - 18.5)) * 33;
                healthTips = [
                    'Continue with regular exercise',
                    'Maintain balanced diet',
                    'Get regular health check-ups'
                ];
            } else if (bmi >= 25 && bmi <= 29.9) {
                category = 'Overweight';
                description = 'Your weight is above the healthy range for your height. Consider adopting healthier eating habits and increasing physical activity. Consult a healthcare provider for personalized guidance.';
                colorClass = 'category-overweight';
                indicatorPosition = 66 + ((bmi - 25) / (29.9 - 25)) * 17;
                healthTips = [
                    'Increase physical activity',
                    'Focus on portion control',
                    'Consult healthcare provider'
                ];
            } else {
                category = 'Obese';
                description = 'Your weight is significantly above the healthy range for your height. It\'s important to consult healthcare professionals for comprehensive weight management advice and support.';
                colorClass = 'category-obese';
                indicatorPosition = Math.min(95, 83 + ((bmi - 30) / 20) * 12);
                healthTips = [
                    'Consult healthcare professional',
                    'Consider weight management program',
                    'Focus on sustainable changes'
                ];
            }

            // Update display
            bmiValue.textContent = roundedBMI;
            bmiCategory.textContent = category;
            bmiCategory.className = `h5 fw-semibold mb-3 px-4 py-2 rounded-pill d-inline-block ${colorClass}`;

            // Update description and health tips
            bmiDescription.querySelector('p').textContent = description;
            const tipsList = bmiDescription.querySelector('ul');
            tipsList.innerHTML = healthTips.map(tip => `<li>${tip}</li>`).join('');

            // Update indicator position
            bmiIndicator.style.left = `${indicatorPosition}%`;

            // Show results and hide placeholder
            bmiPlaceholder.classList.add('d-none');
            bmiResult.classList.remove('d-none');

            // Add smooth animation
            bmiResult.style.opacity = '0';
            bmiResult.style.transform = 'translateY(20px)';

            setTimeout(() => {
                bmiResult.style.transition = 'all 0.5s ease';
                bmiResult.style.opacity = '1';
                bmiResult.style.transform = 'translateY(0)';
            }, 100);
        }

        // Input validation styling
        document.querySelectorAll('input[type="number"]').forEach(input => {
            input.addEventListener('input', function() {
                const min = parseFloat(this.getAttribute('min'));
                const max = parseFloat(this.getAttribute('max'));
                const value = parseFloat(this.value);

                if (this.value && (value < min || value > max)) {
                    this.classList.add('is-invalid');
                } else if (this.value) {
                    this.classList.remove('is-invalid');
                    this.classList.add('is-valid');
                } else {
                    this.classList.remove('is-valid', 'is-invalid');
                }
            });
        });
    });
</script>