<main>
    <!-- Hero Section -->
    <div class="container-fluid pt-5 bg-main pb-4">
        <div class="container mt-5">
            <div class="row align-items-center">
                <!-- Left: Heading -->
                <div class="col-md-6 text-md-start text-center mb-3 mb-md-0">
                    <p class="mainCustom-heading mb-0">
                        Contact <span>Us</span>
                    </p>
                </div>

                <!-- Right: Paragraph -->
                <div class="col-md-6 text-md-end text-center">
                    <p class="subCustom-text mb-0" style="max-width: 800px; margin-left: auto; margin-right: auto;">
                        Get in touch with our team for personalized support and medical guidance.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Contact Support Section -->
    <div class="container-fluid pt-5 bg-sec pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-3">
                We're Here to <span>Support You</span>
            </p>
            <p class="subCustom-text text-center mx-auto" style="max-width: 900px;">
                Our dedicated team of healthcare professionals is ready to assist you with treatment inquiries,
                prescription support, delivery questions, and medical advice. Reach out through any channel that's convenient for you.
            </p>
        </div>
    </div>

    <!-- Contact Methods Section -->
    <div class="container-fluid pt-5 bg-main2 pb-4">
        <div class="container">
            <div class="row g-4">
                <!-- Contact Info Cards -->
                <div class="col-lg-4">
                    <div class="d-flex flex-column gap-4">
                        <!-- Email Card -->
                        <div class="cardCustom text-center p-4 h-100">
                            <div class="cardCustom-image mb-3">
                                <div class="bg-primary rounded-circle p-3 mx-auto" style="width: 80px; height: 80px;">
                                    <span class="text-white fs-2">📧</span>
                                </div>
                            </div>
                            <h3 class="cardCustom-title mb-3">Email Support</h3>
                            <p class="cardCustom-subtext mb-3">
                                Send us detailed inquiries and get comprehensive responses from our medical team.
                            </p>
                            <div class="mt-auto">
                                <a href="mailto:support@ritecareuk.com" class="btnCustom-primary w-100">
                                    support@ritecareuk.com
                                </a>
                            </div>
                        </div>

                        <!-- Phone Card -->
                        <div class="cardCustom text-center p-4 h-100">
                            <div class="cardCustom-image mb-3">
                                <div class="bg-success rounded-circle p-3 mx-auto" style="width: 80px; height: 80px;">
                                    <span class="text-white fs-2">📞</span>
                                </div>
                            </div>
                            <h3 class="cardCustom-title mb-3">Phone Support</h3>
                            <p class="cardCustom-subtext mb-3">
                                Speak directly with our healthcare professionals for immediate assistance.
                            </p>
                            <div class="mt-auto">
                                <a href="tel:+442012345678" class="btnCustom-primary w-100">
                                    +44 20 1234 5678
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Form -->
                <div class="col-lg-8">
                    <div class="cardCustom p-4 h-100">
                        <h3 class="cardCustom-title mb-4">Send Us a Message</h3>
                        <form>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">First Name</label>
                                    <input type="text" class="form-control" placeholder="Enter your first name" required />
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Last Name</label>
                                    <input type="text" class="form-control" placeholder="Enter your last name" required />
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Email Address</label>
                                    <input type="email" class="form-control" placeholder="your.email@example.com" required />
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Phone Number</label>
                                    <input type="tel" class="form-control" placeholder="+44 7XXX XXXXXX" />
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-semibold">Subject</label>
                                    <select class="form-select" required>
                                        <option value="">Select a topic</option>
                                        <option>Treatment Inquiry</option>
                                        <option>Delivery Question</option>
                                        <option>Medical Advice</option>
                                        <option>Prescription Support</option>
                                        <option>Billing & Payment</option>
                                        <option>Other</option>
                                    </select>
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-semibold">Your Message</label>
                                    <textarea class="form-control" rows="5" placeholder="Tell us how we can help you..." required></textarea>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btnCustom-primary w-100 py-3">
                                        Send Message
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Support Features Section -->
    <div class="container-fluid pt-5 bg-sec pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-3">Our Support <span>Features</span></p>
            <p class="subCustom-text text-center mb-4">
                Comprehensive healthcare support designed around your needs
            </p>

            <div class="row g-4 mt-2">
                <!-- Feature 1 -->
                <div class="col-md-4">
                    <div class="cardCustom text-center p-4 h-100">
                        <div class="cardCustom-image mb-3">
                            <div class="bg-info rounded-circle p-3 mx-auto" style="width: 70px; height: 70px;">
                                <span class="text-white fs-3">👨‍⚕️</span>
                            </div>
                        </div>
                        <h3 class="cardCustom-title mb-3">Medical Expertise</h3>
                        <p class="cardCustom-subtext">
                            Get advice from UK-licensed pharmacists and prescribers who understand your health needs.
                        </p>
                    </div>
                </div>

                <!-- Feature 2 -->
                <div class="col-md-4">
                    <div class="cardCustom text-center p-4 h-100">
                        <div class="cardCustom-image mb-3">
                            <div class="bg-warning rounded-circle p-3 mx-auto" style="width: 70px; height: 70px;">
                                <span class="text-white fs-3">⏰</span>
                            </div>
                        </div>
                        <h3 class="cardCustom-title mb-3">Quick Response</h3>
                        <p class="cardCustom-subtext">
                            We typically respond within 24 hours to ensure you get the help you need promptly.
                        </p>
                    </div>
                </div>

                <!-- Feature 3 -->
                <div class="col-md-4">
                    <div class="cardCustom text-center p-4 h-100">
                        <div class="cardCustom-image mb-3">
                            <div class="bg-purple rounded-circle p-3 mx-auto" style="width: 70px; height: 70px;">
                                <span class="text-white fs-3">🔒</span>
                            </div>
                        </div>
                        <h3 class="cardCustom-title mb-3">Secure & Private</h3>
                        <p class="cardCustom-subtext">
                            All communications are encrypted and confidential, protecting your personal health information.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Operating Hours Section -->
    <div class="container-fluid pt-5 bg-main pb-4">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="cardCustom p-4 text-center">
                        <h3 class="cardCustom-title mb-3">Operating Hours</h3>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="p-3 bg-light rounded">
                                    <h5 class="fw-bold text-primary">Monday - Friday</h5>
                                    <p class="mb-0">9:00 AM - 6:00 PM (GMT)</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="p-3 bg-light rounded">
                                    <h5 class="fw-bold text-primary">Saturday</h5>
                                    <p class="mb-0">10:00 AM - 4:00 PM (GMT)</p>
                                </div>
                            </div>
                        </div>
                        <p class="text-muted mt-3 mb-0">
                            Emergency support available outside these hours for urgent medical inquiries
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Styles -->
    <style>
        /* Typography - Consistent with your design */
        .mainCustom-heading {
            font-weight: 700;
            font-size: 2rem;
            color: #0d2a5a;
        }

        .mainCustom-heading span {
            color: #0d6efd;
        }

        .subCustom-text {
            font-size: 1rem;
            line-height: 1.6;
            color: #444;
        }

        /* Card Styling - Consistent with your design */
        .cardCustom {
            border-radius: 15px;
            background: #fff;
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
        }

        .cardCustom:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
        }

        .cardCustom-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #0d2a5a;
        }

        .cardCustom-subtext {
            font-size: 0.95rem;
            color: #555;
            line-height: 1.5;
        }

        /* Form Styling */
        .form-control,
        .form-select,
        textarea {
            border-radius: 10px;
            padding: 0.6rem 1rem;
            border: 1px solid #ccc;
            transition: all 0.3s ease;
        }

        .form-control:focus,
        .form-select:focus,
        textarea:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.2);
        }

        /* Button Styling - Consistent with your design */
        .btnCustom-primary {
            background-color: #0d6efd;
            color: #fff;
            border: none;
            padding: 0.75rem 1.5rem;
            font-size: 1rem;
            border-radius: 50px;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }

        .btnCustom-primary:hover {
            background-color: #0b5ed7;
            transform: translateY(-2px);
            color: #fff;
            text-decoration: none;
        }

        .btnCustom-outline {
            background-color: transparent;
            color: #0d6efd;
            border: 2px solid #0d6efd;
            padding: 0.75rem 1.5rem;
            border-radius: 50px;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }

        .btnCustom-outline:hover {
            background-color: #0d6efd;
            color: #fff;
            transform: translateY(-2px);
            text-decoration: none;
        }

        /* Background colors matching your design */
        .bg-main {
            background-color: #f8f9fa;
        }

        .bg-sec {
            background-color: #e9ecef;
        }

        .bg-main2 {
            background-color: #ffffff;
        }

        .bg-purple {
            background-color: #6f42c1 !important;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .mainCustom-heading {
                font-size: 1.75rem;
            }

            .cardCustom {
                margin-bottom: 1rem;
            }

            .btnCustom-primary,
            .btnCustom-outline {
                width: 100%;
                margin-bottom: 0.5rem;
            }
        }

        @media (max-width: 576px) {
            .mainCustom-heading {
                font-size: 1.5rem;
            }

            .subCustom-text {
                font-size: 0.9rem;
            }
        }
    </style>
</main>