<main>
    <!-- Hero Section -->
    <div class="container-fluid pt-5 bg-main pb-4">
        <div class="container mt-5 text-center">
            <p class="mainCustom-heading mb-3">
                Fast and Secure <span>Prescription Delivery</span>
            </p>
            <p class="subCustom-text mx-auto" style="max-width: 850px;">
                Ritecare Pharmacy ensures your prescription medication is handled with the utmost care, dispensed by our UK-licensed team, and delivered securely to your chosen address.
            </p>
        </div>
    </div>

    <!-- Our Delivery Promise -->
    <div class="container-fluid pt-5 bg-sec pb-5">
        <div class="container">
            <p class="text-center mainCustom-heading mb-4">
                Our <span>Delivery Promise</span>
            </p>
            <p class="subCustom-text text-center mb-5">
                We're committed to providing secure, discreet, and reliable delivery for all your prescriptions
            </p>

            <div class="row g-4">
                <!-- Promise 1 -->
                <div class="col-md-4">
                    <div class="promise-card text-center p-4 rounded-4 shadow-sm bg-white">
                        <div class="promise-icon fs-1 mb-3">🔒</div>
                        <h4 class="promise-title fw-bold mb-2">Total Discretion Guaranteed</h4>
                        <p class="promise-text mb-0">
                            All orders are shipped in plain, unbranded packaging. No visible logos, pharmacy names, or medication references appear on the exterior.
                        </p>
                    </div>
                </div>

                <!-- Promise 2 -->
                <div class="col-md-4">
                    <div class="promise-card text-center p-4 rounded-4 shadow-sm bg-white">
                        <div class="promise-icon fs-1 mb-3">🚚</div>
                        <h4 class="promise-title fw-bold mb-2">Secure Shipping</h4>
                        <p class="promise-text mb-0">
                            Tracked courier services are used for all deliveries. Receive a tracking number to monitor your parcel from dispatch to doorstep.
                        </p>
                    </div>
                </div>

                <!-- Promise 3 -->
                <div class="col-md-4">
                    <div class="promise-card text-center p-4 rounded-4 shadow-sm bg-white">
                        <div class="promise-icon fs-1 mb-3">❄️</div>
                        <h4 class="promise-title fw-bold mb-2">Temperature-Controlled Packaging</h4>
                        <p class="promise-text mb-0">
                            For injectable treatments like Mounjaro or Semaglutide, medical-grade cold storage packaging is used to maintain medication effectiveness.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delivery Options Table -->
    <div class="container-fluid pt-5 bg-main2 pb-5">
        <div class="container">
            <p class="text-center mainCustom-heading mb-4">
                Delivery Options <span>and Times</span>
            </p>
            <p class="subCustom-text text-center mb-5">
                Choose the delivery method that best suits your needs
            </p>

            <div class="table-responsive">
                <table class="table table-custom table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Delivery Method</th>
                            <th>Timeframe</th>
                            <th>Details</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Standard Tracked Delivery</td>
                            <td>2–3 Business Days</td>
                            <td>Popular option. Fully tracked with notifications.</td>
                        </tr>
                        <tr>
                            <td>Express Next-Day Delivery</td>
                            <td>1 Business Day</td>
                            <td>Orders placed before 2 PM. Ideal for urgent needs.</td>
                        </tr>
                        <tr>
                            <td>Post Office Collection</td>
                            <td>2–3 Business Days</td>
                            <td>Collect from a secure Post Office branch. May not be available for temperature-sensitive items.</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- FAQ Section -->
    <div class="container-fluid pt-5 bg-sec pb-5">
        <div class="container">
            <p class="text-center mainCustom-heading mb-4">
                Frequently Asked <span>Questions</span>
            </p>
            <p class="subCustom-text text-center mb-5">
                Everything you need to know about our delivery service
            </p>

            <div class="row g-4">
                <!-- Left Column -->
                <div class="col-md-6">
                    <div class="accordion" id="faqAccordionLeft">
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingOne">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    When will my order be dispatched?
                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                                data-bs-parent="#faqAccordionLeft">
                                <div class="accordion-body">
                                    Most approved orders are dispatched within 24 hours (Mon-Fri). A tracking email is sent once it leaves our facility.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingTwo">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    Do you deliver on weekends?
                                </button>
                            </h2>
                            <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                                data-bs-parent="#faqAccordionLeft">
                                <div class="accordion-body">
                                    Standard delivery is Mon-Fri. Express may include Saturday depending on courier availability.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingThree">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    Where do you deliver?
                                </button>
                            </h2>
                            <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                                data-bs-parent="#faqAccordionLeft">
                                <div class="accordion-body">
                                    We deliver across the UK. Remote locations may require an extra day.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-md-6">
                    <div class="accordion" id="faqAccordionRight">
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingFour">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                    Can I track my delivery?
                                </button>
                            </h2>
                            <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                                data-bs-parent="#faqAccordionRight">
                                <div class="accordion-body">
                                    Yes, all deliveries are tracked. You will receive a tracking number and link after dispatch.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingFive">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                    What if I'm not home for delivery?
                                </button>
                            </h2>
                            <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                                data-bs-parent="#faqAccordionRight">
                                <div class="accordion-body">
                                    The courier will leave instructions for redelivery or local collection. Post Office Collection is also available.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingSix">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                    Are there any delivery charges?
                                </button>
                            </h2>
                            <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                                data-bs-parent="#faqAccordionRight">
                                <div class="accordion-body">
                                    Standard tracked delivery is free. Express next-day delivery is available for an additional fee.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="container-fluid pt-5 bg-main pb-5">
        <div class="container text-center">
            <div class="cta-box p-4 p-md-5 rounded-4 bg-white shadow-sm">
                <h3>Ready to order?</h3>
                <p>Check your eligibility and experience our fast, discreet delivery service.</p>
                <a href="#" class="btnCustom-white">Start Consultation Now</a>
            </div>
        </div>
    </div>

    <!-- Styles -->
    <style>
        .mainCustom-heading {
            font-weight: 700;
            font-size: 2rem;
            color: #0d2a5a;
        }

        .mainCustom-heading span {
            color: #0d6efd;
        }

        .subCustom-text {
            font-size: 1rem;
            line-height: 1.6;
            color: #444;
        }

        .promise-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .promise-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        }

        .btnCustom-white {
            background-color: #fff;
            color: #0d6efd;
            border: 2px solid #0d6efd;
            padding: 0.75rem 1.5rem;
            border-radius: 50px;
            transition: all 0.3s ease;
        }

        .btnCustom-white:hover {
            background-color: #0d6efd;
            color: #fff;
        }

        .table-custom th,
        .table-custom td {
            vertical-align: middle;
        }

        @media (max-width: 768px) {
            .p-md-5 {
                padding: 2rem !important;
            }
        }

        @media (max-width: 576px) {
            .mainCustom-heading {
                font-size: 1.5rem;
            }
        }
    </style>
</main>