<!-- FAQ section -->
<div class="container-fluid pt-5 bg-sec pb-4">
    <div class="container">
        <p class="text-center mainCustom-heading">
            Frequently Asked <span>Questions</span>
        </p>
        <p class="subCustom-text text-center mb-4">
            Quick answers to common questions about our services and treatments.
        </p>

        <div class="row g-4 mt-2">
            <!-- Left Column -->
            <div class="col-md-6">
                <div class="accordion" id="faqAccordionLeft">

                    <!-- Q1 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                Why has the price of Mounjaro changed?
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                            data-bs-parent="#faqAccordionLeft">
                            <div class="accordion-body">
                                The company that makes Mounjaro, Eli Lilly, decided to increase the cost for all dose sizes in the UK.
                                This was done to match the prices found in other European countries. We work to give you the best value
                                while reflecting this change.
                            </div>
                        </div>
                    </div>

                    <!-- Q2 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                Is Wegovy as effective as Mounjaro?
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                            data-bs-parent="#faqAccordionLeft">
                            <div class="accordion-body">
                                Both Wegovy (Semaglutide) and Mounjaro (Tirzepatide) work well for weight loss. However, studies often
                                show that Mounjaro helps people lose more weight on average. This is because Mounjaro affects two ways
                                your body manages hunger, while Wegovy mainly affects one.
                            </div>
                        </div>
                    </div>

                    <!-- Q3 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                Do Wegovy & Mounjaro have similar effects?
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                            data-bs-parent="#faqAccordionLeft">
                            <div class="accordion-body">
                                Yes, they work in similar ways. Both medications help you feel less hungry, stop strong food cravings,
                                and feel full for longer after you eat. They also have similar small side effects, like upset stomachs at
                                the start.
                            </div>
                        </div>
                    </div>

                    <!-- Q4 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                Does Wegovy have additional benefits?
                            </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                            data-bs-parent="#faqAccordionLeft">
                            <div class="accordion-body">
                                Wegovy has one very important extra benefit. It is the first weight loss shot that has been proven to
                                lower the chance of serious heart issues (like heart attacks) for people who already have heart disease.
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <!-- Right Column -->
            <div class="col-md-6">
                <div class="accordion" id="faqAccordionRight">

                    <!-- Q5 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                Can I switch from Mounjaro to Wegovy?
                            </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                            data-bs-parent="#faqAccordionRight">
                            <div class="accordion-body">
                                You can switch, but this must always be managed by a medical expert like your RiteCare prescriber. If you
                                are thinking about changing, just let us know. We will safely guide you through the process and the
                                correct new dose.
                            </div>
                        </div>
                    </div>

                    <!-- Q6 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                How much weight can I lose?
                            </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                            data-bs-parent="#faqAccordionRight">
                            <div class="accordion-body">
                                How much you lose depends on your body and how much you stick to healthy eating and exercise. People
                                using these modern treatments often see great results, typically losing between 15% and over 20% of their
                                starting body weight during their treatment time.
                            </div>
                        </div>
                    </div>

                    <!-- Q7 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeven">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                Is my BMI suitable?
                            </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven"
                            data-bs-parent="#faqAccordionRight">
                            <div class="accordion-body">
                                This treatment is usually right for adults who have a BMI of 30 or higher. You may also qualify if your
                                BMI is 27 or higher and you have other health issues linked to your weight (like high blood pressure). We
                                check your exact suitability during your private online review.
                            </div>
                        </div>
                    </div>

                    <!-- Q8 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingEight">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                                Do I need to sign up to a subscription?
                            </button>
                        </h2>
                        <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight"
                            data-bs-parent="#faqAccordionRight">
                            <div class="accordion-body">
                                No, there is no need to sign up for any kind of automatic contract. You simply pay for your medicine one
                                month at a time. This allows you to stay in charge and order your next supply only when you feel ready to
                                keep going.
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>