<div class="container-fluid py-5">
    <div class="container">
        <div class="row g-5">
            <!-- Left Side - Images -->
            <div class="col-md-6">
                <!-- <pre><?php print_r($recommendedProduct); ?></pre> -->
                <!-- <pre><?php print_r($Customer_data_id); ?></pre> -->

                <div class="main-image">
                    <img id="mainImage" src="<?= base_url('assets/images/p1.png'); ?>" alt="Product" />
                </div>
                <div class="thumbnail-list">
                    <div class="thumbnail-item active" onclick="changeImage(this, '<?= base_url('assets/images/p1.png'); ?>')">
                        <img src="<?= base_url('assets/images/p1.png'); ?>" alt="thumb1" />
                    </div>
                    <div class="thumbnail-item" onclick="changeImage(this, '<?= base_url('assets/images/pr2.png'); ?>')">
                        <img src="<?= base_url('assets/images/pr2.png'); ?>" alt="thumb2" />
                    </div>
                    <div class="thumbnail-item" onclick="changeImage(this, '<?= base_url('assets/images/pr3.png'); ?>')">
                        <img src="<?= base_url('assets/images/pr3.png'); ?>" alt="thumb3" />
                    </div>
                </div>
            </div>

            <!-- Right Side - Details -->
            <div class="col-md-6">
                <h2 class="product-title">Orlistat 120mg (Xenical)</h2>
                <p class="product-subtitle">Weight loss capsules from £21.99</p>

                <!-- Price Options -->
                <div class="price-card" onclick="selectCard(this)">
                    <input type="radio" name="priceOption" value="21.99" checked />
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="price-card-title">2 weeks (42 capsules)</div>
                            <div class="price-card-subtext">£0.53 a capsule</div>
                        </div>
                        <div class="price-card-right">£21.99</div>
                    </div>
                </div>
                <div class="price-card" onclick="selectCard(this)">
                    <input type="radio" name="priceOption" value="38.99" />
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="price-card-title">4 weeks (84 capsules)</div>
                            <div class="price-card-subtext">£0.47 a capsule</div>
                        </div>
                        <div class="price-card-right">£38.99</div>
                    </div>
                </div>
                <div class="price-card" onclick="selectCard(this)">
                    <input type="radio" name="priceOption" value="74.99" />
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="price-card-title">8 weeks (168 capsules)</div>
                            <div class="price-card-subtext">£0.45 a capsule</div>
                        </div>
                        <div class="price-card-right">£74.99</div>
                    </div>
                </div>
                <input type="hidden" id="Customer_data_id" value="<?= $Customer_data_id ?>">


                <!-- Buy Now Button -->
                <button class="buy-btn btn btn-success mt-3">Buy Now</button>
            </div>
        </div>
    </div>
</div>

<script>
    function changeImage(element, imagePath) {
        document.getElementById("mainImage").src = imagePath;
        document.querySelectorAll(".thumbnail-item").forEach(item => item.classList.remove("active"));
        element.classList.add("active");
    }

    function selectCard(card) {
        document.querySelectorAll(".price-card").forEach(c => c.classList.remove("active"));
        card.classList.add("active");
        card.querySelector('input[type="radio"]').checked = true;
    }
</script>


<script src="https://js.stripe.com/v3/"></script>
<script>
    const stripe = Stripe('<?= $stripe_publishable_key ?>');

    document.querySelector('.buy-btn').addEventListener('click', async () => {
        // Get the selected price
        const selectedPrice = document.querySelector('input[name="priceOption"]:checked').value;

        // Get Customer_data_id from hidden input
        const customerDataId = document.getElementById('Customer_data_id').value;
        console.log("Customer_data_id:", customerDataId); // optional for debugging

        // Send both price and Customer_data_id to backend
        const response = await fetch('<?= base_url("stripe/checkout") ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: 'price=' + encodeURIComponent(selectedPrice) +
                '&Customer_data_id=' + encodeURIComponent(customerDataId)
        });

        const session = await response.json();

        if (session.id) {
            stripe.redirectToCheckout({
                sessionId: session.id
            });
        } else {
            alert("Error creating checkout session: " + (session.error || "Unknown"));
        }
    });
</script>

<!-- <script>
    const stripe = Stripe('<?= $stripe_publishable_key ?>');

    document.querySelector('.buy-btn').addEventListener('click', async () => {
        const selectedPrice = document.querySelector('input[name="priceOption"]:checked').value;

        const response = await fetch('<?= base_url("stripe/checkout") ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: 'price=' + selectedPrice
        });

        const session = await response.json();

        if (session.id) {
            stripe.redirectToCheckout({
                sessionId: session.id
            });
        } else {
            alert("Error creating checkout session: " + (session.error || "Unknown"));
        }
    });
</script> -->