<div class="container-fluid py-5 bg-light">
    <div class="container">
        <div class="row g-5 align-items-start">
            <!-- Product Images -->
            <div class="col-md-6">
                <div class="main-image mb-3">
                    <img id="mainImage" src="<?= base_url('assets/images/p1.png'); ?>" alt="Orlistat 120mg" class="img-fluid rounded shadow-sm" />
                </div>
                <div class="thumbnail-list d-flex gap-2">
                    <div class="thumbnail-item active" onclick="changeImage(this, '<?= base_url('assets/images/p1.png'); ?>')">
                        <img src="<?= base_url('assets/images/p1.png'); ?>" alt="Orlistat 1" />
                    </div>
                    <div class="thumbnail-item" onclick="changeImage(this, '<?= base_url('assets/images/pr2.png'); ?>')">
                        <img src="<?= base_url('assets/images/pr2.png'); ?>" alt="Orlistat 2" />
                    </div>
                    <div class="thumbnail-item" onclick="changeImage(this, '<?= base_url('assets/images/pr3.png'); ?>')">
                        <img src="<?= base_url('assets/images/pr3.png'); ?>" alt="Orlistat 3" />
                    </div>
                </div>
            </div>

            <!-- Product Details -->
            <div class="col-md-6">
                <h2 class="fw-bold mb-2">Orlistat 120mg (Xenical)</h2>
                <p class="text-muted mb-3">Clinically proven prescription capsules for effective weight loss.</p>

                <div class="price-card-list mb-4">
                    <div class="price-card active">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="mb-1 fw-semibold">2 weeks supply (42 capsules)</p>
                                <small class="text-muted">£0.53 per capsule</small>
                            </div>
                            <p class="fw-bold">£21.99</p>
                        </div>
                    </div>
                    <div class="price-card">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="mb-1 fw-semibold">4 weeks supply (84 capsules)</p>
                                <small class="text-muted">£0.47 per capsule</small>
                            </div>
                            <p class="fw-bold">£38.99</p>
                        </div>
                    </div>
                    <div class="price-card">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="mb-1 fw-semibold">8 weeks supply (168 capsules)</p>
                                <small class="text-muted">£0.45 per capsule</small>
                            </div>
                            <p class="fw-bold">£74.99</p>
                        </div>
                    </div>
                </div>

                <h5 class="fw-semibold mb-2">About this medication</h5>
                <p>
                    Orlistat (Xenical) is a prescription-only medication designed to help with weight loss by blocking
                    the absorption of dietary fat. It’s clinically proven to help users lose more weight compared to diet
                    and exercise alone.
                </p>

                <h5 class="fw-semibold mt-4 mb-2">How it works</h5>
                <p>
                    Orlistat acts in your digestive system by preventing around one-third of the fat from your meals
                    from being absorbed. The undigested fat is naturally excreted from the body.
                </p>

                <h5 class="fw-semibold mt-4 mb-2">Who can use it</h5>
                <p>
                    This treatment is suitable for adults aged 18 and over with a BMI of 30 or higher, or 28+ with
                    weight-related conditions such as type 2 diabetes or high blood pressure.
                </p>

                <h5 class="fw-semibold mt-4 mb-2">Key benefits</h5>
                <ul class="list-unstyled">
                    <li>✔ Clinically proven to support weight loss</li>
                    <li>✔ Reduces fat absorption from meals</li>
                    <li>✔ Works alongside a balanced diet and exercise</li>
                    <li>✔ Prescribed and reviewed by UK-licensed clinicians</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
    .thumbnail-list img {
        width: 80px;
        height: 80px;
        border-radius: 8px;
        object-fit: cover;
        border: 2px solid transparent;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .thumbnail-item.active img,
    .thumbnail-item img:hover {
        border-color: #0d6efd;
    }

    .price-card {
        border: 1px solid #e2e6ea;
        border-radius: 10px;
        padding: 12px 18px;
        margin-bottom: 10px;
        transition: all 0.3s ease;
        background: #fff;
    }

    .price-card:hover {
        border-color: #0d6efd;
        background: #f8f9ff;
    }

    .price-card.active {
        border-color: #0d6efd;
        background: #eef3ff;
    }

    ul.list-unstyled li {
        margin-bottom: 6px;
        color: #333;
    }
</style>

<script>
    function changeImage(element, imagePath) {
        document.getElementById("mainImage").src = imagePath;
        document.querySelectorAll(".thumbnail-item").forEach(item => item.classList.remove("active"));
        element.classList.add("active");
    }

    function selectCard(card) {
        document.querySelectorAll(".price-card").forEach(c => c.classList.remove("active"));
        card.classList.add("active");
    }
</script>