<main>
    <!-- Hero Section -->
    <div class="container-fluid pt-5 bg-main pb-4">
        <div class="container mt-5 text-center">
            <p class="mainCustom-heading mb-3">Real Journeys. <span>Real Results.</span></p>
            <p class="subCustom-text mx-auto" style="max-width: 850px;">
                See what our customers are saying about the life-changing results of their prescribed treatments.
            </p>
        </div>
    </div>

    <!-- Why Customers Choose Ritecare -->
    <div class="container-fluid pt-5 bg-sec pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-4">Why Customers <span>Choose Ritecare</span></p>
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <ul class="subCustom-text" style="list-style: none; padding-left: 0;">
                        <li class="mb-3"><strong>1. Clinical Trust:</strong> Prescriptions issued only by experienced, UK-licensed prescribers.</li>
                        <li class="mb-3"><strong>2. Service Speed:</strong> Quick online consultation and fast, secure dispatch.</li>
                        <li class="mb-3"><strong>3. Complete Discretion:</strong> Logo-free, plain packaging every time.</li>
                        <li class="mb-3"><strong>4. Ongoing Support:</strong> Dedicated clinical team available throughout your treatment.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Featured Testimonials -->
    <div class="container-fluid pt-5 bg-main2 pb-4">
        <div class="container">
            <p class="text-center mainCustom-heading mb-5">Featured <span>Testimonials</span></p>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="testimonial-card p-4 rounded-4 shadow-sm bg-white h-100">
                        <p class="testimonial-text">
                            “Switching to Ritecare was the best decision I made. The online process was so simple, and I felt properly assessed by the clinician. I’ve lost 15kg in six months and finally feel like I have control. Highly recommend for their professionalism and speed.”
                        </p>
                        <p class="mt-3 mb-0 fw-semibold text-primary">— David K., Weight Loss Patient</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="testimonial-card p-4 rounded-4 shadow-sm bg-white h-100">
                        <p class="testimonial-text">
                            “Had a few questions about my dosage and the clinical team responded in my secure account within hours. Knowing I have that expert backup makes the whole weight loss journey much easier. A truly trusted service.”
                        </p>
                        <p class="mt-3 mb-0 fw-semibold text-primary">— Sarah M., Verified Customer</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="testimonial-card p-4 rounded-4 shadow-sm bg-white h-100">
                        <p class="testimonial-text">
                            “From eligibility check to delivery, everything was seamless. The packaging was discrete and the medication arrived safely. It’s an easy way to get prescribed treatment without the typical pharmacy hassle.”
                        </p>
                        <p class="mt-3 mb-0 fw-semibold text-primary">— Liam R., Patient Since 2024</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Call To Action -->
    <div class="container-fluid pt-5 bg-sec pb-5">
        <div class="container text-center">
            <div class="cta-box p-4 p-md-5 rounded-4 bg-white shadow-sm">
                <h3>Ready to start your success story?</h3>
                <p>Check your eligibility and experience our fast, discreet service.</p>
                <a href="<?php echo base_url('home/eligibility') ?>" class="btnCustom-primary">Start Your Consultation
                </a>
            </div>
        </div>
    </div>

    <!-- Styles -->
    <style>
        .mainCustom-heading {
            font-weight: 700;
            font-size: 2rem;
            color: #0d2a5a;
        }

        .mainCustom-heading span {
            color: #0d6efd;
        }

        .subCustom-text {
            font-size: 1rem;
            line-height: 1.6;
            color: #444;
        }

        .testimonial-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .testimonial-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        }

        .testimonial-text {
            font-size: 0.95rem;
            color: #333;
            line-height: 1.5;
        }

        .text-primary {
            color: #0d6efd !important;
        }

        .btnCustom-primary {
            background-color: #0d6efd;
            color: #fff;
            border-radius: 50px;
            padding: 0.75rem 1.5rem;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .btnCustom-primary:hover {
            background-color: #0a58ca;
            color: #fff;
        }

        .cta-box {
            max-width: 600px;
            margin: 0 auto;
        }

        @media (max-width: 768px) {
            .p-md-5 {
                padding: 2rem !important;
            }
        }

        @media (max-width: 576px) {
            .mainCustom-heading {
                font-size: 1.5rem;
            }
        }
    </style>
</main>