<div class="container my-5">
    <div class="order-form-wrapper">
        <div class="text-center mb-4">
            <h2>📦 Complete Your Order</h2>
            <p class="text-muted">Upload pictures and add delivery details</p>
            <pre><?= var_dump($Customer_data_id); ?></pre>
        </div>

        <?php if (!empty($session_data['error'])): ?>
            <div class="alert alert-danger"><?= $session_data['error']; ?></div>
        <?php endif; ?>

        <form id="orderForm" method="post" action="<?= base_url('order/place_order') ?>" enctype="multipart/form-data">

            <!-- Pictures Upload Section -->
            <div class="form-section">
                <h5>📸 Upload Pictures (Max 5)</h5>

                <div class="upload-area" id="uploadArea">
                    <div class="upload-icon">📤</div>
                    <p>Click or drag to upload images</p>
                    <input type="file" id="order_pictures" name="order_pictures[]" multiple accept="image/*">
                </div>

                <div id="previewContainer" class="preview-grid mt-3"></div>
                <small class="text-muted d-block mt-2">
                    <span id="imageCount">0</span>/5 images uploaded
                </small>
            </div>

            <!-- Delivery Details Section -->
            <div class="form-section">
                <h5>🏠 Delivery Details</h5>

                <input type="hidden" name="Customer_data_id" value="<?= htmlspecialchars($Customer_data_id ?? '', ENT_QUOTES) ?>">

                <div class="mb-3">
                    <label class="form-label">Full Name *</label>
                    <input type="text" class="form-control" name="customer_name" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Phone Number *</label>
                    <input type="tel" class="form-control" name="phone" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Complete Address *</label>
                    <textarea class="form-control" name="address" rows="3" required></textarea>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">City *</label>
                        <input type="text" class="form-control" name="city" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Postal Code</label>
                        <input type="text" class="form-control" name="postal_code">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Special Instructions (Optional)</label>
                    <textarea class="form-control" name="notes" rows="2" placeholder="Any special delivery instructions..."></textarea>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary btn-lg px-5" id="submitBtn">
                    ✓ Place Order
                </button>
            </div>
        </form>
    </div>
</div>

<style>
    .order-form-wrapper {
        max-width: 700px;
        margin: 0 auto;
        background: white;
        padding: 30px;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .form-section {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        margin-bottom: 25px;
    }

    .form-section h5 {
        margin-bottom: 15px;
        color: #333;
        font-weight: 600;
    }

    .upload-area {
        border: 2px dashed #007bff;
        border-radius: 10px;
        padding: 30px;
        text-align: center;
        background: white;
        cursor: pointer;
        transition: 0.3s;
        position: relative;
    }

    .upload-area:hover {
        background: #f0f8ff;
        border-color: #0056b3;
    }

    .upload-area.dragover {
        background: #e7f3ff;
        border-color: #0056b3;
    }

    .upload-icon {
        font-size: 2.5rem;
        margin-bottom: 10px;
    }

    #order_pictures {
        position: absolute;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        opacity: 0;
        cursor: pointer;
    }

    .preview-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
        gap: 10px;
    }

    .preview-item {
        position: relative;
        aspect-ratio: 1;
        border-radius: 8px;
        overflow: hidden;
        background: #f0f0f0;
    }

    .preview-item img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .preview-item .remove-btn {
        position: absolute;
        top: 5px;
        right: 5px;
        background: #dc3545;
        color: white;
        border: none;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        font-size: 16px;
        cursor: pointer;
        line-height: 1;
        z-index: 10;
    }

    .preview-item .remove-btn:hover {
        background: #c82333;
    }

    .form-label {
        font-weight: 500;
        color: #555;
    }

    .form-control:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, .25);
    }

    #submitBtn:disabled {
        opacity: 0.6;
        cursor: not-allowed;
    }

    @media(max-width: 768px) {
        .order-form-wrapper {
            padding: 20px;
        }

        .preview-grid {
            grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
        }
    }
</style>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    const fileInput = document.getElementById('order_pictures');
    const uploadArea = document.getElementById('uploadArea');
    const previewContainer = document.getElementById('previewContainer');
    const imageCount = document.getElementById('imageCount');
    const orderForm = document.getElementById('orderForm');
    const submitBtn = document.getElementById('submitBtn');

    const MAX_FILES = 5;
    let currentFiles = []; // Store all selected files

    // Drag and drop events
    ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(evt => {
        uploadArea.addEventListener(evt, e => {
            e.preventDefault();
            e.stopPropagation();
        });
    });

    ['dragenter', 'dragover'].forEach(evt => {
        uploadArea.addEventListener(evt, () => uploadArea.classList.add('dragover'));
    });

    ['dragleave', 'drop'].forEach(evt => {
        uploadArea.addEventListener(evt, () => uploadArea.classList.remove('dragover'));
    });

    uploadArea.addEventListener('drop', e => {
        const droppedFiles = Array.from(e.dataTransfer.files).filter(f => f.type.startsWith('image/'));

        if (currentFiles.length + droppedFiles.length > MAX_FILES) {
            Swal.fire({
                icon: 'warning',
                title: 'Too many files',
                text: `Maximum ${MAX_FILES} images allowed. You have ${currentFiles.length} already.`
            });
            return;
        }

        // Add new files to current files
        droppedFiles.forEach(file => {
            currentFiles.push(file);
        });

        updateFileInput();
        updatePreview();
    });

    // File input change
    fileInput.addEventListener('change', function() {
        const newFiles = Array.from(this.files);

        if (currentFiles.length + newFiles.length > MAX_FILES) {
            Swal.fire({
                icon: 'warning',
                title: 'Too many files',
                text: `Maximum ${MAX_FILES} images allowed. You have ${currentFiles.length} already.`
            });
            return;
        }

        // Add new files to current files
        newFiles.forEach(file => {
            currentFiles.push(file);
        });

        updateFileInput();
        updatePreview();
    });

    // Update the actual file input with all current files
    function updateFileInput() {
        const dt = new DataTransfer();
        currentFiles.forEach(file => {
            dt.items.add(file);
        });
        fileInput.files = dt.files;
    }

    function updatePreview() {
        imageCount.textContent = currentFiles.length;
        previewContainer.innerHTML = '';

        currentFiles.forEach((file, index) => {
            if (!file.type.startsWith('image/')) return;

            const reader = new FileReader();
            reader.onload = e => {
                const div = document.createElement('div');
                div.className = 'preview-item';
                div.innerHTML = `
                    <img src="${e.target.result}" alt="Preview">
                    <button type="button" class="remove-btn" onclick="removeImage(${index})">×</button>
                `;
                previewContainer.appendChild(div);
            };
            reader.readAsDataURL(file);
        });
    }

    window.removeImage = function(index) {
        // Remove the file from currentFiles array
        currentFiles.splice(index, 1);

        // Update file input and preview
        updateFileInput();
        updatePreview();
    };

    // Form submission
    orderForm.addEventListener('submit', function(e) {
        e.preventDefault();

        if (currentFiles.length === 0) {
            Swal.fire({
                icon: 'error',
                title: 'No Images',
                text: 'Please upload at least 1 image'
            });
            return;
        }

        console.log('Submitting with files:', currentFiles); // Debug

        submitBtn.disabled = true;
        submitBtn.innerHTML = '⏳ Processing...';

        const formData = new FormData(this);

        // Debug: Log FormData contents
        for (let pair of formData.entries()) {
            console.log(pair[0], pair[1]);
        }

        fetch(this.action, {
                method: 'POST',
                body: formData
            })
            .then(response => {
                console.log('Response status:', response.status);
                return response.text();
            })
            .then(text => {
                console.log('Response text:', text);
                try {
                    const data = JSON.parse(text);
                    if (data.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: data.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            if (data.redirect) {
                                window.location.href = data.redirect;
                            }
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: data.message
                        });
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = '✓ Place Order';
                    }
                } catch (e) {
                    console.error('JSON parse error:', e);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Server returned invalid response: ' + text.substring(0, 100)
                    });
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = '✓ Place Order';
                }
            })
            .catch(error => {
                console.error('Fetch error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Something went wrong. Please try again.'
                });
                submitBtn.disabled = false;
                submitBtn.innerHTML = '✓ Place Order';
            });
    });
</script>