<main>

	<!-- banner area -->
	<div class="container-fluid pt-5 bg-main pb-4">
		<div class="container mt-5">
			<div class="row">
				<div class="col-md-6">
					<p class="mainCustom-heading">
						Clinically-Approved <span>medicated weight</span> loss treatment
					</p>

					<p class="subCustom-text">
						Your sustainable weight loss journey starts here. Treatments prescribed and closely monitored by our licensed UK healthcare providers.
					</p>

					<p class="subCustom-text">
						<sub>From</sub> <span>£99.99</span> <sub> (£25.00 per dose)</sub>
					</p>
					<div class="d-flex gap-2 mt-2">
						<a href="<?php echo base_url('home/eligibility'); ?>"
							class="btn btnCustom-primary">
							Check Your Eligibility
						</a>
						<!-- <button class="btn btnCustom-secondary">
							See Treatment Options
						</button> -->
					</div>
				</div>
				<div class="col-md-6">
					<img
						class="img-fluid border-15"
						src="<?php echo base_url('assets/images/banner.png'); ?>"
						alt="" />
				</div>
			</div>
		</div>
	</div>

	<!-- Explore Treatments -->
	<div class="container-fluid pt-5 bg-sec pb-4">
		<div class="container">
			<p class="text-center mainCustom-heading">
				Explore <span>Proven Weight Management</span> Treatments
			</p>
			<p class="subCustom-text text-center">
				Achieve lasting results with medications backed by clinical science and supported by expert guidance.
			</p>


			<!-- Swiper -->
			<div class="swiper cardSwiper">
				<div class="swiper-wrapper">
					<!-- Slide 1 -->
					<div class="swiper-slide">
						<div class="cardCustom mt-4">
							<div class="cardCustom-image">
								<img src="<?php echo base_url('assets/images/t1.png'); ?>" alt="Example" class="img-fluid rounded" />
							</div>
							<h3 class="cardCustom-title mt-3">Mounjaro®</h3>
							<p class="cardCustom-subtext mb-0">
								Lose up to 20% body weight†
							</p>
							<span class="badgeCustom">Most effective dual action GLP-1</span>
							<a href="./eligibility.html" class="btn btnCustom-primary2 w-100 text-center mb-2 mt-3">
								Check Your Eligibility
							</a>
							<div class="d-flex justify-content-center">
								<a href="<?php echo base_url('home/product-detail') ?>" class="learnMore-link mt-2 text-center">Learn More</a>
							</div>
						</div>
					</div>

					<!-- Slide 2 -->
					<div class="swiper-slide">
						<div class="cardCustom mt-4">
							<div class="cardCustom-image">
								<img src="<?php echo base_url('assets/images/t2.png'); ?>" alt="Example" class="img-fluid rounded" />
							</div>
							<h3 class="cardCustom-title mt-3">Ozempic®</h3>
							<p class="cardCustom-subtext mb-0">Clinically proven results</p>
							<span class="badgeCustom">Trusted GLP-1 therapy</span>
							<a href="./eligibility.html" class="btn btnCustom-primary2 w-100 text-center mb-2 mt-3">
								Check Your Eligibility
							</a>
							<div class="d-flex justify-content-center">
								<a href="#" class="learnMore-link mt-2 text-center">Learn More</a>
							</div>
						</div>
					</div>

					<!-- Slide 3 -->
					<div class="swiper-slide">
						<div class="cardCustom mt-4">
							<div class="cardCustom-image">
								<img src="<?php echo base_url('assets/images/t3.png'); ?>" alt="Example" class="img-fluid rounded" />
							</div>
							<h3 class="cardCustom-title mt-3">Wegovy®</h3>
							<p class="cardCustom-subtext mb-0">Clinically proven results</p>
							<span class="badgeCustom">Trusted GLP-1 therapy</span>
							<a href="./eligibility.html" class="btn btnCustom-primary2 w-100 text-center mb-2 mt-3">
								Check Your Eligibility
							</a>
							<div class="d-flex justify-content-center">
								<a href="#" class="learnMore-link mt-2 text-center">Learn More</a>
							</div>
						</div>
					</div>

					<!-- Slide 4 -->
					<div class="swiper-slide">
						<div class="cardCustom mt-4">
							<div class="cardCustom-image">
								<img src="<?php echo base_url('assets/images/t2.png'); ?>" alt="Example" class="img-fluid rounded" />
							</div>
							<h3 class="cardCustom-title mt-3">Saxenda®</h3>
							<p class="cardCustom-subtext mb-0">Clinically proven results</p>
							<span class="badgeCustom">Trusted GLP-1 therapy</span>
							<a href="./eligibility.html" class="btn btnCustom-primary2 w-100 text-center mb-2 mt-3">
								Check Your Eligibility
							</a>
							<div class="d-flex justify-content-center">
								<a href="#" class="learnMore-link mt-2 text-center">Learn More</a>
							</div>
						</div>
					</div>
				</div>

				<!-- Navigation -->
				<div class="swiper-button-prev"></div>
				<div class="swiper-pagination"></div>
				<div class="swiper-button-next"></div>
			</div>

			<!-- Disclaimer Section -->
			<div class="container-fluid bg-light py-4 mt-4">
				<div class="container">
					<p class="text-center mainCustom-heading mb-3">Important <span>Disclaimers</span></p>

					<div class="row g-3">
						<div class="col-md-6">
							<div class="disclaimer-box p-3 border rounded-3 shadow-sm bg-white h-100">
								<h5 class="fw-bold text-primary">Mounjaro® Disclaimer</h5>
								<p class="mb-0 small text-muted">
									†Clinical studies show that Mounjaro (Tirzepatide), when combined with diet and exercise, led to an average weight reduction of up to <strong>20.9%</strong> in some patients over 72 weeks. Individual results may vary.
								</p>
							</div>
						</div>
						<div class="col-md-6">
							<div class="disclaimer-box p-3 border rounded-3 shadow-sm bg-white h-100">
								<h5 class="fw-bold text-primary">Semaglutide Disclaimer</h5>
								<p class="mb-0 small text-muted">
									*Semaglutide users experienced an average weight loss of <strong>15%</strong> when combined with lifestyle changes over 68 weeks. This treatment has also been clinically shown to reduce the risk of major cardiovascular events in patients with pre-existing heart disease.
								</p>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Disclaimer Section -->


			<!-- guide banner -->
			<div class="guide d-flex flex-wrap my-4">
				<div class="left-picture">
					<img class="" src="<?php echo base_url('assets/images/imageguide.png'); ?>" alt="GLP-1 Health Guide" />
				</div>
				<div class="right-guide">
					<span class="newBadge newBadge-success">NEW</span>
					<p class="font-h">The GLP-1 Health Guide</p>
					<p class="font-p">
						Empower yourself with essential information. Everything you need to know about your weight loss journey.
					</p>
					<button class="btn btnCustom-primary">View Guide</button>
				</div>
			</div>
			<!-- guide banner end -->
		</div>
	</div>

	<!-- guide section -->
	<div class="container-fluid pt-5 bg-main2 pb-4">
		<div class="container">
			<div class="row g-3">
				<div class="col-md-6">
					<p class="mainCustom-heading">See what's <span>possible for you</span></p>
					<p class="subCustom-text">
						Based on customer data, Ritecare clients who follow the programme lose an average of
						<strong>10% of their body weight in 12 months</strong>. See what's possible for you.
					</p>
				</div>
				<div class="col-md-6">
					<div class="card-slider">
						<p class="text-center font-s">Drag the slider to your start weight</p>
						<p class="text-center font-s1" id="weightText">60kg</p>
						<div class="px-4 my-2">
							<div class="slider-container" id="sliderContainer">
								<div class="slider-fill" id="sliderFill"></div>
								<div class="slider-thumb" id="sliderThumb"></div>
							</div>
						</div>
						<div class="lose">
							<p class="text-center font-s3">In one year, you could lose up to:</p>
							<p id="lossValue" class="font-s4">0kg</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Modal -->
	<div class="modal fade" id="weightModal" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content p-4 rounded-4 shadow-lg">
				<button type="button" class="btn-close position-absolute top-2 end-2" data-bs-dismiss="modal" aria-label="Close"></button>
				<div class="text-center">
					<h4 class="modal-title mb-3 fw-bold">Great!</h4>
					<p class="mb-4">You are ready to see your eligibility for treatment based on your start weight.</p>
					<button type="button" class="btn btn-primary btn-lg" id="modalConfirm">Go to Eligibility</button>
				</div>
			</div>
		</div>
	</div>


	<!-- how it works section -->
	<div class="container-fluid pt-5 bg-sec pb-4">
		<div class="container">
			<p class="text-center mainCustom-heading">How It <span>Works</span></p>
			<p class="subCustom-text text-center">
				Our secure, proven process connects you with the medical care you need — fast.
			</p>

			<div class="row g-4 mt-2">
				<!-- Step 1 -->
				<div class="col-md-4">
					<div class="cardCustom mt-4">
						<div class="cardCustom-image">
							<img
								src="<?php echo base_url('assets/images/w1.png'); ?>"
								alt="Online Consultation"
								class="img-fluid rounded w-100" />
						</div>
						<h3 class="cardCustom-title mt-3">1. Start an online consultation</h3>
						<p class="cardCustom-subtext mb-0">
							Complete a private medical questionnaire online. No waiting lists or face-to-face appointments required.
						</p>
						<!-- 
						<div class="d-flex justify-content-start">
							<a href="#" class="learnMore-link mt-2 text-center">Learn More</a>
						</div> -->
					</div>
				</div>

				<!-- Step 2 -->
				<div class="col-md-4">
					<div class="cardCustom mt-4">
						<div class="cardCustom-image">
							<img
								src="<?php echo base_url('assets/images/w2.png'); ?>"
								alt="Clinician Approval"
								class="img-fluid rounded w-100" />
						</div>
						<h3 class="cardCustom-title mt-3">2. Get clinician approval</h3>
						<p class="cardCustom-subtext mb-0">
							A UK-licensed prescriber reviews your information and issues a prescription for the most suitable treatment, if approved.
						</p>

						<!-- <div class="d-flex justify-content-start">
							<a href="#" class="learnMore-link mt-2 text-center">Learn More</a>
						</div> -->
					</div>
				</div>

				<!-- Step 3 -->
				<div class="col-md-4">
					<div class="cardCustom mt-4">
						<div class="cardCustom-image">
							<img
								src="<?php echo base_url('assets/images/w3.png'); ?>"
								alt="Discreet Delivery"
								class="img-fluid rounded w-100" />
						</div>
						<h3 class="cardCustom-title mt-3">3. Receive discreet delivery</h3>
						<p class="cardCustom-subtext mb-0">
							Your treatment is shipped quickly and directly to your home in a temperature-controlled, plain package for maximum discretion.
						</p>
						<!-- 
						<div class="d-flex justify-content-start">
							<a href="#" class="learnMore-link mt-2 text-center">Learn More</a>
						</div> -->
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Clients Section -->
	<div class="container-fluid pt-5 bg-main pb-4">
		<div class="container">
			<p class="text-center mainCustom-heading">
				What Our <span>Clients Say</span>
			</p>
			<p class="subCustom-text text-center">
				Our clients' success speaks for itself — see their inspiring journeys.
			</p>

			<!-- Swiper -->
			<div class="swiper cardSwiper2 mt-4">
				<div class="swiper-wrapper">
					<!-- Slide 1 -->
					<div class="swiper-slide">
						<div class="testimonial-card">
							<!-- <div class="card-header">
								<img src="<?php echo base_url('assets/images/trust.png'); ?>" alt="Trustpilot logo" />
							</div> -->
							<p class="card-text">
								"The thing I like most is the aftercare. I get really helpful
								emails with tips and advice. After week one I'm 6lb down, so
								let's see where it takes me on my weight loss journey."
							</p>
							<p class="card-author">Sonia, weight loss customer</p>
						</div>
					</div>

					<!-- Slide 2 -->
					<div class="swiper-slide">
						<div class="testimonial-card">
							<!-- <div class="card-header">
								<img src="<?php echo base_url('assets/images/trust.png'); ?>" alt="Trustpilot logo" />
							</div> -->
							<p class="card-text">
								"Switching to Ritecare was the best decision I made. The online process was so simple, and I felt properly assessed by the clinician. I’ve lost 15kg in six months and finally feel like I have control. Highly recommend for their professionalism and speed."
							</p>
							<p class="card-author">— David K., Weight Loss Patient</p>
						</div>
					</div>

					<!-- Slide 3 -->
					<div class="swiper-slide">
						<div class="testimonial-card">
							<!-- <div class="card-header">
								<img src="<?php echo base_url('assets/images/trust.png'); ?>" alt="Trustpilot logo" />
							</div> -->
							<p class="card-text">
								"Had a few questions about my dosage and the clinical team responded in my secure account within hours. Knowing I have that expert backup makes the whole weight loss journey much easier. A truly trusted service."
							</p>
							<p class="card-author">— Sarah M., Verified Customer</p>
						</div>
					</div>

					<!-- Slide 4 -->
					<div class="swiper-slide">
						<div class="testimonial-card">
							<div class="card-header">
								<img src="<?php echo base_url('assets/images/trust.png'); ?>" alt="Trustpilot logo" />
							</div>
							<p class="card-text">
								"The consistent clinical guidance has made all the difference in achieving my weight loss goals."
							</p>
							<p class="card-author">— Daniel, Weight Loss Journey</p>
						</div>
					</div>
				</div>

				<!-- Navigation -->
				<div class="swiper-button-prev"></div>
				<div class="swiper-pagination"></div>
				<div class="swiper-button-next"></div>
			</div>
		</div>
	</div>



	<!-- The Science of Lasting Change -->
	<div class="container-fluid pt-5 bg-main2 pb-4">
		<div class="container">
			<p class="text-center mainCustom-heading">The Science of <span>Lasting Change</span></p>
			<p class="subCustom-text text-center">
				Our prescribed treatments target key biological pathways to help you control appetite and feel naturally satisfied.
			</p>

			<div class="row g-4 mt-2">
				<div class="col-md-4">
					<div class="cardCustom p-4 h-100">
						<h4 class="fw-bold mb-2">Control "Food Noise"</h4>
						<p class="cardCustom-subtext mb-0">
							These medications influence the satiety centres in your brain, helping to quiet persistent thoughts about food and reduce preoccupation with eating.
						</p>
					</div>
				</div>

				<div class="col-md-4">
					<div class="cardCustom p-4 h-100">
						<h4 class="fw-bold mb-2">Promote Sustained Fullness</h4>
						<p class="cardCustom-subtext mb-0">
							By gently slowing digestion, the treatment helps you feel full sooner and maintain that feeling for longer — reducing snacking and overeating.
						</p>
					</div>
				</div>

				<div class="col-md-4">
					<div class="cardCustom p-4 h-100">
						<h4 class="fw-bold mb-2">Stabilize Energy & Mood</h4>
						<p class="cardCustom-subtext mb-0">
							The medication helps regulate blood sugar levels, preventing the sharp peaks and drops that trigger hunger, fatigue, or mood swings.
						</p>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Our Pillars of Trust Section -->
	<div class="container-fluid pt-5 pb-5 bg-sec">
		<div class="container">
			<p class="text-center mainCustom-heading">
				Our <span>Pillars of Trust</span>
			</p>
			<p class="subCustom-text text-center mb-4">
				Our service is built on three core principles designed to ensure safety, reliability, and lasting results.
			</p>

			<div class="row g-4 mt-2">
				<!-- Pillar 1 -->
				<div class="col-md-4">
					<div class="cardCustom text-center p-4 h-100">
						<div class="cardCustom-image mb-3">
							<img src="<?php echo base_url('assets/images/trust1.jpg'); ?>" alt="Clinical Expertise" class="img-fluid rounded" />
						</div>
						<h3 class="cardCustom-title">UK-Licensed Clinical Expertise</h3>
						<p class="cardCustom-subtext">
							Every treatment and dosage recommendation is overseen by our team of GPhC-registered pharmacists and licensed prescribers.
							We ensure your treatment is safe, effective, and tailored to your health profile.
						</p>
					</div>
				</div>

				<!-- Pillar 2 -->
				<div class="col-md-4">
					<div class="cardCustom text-center p-4 h-100">
						<div class="cardCustom-image mb-3">
							<img src="<?php echo base_url('assets/images/trust2.png'); ?>" alt="Reliable Service" class="img-fluid rounded" />
						</div>
						<h3 class="cardCustom-title">Reliable Service</h3>
						<p class="cardCustom-subtext">
							All medications are dispensed from our UK pharmacy and delivered directly to your door in unbranded, temperature-controlled packaging — ensuring privacy and discretion.
						</p>
					</div>
				</div>

				<!-- Pillar 3 -->
				<div class="col-md-4">
					<div class="cardCustom text-center p-4 h-100">
						<div class="cardCustom-image mb-3">
							<img src="<?php echo base_url('assets/images/trust3.jpeg'); ?>" alt="Support and Monitoring" class="img-fluid rounded" />
						</div>
						<h3 class="cardCustom-title">Continuous Support & Monitoring</h3>
						<p class="cardCustom-subtext">
							We provide ongoing support, regular clinical monitoring, and educational resources throughout your journey — helping you stay on track safely and confidently.
						</p>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Safe and Secure Section -->
	<div class="container-fluid pt-5 pb-5 bg-main2">
		<div class="container">
			<p class="text-center mainCustom-heading">
				Safe and <span>Secure</span>
			</p>
			<p class="subCustom-text text-center mb-5">
				We're a UK-regulated service providing clinically proven weight-loss treatments, safely and confidentially.
			</p>

			<div class="row justify-content-center">
				<div class="col-lg-4 col-md-6">
					<div class="safeCard text-center p-4 h-100">
						<div class="safeCard-logo mb-3">
							<img src="<?php echo base_url('assets/images/general-pharma.png'); ?>" alt="General Pharmaceutical Council" />
						</div>
						<h5 class="safeCard-title">General Pharmaceutical Council</h5>
						<p class="safeCard-text">
							The GPhC regulates all UK Pharmacies to ensure that we meet the highest professional and clinical standards.
						</p>
						<a href="https://www.pharmacyregulation.org/registers/pharmacy/registrationnumber/9012633" class="safeCard-btn">Verify now</a>
					</div>
				</div>
			</div>
		</div>
	</div>


	<!-- FAQ section -->
	<div class="container-fluid pt-5 bg-sec pb-4">
		<div class="container">
			<p class="text-center mainCustom-heading">
				Frequently Asked <span>Questions</span>
			</p>
			<p class="subCustom-text text-center mb-4">
				Quick answers to common questions about our services and treatments.
			</p>

			<div class="row g-4 mt-2">
				<!-- Left Column -->
				<div class="col-md-6">
					<div class="accordion" id="faqAccordionLeft">

						<!-- Q1 -->
						<div class="accordion-item">
							<h2 class="accordion-header" id="headingOne">
								<button class="accordion-button" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
									Why has the price of Mounjaro changed?
								</button>
							</h2>
							<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
								data-bs-parent="#faqAccordionLeft">
								<div class="accordion-body">
									The company that makes Mounjaro, Eli Lilly, decided to increase the cost for all dose sizes in the UK.
									This was done to match the prices found in other European countries. We work to give you the best value
									while reflecting this change.
								</div>
							</div>
						</div>

						<!-- Q2 -->
						<div class="accordion-item">
							<h2 class="accordion-header" id="headingTwo">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
									Is Wegovy as effective as Mounjaro?
								</button>
							</h2>
							<div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
								data-bs-parent="#faqAccordionLeft">
								<div class="accordion-body">
									Both Wegovy (Semaglutide) and Mounjaro (Tirzepatide) work well for weight loss. However, studies often
									show that Mounjaro helps people lose more weight on average. This is because Mounjaro affects two ways
									your body manages hunger, while Wegovy mainly affects one.
								</div>
							</div>
						</div>

						<!-- Q3 -->
						<div class="accordion-item">
							<h2 class="accordion-header" id="headingThree">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
									Do Wegovy & Mounjaro have similar effects?
								</button>
							</h2>
							<div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
								data-bs-parent="#faqAccordionLeft">
								<div class="accordion-body">
									Yes, they work in similar ways. Both medications help you feel less hungry, stop strong food cravings,
									and feel full for longer after you eat. They also have similar small side effects, like upset stomachs at
									the start.
								</div>
							</div>
						</div>

						<!-- Q4 -->
						<div class="accordion-item">
							<h2 class="accordion-header" id="headingFour">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
									Does Wegovy have additional benefits?
								</button>
							</h2>
							<div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
								data-bs-parent="#faqAccordionLeft">
								<div class="accordion-body">
									Wegovy has one very important extra benefit. It is the first weight loss shot that has been proven to
									lower the chance of serious heart issues (like heart attacks) for people who already have heart disease.
								</div>
							</div>
						</div>

					</div>
				</div>

				<!-- Right Column -->
				<div class="col-md-6">
					<div class="accordion" id="faqAccordionRight">

						<!-- Q5 -->
						<div class="accordion-item">
							<h2 class="accordion-header" id="headingFive">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
									Can I switch from Mounjaro to Wegovy?
								</button>
							</h2>
							<div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
								data-bs-parent="#faqAccordionRight">
								<div class="accordion-body">
									You can switch, but this must always be managed by a medical expert like your RiteCare prescriber. If you
									are thinking about changing, just let us know. We will safely guide you through the process and the
									correct new dose.
								</div>
							</div>
						</div>

						<!-- Q6 -->
						<div class="accordion-item">
							<h2 class="accordion-header" id="headingSix">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
									How much weight can I lose?
								</button>
							</h2>
							<div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
								data-bs-parent="#faqAccordionRight">
								<div class="accordion-body">
									How much you lose depends on your body and how much you stick to healthy eating and exercise. People
									using these modern treatments often see great results, typically losing between 15% and over 20% of their
									starting body weight during their treatment time.
								</div>
							</div>
						</div>

						<!-- Q7 -->
						<div class="accordion-item">
							<h2 class="accordion-header" id="headingSeven">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
									Is my BMI suitable?
								</button>
							</h2>
							<div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven"
								data-bs-parent="#faqAccordionRight">
								<div class="accordion-body">
									This treatment is usually right for adults who have a BMI of 30 or higher. You may also qualify if your
									BMI is 27 or higher and you have other health issues linked to your weight (like high blood pressure). We
									check your exact suitability during your private online review.
								</div>
							</div>
						</div>

						<!-- Q8 -->
						<div class="accordion-item">
							<h2 class="accordion-header" id="headingEight">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
									Do I need to sign up to a subscription?
								</button>
							</h2>
							<div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight"
								data-bs-parent="#faqAccordionRight">
								<div class="accordion-body">
									No, there is no need to sign up for any kind of automatic contract. You simply pay for your medicine one
									month at a time. This allows you to stay in charge and order your next supply only when you feel ready to
									keep going.
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>

	<script>
		document.addEventListener("DOMContentLoaded", function() {
			const sliderContainer = document.getElementById("sliderContainer");
			const sliderFill = document.getElementById("sliderFill");
			const sliderThumb = document.getElementById("sliderThumb");
			const weightText = document.getElementById("weightText");
			const lossValue = document.getElementById("lossValue");

			const minWeight = 60;
			const maxWeight = 150;
			const averageLossPercent = 12;

			let dragTimeout;

			sliderThumb.onmousedown = startDrag;
			sliderThumb.ontouchstart = startDrag;

			function startDrag(e) {
				e.preventDefault();
				document.onmousemove = doDrag;
				document.ontouchmove = doDrag;
				document.onmouseup = stopDrag;
				document.ontouchend = stopDrag;
			}

			function doDrag(e) {
				const rect = sliderContainer.getBoundingClientRect();
				let x = (e.clientX || e.touches[0].clientX) - rect.left;
				x = Math.max(0, Math.min(x, rect.width));
				const percent = x / rect.width;

				sliderFill.style.width = (percent * 100) + "%";
				sliderThumb.style.left = (percent * 100) + "%";

				const newWeight = Math.round(minWeight + percent * (maxWeight - minWeight));
				weightText.textContent = newWeight + "kg";

				const expectedLoss = Math.round(newWeight * (averageLossPercent / 100));
				lossValue.textContent = expectedLoss + "kg";

				clearTimeout(dragTimeout);
				dragTimeout = setTimeout(showModal, 500);
			}

			function stopDrag() {
				document.onmousemove = null;
				document.onmouseup = null;
				document.ontouchmove = null;
				document.ontouchend = null;
			}

			function showModal() {
				const modalEl = document.getElementById("weightModal");
				const modal = new bootstrap.Modal(modalEl);
				modal.show();

				document.getElementById("modalConfirm").onclick = function() {
					window.location.href = "<?php echo base_url('home/eligibility'); ?>";
				};
			}
		});
	</script>

	<style>
		/* Consistent Card Image Styling */
		.cardCustom-image {
			width: 100%;
			height: 220px;
			overflow: hidden;
			border-radius: 15px;
			display: flex;
			justify-content: center;
			align-items: center;
			background-color: #f8f9fa;
		}

		.cardCustom-image img {
			width: 100%;
			height: 100%;
			object-fit: cover;
			transition: transform 0.3s ease;
		}

		.cardCustom:hover .cardCustom-image img {
			transform: scale(1.05);
		}

		/* ===== Section Background ===== */
		.bg-main2 {
			background: #f7faff;
		}

		.mainCustom-heading {
			font-size: 2.2rem;
			font-weight: 700;
			color: #0d2a5a;
		}

		.mainCustom-heading span {
			color: #0d6efd;
		}

		.subCustom-text {
			color: #555;
			font-size: 1.05rem;
			max-width: 650px;
			margin: 0 auto;
		}

		/* ===== Safe Card Styling ===== */
		.safeCard {
			background: #fff;
			border-radius: 16px;
			box-shadow: 0 3px 10px rgba(0, 0, 0, 0.08);
			transition: transform 0.3s ease, box-shadow 0.3s ease;
			padding: 2rem;
		}

		.safeCard:hover {
			transform: translateY(-6px);
			box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
		}

		.safeCard-logo {
			height: 100px;
			display: flex;
			align-items: center;
			justify-content: center;
			background: #f8f9fa;
			border-radius: 12px;
			overflow: hidden;
			margin-bottom: 1.5rem;
		}

		.safeCard-logo img {
			max-height: 80px;
			width: auto;
			object-fit: contain;
			transition: transform 0.4s ease;
		}

		.safeCard:hover .safeCard-logo img {
			transform: scale(1.05);
		}

		.safeCard-title {
			font-weight: 600;
			color: #0d2a5a;
			margin-bottom: 12px;
			font-size: 1.25rem;
		}

		.safeCard-text {
			color: #444;
			font-size: 0.95rem;
			line-height: 1.6;
			min-height: 90px;
		}

		.safeCard-btn {
			display: inline-block;
			margin-top: 14px;
			padding: 8px 22px;
			border: 2px solid #0d6efd;
			border-radius: 25px;
			color: #0d6efd;
			text-decoration: none;
			font-weight: 500;
			font-size: 0.95rem;
			transition: all 0.3s ease;
		}

		.safeCard-btn:hover {
			background: #0d6efd;
			color: #fff;
		}

		/* ===== Animation ===== */
		.safeCard {
			opacity: 0;
			transform: translateY(30px);
			animation: fadeInUp 0.8s ease forwards;
			animation-delay: 0.3s;
		}

		@keyframes fadeInUp {
			from {
				opacity: 0;
				transform: translateY(30px);
			}

			to {
				opacity: 1;
				transform: translateY(0);
			}
		}

		/* ===== Responsive ===== */
		@media (max-width: 768px) {
			.safeCard {
				padding: 1.5rem;
			}

			.safeCard-logo {
				height: 80px;
			}

			.safeCard-logo img {
				max-height: 60px;
			}

			.safeCard-title {
				font-size: 1.1rem;
			}

			.safeCard-text {
				font-size: 0.9rem;
			}
		}
	</style>

	<script>
		// Treatment Cards Swiper
		const swiper = new Swiper(".cardSwiper", {
			slidesPerView: 4,
			spaceBetween: 20,
			loop: true,
			pagination: {
				el: ".swiper-pagination",
				clickable: true,
			},
			navigation: {
				nextEl: ".swiper-button-next",
				prevEl: ".swiper-button-prev",
			},
			breakpoints: {
				320: {
					slidesPerView: 1,
					spaceBetween: 10
				},
				576: {
					slidesPerView: 1,
					spaceBetween: 15
				},
				768: {
					slidesPerView: 2,
					spaceBetween: 15
				},
				992: {
					slidesPerView: 3,
					spaceBetween: 20
				},
				1200: {
					slidesPerView: 4,
					spaceBetween: 20
				}
			},
		});

		// Testimonials Swiper
		const swiper2 = new Swiper(".cardSwiper2", {
			slidesPerView: 2,
			spaceBetween: 20,
			loop: true,
			pagination: {
				el: ".swiper-pagination",
				clickable: true,
			},
			navigation: {
				nextEl: ".swiper-button-next",
				prevEl: ".swiper-button-prev",
			},
			breakpoints: {
				320: {
					slidesPerView: 1,
					spaceBetween: 10
				},
				576: {
					slidesPerView: 1,
					spaceBetween: 15
				},
				768: {
					slidesPerView: 1,
					spaceBetween: 15
				},
				992: {
					slidesPerView: 2,
					spaceBetween: 20
				}
			},
		});
	</script>
</main>