<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Carriers extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('customer_model');
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['carriers'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "driver");
		$this->template->template_render('carriers', $data);
	}

	public function carrierdetails()
	{
		$id = $this->uri->segment(3);
		
		$data['carrier'] = $this->common->readdatadocument("Users", $id);
		$vehicleId = $data['carrier']['vehicleId'];
		if($vehicleId) {
		$vehicle = $this->common->readdatadocument("Vehicle", $vehicleId);
		
		$data['carrier']['vehicle'] = $vehicle;
		}
		$this->template->template_render('carrier_details', $data);
	}

	
	public function suspendCarrier()
	{
		$data["id"] = $this->uri->segment(3);
		$data["isActive"] = false;
		$this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Carrier Suspended');
		redirect(base_url().'agents');
	}

	public function unSuspendCarrier()
	{
		$data["id"] = $this->uri->segment(3);
		$data["isActive"] = true;
		$this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Carrier Activated');
		redirect(base_url().'agents');
	}

	public function deleteCarrier()
	{
		$firebase = $this->firebase->init();
		$auth = $firebase->createAuth();

		$data["id"] = $this->uri->segment(3);
		$auth->deleteUser($data["id"]);
		$this->common->deletedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Carrier Deleted');
		redirect(base_url().'agents');
	}

	public function addcompany()
	{
		$this->template->template_render('company_add');
	}
	public function editagent()
	{
		$id = $this->uri->segment(3);

		$data['company'] = $this->common->readdatadocument("Users", $id);
		
		$this->template->template_render('company_add', $data);
	}

	public function userreset()
	{
		$this->template->template_render('user_reset_credentials');
	}

	public function insertcompany()
	{
		$data = $this->input->post();
		$data["role"] = "agent";
		
		$response = $this->customer_model->add_customer($data);
		
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New Agent added successfully');
			redirect(base_url().'agents');
		} else {
			$errormsg = 'Error! Email address already exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'agents/addagent');
		}
	}

	public function updatecompany()
	{
		$data = $this->input->post();
		$response = $this->customer_model->update_customer($data);
		
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Company Updated successfully');
			redirect(base_url().'agents');
		} else {
			$errormsg = 'Error! Some data is not correct.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'agents/editagent/'.$data['id']);
		}
	}


	public function updatecustomerdata($type, $id)
	{
		$da = $this->input->post();
		//print_r($da);
		if ($da['password'] != "" && $da['password'] != NULL) {
			$flag = $this->customer_model->update_customerpassword($id, $da['password']);

			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'some thing went wrong Please try again.');

				if ($type == "customer") {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				} else {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				}
			}
		} else {
			$data['fullname'] = $da['fullname'];
			$data['email'] = $da['email'];
			$data['userName'] = $da['userName'];
			$data['userPhone'] = $da['userPhone'];
			$this->common->updatedatamodel("Users", $id, $data);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}

		if ($da['old_email'] != $da['email']) {
			$flag = $this->customer_model->update_customeremail($id, $da['email']);

			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'some thing went wrong Please try again.');

				if ($type == "customer") {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				} else {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				}
			}
		} else {
			$data['fullname'] = $da['fullname'];
			$data['email'] = $da['email'];
			$data['userName'] = $da['userName'];
			$data['userPhone'] = $da['userPhone'];
			$this->common->updatedatamodel("Users", $id, $data);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}

		if ($type == "customer") {
			redirect('customer/editcustomer/' . $type . '/' . $id);
		} else {
			redirect('customer/editcustomer/' . $type . '/' . $id);
		}
	}

	public function editcustomer()
	{
		$type = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$data['id'] = $id;
		$data['type'] = $type;
		$data['customerdetails'] = $this->common->readdatadocument("Users", $id);
		$this->template->template_render('editcustomer', $data);
	}

	public function resetCustomer()
	{
		// $data = $this->input->post();
		foreach ($_POST as $key => $val) {
			if (strpos($key, "new") === 0) {
				$name = substr($key, 3);
				$data["new"][$name] = $val;
			}
		}
		foreach ($_POST as $key => $val) {
			if (strpos($key, "old") === 0) {
				$name = substr($key, 3);
				$data["old"][$name] = $val;
			}
		}
		// print_r($data);
		// exit;
		$response = $this->customer_model->update_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Customer updated successfully.');
			redirect('customer');
		} else {
			$errormsg = 'Error! Something went Wrong. Either the user does not exist or password does not match.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/userreset');
		}
	}

	public function updatecustomer()
	{
		$testxss = xssclean($_POST);
		if ($testxss) {
			$response = $this->customer_model->update_customer($this->input->post());
			if ($response) {
				$this->session->set_flashdata('successmessage', 'Customer updated successfully..');
				redirect('customer');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				redirect('customer');
			}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('customer');
		}
	}
}