<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Customer extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		//	 $this->load->database();
		$this->load->model('customer_model');
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['customerlist'] = $this->common->readdatafromcollectionwhereclause("Users");
		$this->template->template_render('customer_management', $data);
	}

	public function vendors()
	{
		$data['customerlist'] = $this->common->readdatafromcollectionwhereclause("Users", "userType", "=", "Pro");
		$this->template->template_render('vendor_management', $data);
	}


	public function suspendCustomer()
	{
		$data["id"] = $this->uri->segment(3);
		$data["active"] = false;
		$response = $this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'User Suspended');
		redirect('customer');
	}

	public function unSuspendCustomer()
	{
		$data["id"] = $this->uri->segment(3);
		$data["active"] = true;
		$response = $this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'User Activated');
		redirect('customer');
	}

	public function deleteCustomer()
	{
		$data["id"] = $this->uri->segment(3);
		$data["active"] = true;
		$response = $this->common->deletedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'User Deleted');
		redirect('customer');
	}

	public function addcustomer()
	{
		$this->template->template_render('customer_add');
	}
	public function addvendor()
	{
		$this->template->template_render('addvendor');
	}

	//editcustomer
	public function editcustomers($id)
	{


		$data['id'] = $id;

		$data["customerdetails"] = $this->common->readdatadocument("Users", $id);

		$this->template->template_render('editcustomer', $data);
	}
	public function userreset()
	{
		$this->template->template_render('user_reset_credentials');
	}

	public function insertcustomer()
	{
		$data = $this->input->post();
		$data["userType"] = "User";
		$userId = time();
		$response = $this->customer_model->add_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New User added successfully');
			redirect('customer');
		} else {
			$errormsg = 'Error! User already Exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/addcustomer');
		}
	}
	public function insertvendors()
	{
		// $firebase = $this->firebase->init();
		// $storage = $firebase->createStorage();
		// $defaultBucket = $storage->getBucket();

		$data = $this->input->post();
		$data["userType"] = "Pro";
		$data['isActive'] = "0";

		// if ($_FILES['document']['tmp_name'] != '') {
		// 	$uploadedFile = $defaultBucket->upload(
		// 		file_get_contents($_FILES['document']['tmp_name']),
		// 		[
		// 			'name' => "document" . rand() . time() . $_FILES['document']['name'],
		// 		]
		// 	);
		// 	$data['document'] = $uploadedFile->info()['mediaLink'];
		// }

		$response = $this->customer_model->add_customer($data);
		// exit;
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New Vendor added successfully');
			redirect('customer/vendors');
		} else {
			$errormsg = 'Error! Email Invalid or already in use.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/addvendor');
		}
	}



	public function vendorapproved($id)
	{
		$data['isActive'] = "1";
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Users has been approved successfully');

		redirect('customer/vendors');
	}


	public function updatecustomerdata($type, $id)
	{
		$da = $this->input->post();
		//print_r($da);
		if ($da['password'] != "" && $da['password'] != NULL) {
			$flag = $this->customer_model->update_customerpassword($id, $da['password']);

			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'some thing went wrong Please try again.');

				if ($type == "customer") {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				} else {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				}
			}
		} else {
			$data['fullname'] = $da['fullname'];
			$data['email'] = $da['email'];
			$data['userName'] = $da['userName'];
			$data['userPhone'] = $da['userPhone'];
			$this->common->updatedatamodel("Users", $id, $data);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}

		if ($da['old_email'] != $da['email']) {
			$flag = $this->customer_model->update_customeremail($id, $da['email']);

			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'some thing went wrong Please try again.');

				if ($type == "customer") {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				} else {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				}
			}
		} else {
			$data['fullname'] = $da['fullname'];
			$data['email'] = $da['email'];
			$data['userName'] = $da['userName'];
			$data['userPhone'] = $da['userPhone'];
			$this->common->updatedatamodel("Users", $id, $data);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}

		if ($type == "customer") {
			redirect('customer/editcustomer/' . $type . '/' . $id);
		} else {
			redirect('customer/editcustomer/' . $type . '/' . $id);
		}
	}

	public function editcustomer()
	{
		$type = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$data['id'] = $id;
		$data['type'] = $type;
		$data['customerdetails'] = $this->common->readdatadocument("Users", $id);
		$this->template->template_render('editcustomer', $data);
	}

	public function resetCustomer()
	{
		// $data = $this->input->post();
		foreach ($_POST as $key => $val) {
			if (strpos($key, "new") === 0) {
				$name = substr($key, 3);
				$data["new"][$name] = $val;
			}
		}
		foreach ($_POST as $key => $val) {
			if (strpos($key, "old") === 0) {
				$name = substr($key, 3);
				$data["old"][$name] = $val;
			}
		}
		// print_r($data);
		// exit;
		$response = $this->customer_model->update_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Customer updated successfully.');
			redirect('customer');
		} else {
			$errormsg = 'Error! Something went Wrong. Either the user does not exist or password does not match.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/userreset');
		}
	}

	public function updatecustomer()
	{
		$testxss = xssclean($_POST);
		if ($testxss) {
			$response = $this->customer_model->update_customer($this->input->post());
			if ($response) {
				$this->session->set_flashdata('successmessage', 'Customer updated successfully..');
				redirect('customer');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				redirect('customer');
			}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('customer');
		}
	}
}