<?php
defined('BASEPATH') or exit('No direct script access allowed');

class News extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->model('common');
    $this->load->helper(array('form', 'url', 'string'));
    $this->load->library('form_validation');
    $this->load->library('session');
  }

  public function index()
  {
    $data["allnews"] = $this->common->readdatafromcollectionwhereclause("News");
    
    $this->template->template_render('news', $data);
  }
  

  public function addnews()
  {
    $this->template->template_render('news_add');
  }

  public function insertnews()
  {

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $data = $this->input->post();

    if ($_FILES['image']['tmp_name'] != '') {
      $fileName = "newsImage" . rand() . time() . $_FILES['image']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['image']['tmp_name']),
        [
          'name' => $fileName,
        ]
      );
      $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.$fileName.'?alt=media';
    }

    if (isset($_POST)) {
      $newsId = time();
      $data["newsId"] = (string)$newsId;
      $data["timestamp"] = $newsId;
      $response = $this->common->adddatamodel("News", $newsId, $data);
      if ($response) {
        $this->session->set_flashdata('successmessage', 'News added successfully..');
      } else {
        $this->session->set_flashdata('warningmessage', 'Error in creating news');
      }
      redirect(base_url().'news');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your inputs are not valid.Please try again');
      redirect(base_url().'news');
    }
  }

  public function editnews()
  {
    $id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['news'] = $this->common->readdatadocument("News", $id);
    $this->template->template_render('news_add', $data);
  }

  public function delete()
  {
    $id = $this->uri->segment(3);
    $response = $this->common->deletedatamodel("News", $id);
    if ($response) {
      $this->session->set_flashdata('successmessage', 'News deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error in deleting news..');
    }
    redirect(base_url().'news');
  }

  public function updatenews()
  {
    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $data = $this->input->post();
    $id = $data['id'];
    if ($_FILES['image']['tmp_name'] != '') {
      $fileName = "newsImage" . rand() . time() . $_FILES['image']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['image']['tmp_name']),
        [
          'name' => $fileName,
        ]
      );
      $data['imageUrl'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.$fileName.'?alt=media';
    }
    if (isset($_POST)) {
      $response = $this->common->updatedatamodel("News", $id, $data);
      if ($response) {
        $this->session->set_flashdata('successmessage', 'News updated successfully..');
        redirect(base_url().'news');
      } else {
        $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
        redirect(base_url().'news');
      }
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your inputs are not valid.Please try again');
      redirect(base_url().'news');
    }
  }

}