<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Settings extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->model('common');
    $this->load->helper(array('form', 'url', 'string'));
    $this->load->library('form_validation');
    $this->load->library('session');
  }

  public function index()
  {
    $settings = $this->common->readdatafromcollectionwhereclause("Settings");
    $arrKeys = array_keys($settings);
    $key = $arrKeys[0];
    $data["settings"] = $settings[$key];
    $this->template->template_render('settings', $data);
  }
  

  public function save()
  {
    $data = $this->input->post();
    if (isset($_POST)) {
      $response = $this->common->updatedatamodel("Settings", $data["id"], $data);
      if ($response) {
        $this->session->set_flashdata('successmessage', 'Settings updated successfully..');
        redirect(base_url().'settings');
      } else {
        $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
        redirect(base_url().'settings');
      }
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
      redirect(base_url().'settings');
    }
  }
}