<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Admin extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		// $this->load->database();
		$this->load->model('customer_model');
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['admins'] = $this->common->readdatafromcollectionwhereclause("Admins");
		$data['active'] = 'admin';
		$this->template->template_render('admins', $data);
	}

	public function addAdmin()
	{
		$data['active'] = 'admin';
		$this->template->template_render('adminadd', $data);
	}
	//editcustomer
	
	public function insertadmin()
	{
		$firebase = $this->firebase->init();
		$auth = $firebase->createAuth();
		
		$post = $this->input->post();
		// var_dump($post);die;
		

		$isUserExists = $this->common->readdatafromcollectionwhereclause("Admins", 'email', '=', $post['email']);
		if($isUserExists){
			$errormsg = 'Error! User already exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url('admin/addAdmin'));
			exit;
		}

		$data = [
			'email' => $post['email'],
			'emailVerified' => true,
			'password' => $post['password'],
			'displayName' => $post['name'],
			'disabled' => false,
		];

		$post['isActive'] = true;

		$createdUser = $auth->createUser($data);
		$response = $this->common->adddatamodel('Admins', $createdUser->uid, $post);


		if ($response) {
			$this->session->set_flashdata('successmessage', 'New Admin user added successfully');
			redirect(base_url('admin'));
		} else {
			$errormsg = 'Error! Please check your data and try again.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url('admin/addAdmin'));
		}
	}

	public function editAdmin()
	{
		$uid = $this->uri->segment(3);
		$data['admin'] = $this->common->readdatadocument('Admins', $uid);
		$data['id'] = $uid;
		$data['active'] = 'admin';
		$this->template->template_render('adminadd', $data);
	}

	public function updateadmin()
	{
		$post = $this->input->post();
		
		$firebase = $this->firebase->init();
		$auth = $firebase->createAuth();
		$data = [
			'displayName' => $post['name'],
			'email' => $post['email'],
			'password' => $post['password'],
		];
		$auth->updateUser($post['id'], $data);

		
		$response = $this->common->updatedatamodel("Admins", $post['id'], $post);

		if ($response) {
			$this->session->set_flashdata('successmessage', 'Admin user updated successfully');
			redirect(base_url('admin'));
		} else {
			$errormsg = 'Error! Admin data cannot be upated.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url('admin'));
		}
	}


	public function deleteAdmin()
	{
		$id = $this->uri->segment(3);
		$firebase = $this->firebase->init();
		$auth = $firebase->createAuth();
		$auth->deleteUser($id);

		$response = $this->common->deletedatamodel('Admins', $id);
		
		if (!$response) {
			$this->session->set_flashdata('warningmessage', 'Something went wrong while deleting admin.');
		}else{

			$this->session->set_flashdata('successmessage', 'Admin Deleted');
		}
		redirect(base_url().'admin');
	}

	
	public function suspendCustomer()
	{
		$id = $this->uri->segment(3);
		$data["isActive"] = false;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Admin Suspended');
		redirect(base_url().'admin');
	}

	public function unSuspendCustomer()
	{
		$id = $this->uri->segment(3);
		
		$data["isActive"] = true;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Admin Activated');
		redirect(base_url().'admin');
	}
}