<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('data_model');
    $this->load->model('common');
  }
  public function chartData($range = 'day')
    {
        $data = $this->data_model->get_dummy_data($range);
        echo json_encode($data);
    }
  public function live()
  {
    $data["orders"] = [];
    $data["rides"] = [];
    
    
    $this->template->template_render('live', $data);
  }
  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    
    
    $this->template->template_render('settings', $data);
  }
  public function restaurants()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["restaurants"] = [];
    $data["active"] = 'restaurants';
    
    
    $this->template->template_render('restaurants', $data);
  }
  public function lostfound()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["restaurants"] = [];
    $data["active"] = 'lostfound';
    
    
    $this->template->template_render('lostfound', $data);
  }
   public function wallet()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["wallet"] = [];
    $data["active"] = 'wallet';
    
    
    $this->template->template_render('wallet', $data);
  }

  public function transactions()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["wallet"] = [];
    $data["active"] = 'wallet';
    
    
    $this->template->template_render('transactions', $data);
  }
  public function usersh()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["wallet"] = [];
    $data["active"] = 'dashboard';
    
    
    $this->template->template_render('usersh', $data);
  }

  public function resprofile()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["wallet"] = [];
    $data["active"] = 'restaurants';
    
    
    $this->template->template_render('resprofile', $data);
  }
   public function userprofile()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["wallet"] = [];
    $data["active"] = 'customer';
    
    
    $this->template->template_render('userprofile', $data);
  }
  public function foprofile()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["wallet"] = [];
    $data["active"] = 'fleetowners';
    
    
    $this->template->template_render('foprofile', $data);
  }
    public function driverprofile()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["wallet"] = [];
    $data["active"] = 'drivers';
    
    
    $this->template->template_render('driverprofile', $data);
  }
    public function riderprofile()
  {
    // $data["restaurants"] = $this->common->readdatafromcollectionbetween("Restaurants");
    $data["wallet"] = [];
    $data["active"] = 'riders';
    
    
    $this->template->template_render('riderprofile', $data);
  }
  
   public function categories()
	{

    $data['categories'] = $this->common->readdatafromcollectionwhereclause('Categories');
    $data["active"] = 'categories';
		$this->template->template_render('categories', $data);
	}
  public function insertcategory()
	{
		
		$post = $this->input->post();
    $data['title'] = $post['title'];

    
    $response = $this->common->addnewdatamodel('Categories', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));		
	}
	public function editcategory()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
		$data['category'] = $this->common->readdatadocument('Categories', $id);
		$this->template->template_render('addcategory', $data);
	}

	public function updatecategory()
	{
    $post = $this->input->post();
    $data['title'] = $post['title'];

		$response = $this->common->updatedatamodel('Categories', $post['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
	}

  public function deletecategory()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Categories', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
	}
  public function menus()
	{

    // $data['categories'] = $this->common->readdatafromcollectionwhereclause('Menus');
		$data["menus"] = [];
    $data["active"] = 'menus';
		$this->template->template_render('menus', $data);
	}

    public function rides()
	{

    // $data['categories'] = $this->common->readdatafromcollectionwhereclause('Rides');
		$data["rides"] = [];
    $data["active"] = 'rides';
		$this->template->template_render('rides', $data);
	}
  public function orders()
	{

    // $data['categories'] = $this->common->readdatafromcollectionwhereclause('Orders');
		$data["orders"] = [];
    $data["active"] = 'orders';
		$this->template->template_render('orders', $data);
	}

  public function vehicles()
	{

    // $data['categories'] = $this->common->readdatafromcollectionwhereclause('Orders');
		$data["vehicles"] = [];
    $data["active"] = 'vehicles';
		$this->template->template_render('vehicles', $data);
	}
//t26OyQjNNZhOulNE3fwy
  public function userdetails($id=null)
  {
    // $data['meditation'] = null;
    // $data['id'] = '';

    // if($id){
    //   $data['meditation'] = $this->common->readdatadocument('Meditations', $id);
    //   $data['id'] = $id;
    // }

    // var_dump($data['music']);die;

    $this->template->template_render('userdetails');
  }
  public function userimages($id='t26OyQjNNZhOulNE3fwy')
  {
    
    $images = $this->common->readdatadocument('Settings', $id);
    $data['male_light'] = $images['male_light'][rand(0, count($images['male_light'])-1)];
    $data['male_light_count'] = count($images['male_light']);
    $data['male_tan'] = $images['male_tan'][rand(0, count($images['male_tan'])-1)];
    $data['male_tan_count'] = count($images['male_tan']);
    $data['male_dark'] = $images['male_dark'][rand(0, count($images['male_dark'])-1)];
    $data['male_dark_count'] = count($images['male_dark']);
    $data['female_light'] = $images['female_light'][rand(0, count($images['female_light'])-1)];
    $data['female_light_count'] = count($images['female_light']);
    $data['female_tan'] = $images['female_tan'][rand(0, count($images['female_tan'])-1)];
    $data['female_tan_count'] = count($images['female_tan']);
    $data['female_dark'] = $images['female_dark'][rand(0, count($images['female_dark'])-1)];
    $data['female_dark_count'] = count($images['female_dark']);
    
    $data['active'] = 'userimages';

    $this->template->template_render('userimages', $data);
  }

  public function deleteimages($type = null, $imgId = null)
  {
    if(!$type || !$imgId){
      redirect(base_url('dashboard/userimages'));
      exit;
    }

    $id='t26OyQjNNZhOulNE3fwy';
    $allImages = $this->common->readdatadocument('Settings', $id);
    $images = $allImages[$type];
    array_splice($images, $imgId, 1);

    $data[$type] = $images;
    // var_dump($data);die;

    $this->common->updatedatamodel('Settings', $id, $data);
    $this->session->set_flashdata('successmessage', 'Image deleted successfully..');
    redirect(base_url('dashboard/viewimages/'.$type));

  } 
  public function viewimages($type = null)
  {
    if(!$type){
      redirect(base_url('dashboard/userimages'));
      exit;
    }

    $id='t26OyQjNNZhOulNE3fwy';
    $allImages = $this->common->readdatadocument('Settings', $id);

    $data['images'] = $allImages[$type];
    $data['count'] = count($data['images']);
    
    $data['active'] = 'userimages';
    $data['type'] = $type;
    $data['label'] = ucwords(str_replace('_', ' ', $type));

    $this->template->template_render('viewimages', $data);
  }

  public function updateimages($type = null)
  {
    if(!$type){
      redirect(base_url('dashboard/userimages'));
      exit;
    }
    $id='t26OyQjNNZhOulNE3fwy';
    $images = $this->common->readdatadocument('Settings', $id);
    
    $data['active'] = 'userimages';
    $data['type'] = $type;
    $data['label'] = ucwords(str_replace('_', ' ', $type));

    $this->template->template_render('updateimages', $data);
  }

  public function fileupload(){
    echo json_encode(['files' => $_FILES]);
  }

  public function saveimages()
  {
    $id = 't26OyQjNNZhOulNE3fwy';
    $settings = $this->common->readdatadocument('Settings', $id);
    $images = array();

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();
    
    $male_light = array();
    if (
        isset($_FILES['male_light']['name'])
    ) {
      foreach($_FILES['male_light']['name'] as $key => $file){

        $file_name = 'UserImages/male_light-'.$key. uniqid();
          $uploadedFile = $defaultBucket->upload(
              file_get_contents($_FILES['male_light']['tmp_name'][$key]),
              [
                  'name' => $file_name,
                  'predefinedAcl' => 'publicRead'
              ]
          );
          if ($uploadedFile) {
              $male_light[$key] = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
          }
      } 
    }

    if(count($male_light) > 0){

      $images['male_light'] = array_merge($settings['male_light'], $male_light);
    }else{
      
      $images['male_light'] = $settings['male_light'];
    }

    

    $male_tan = array();
    if (
        isset($_FILES['male_tan']['name'])
    ) {
      foreach($_FILES['male_tan']['name'] as $key => $file){

        $file_name = 'UserImages/male_tan-'.$key. uniqid();
          $uploadedFile = $defaultBucket->upload(
              file_get_contents($_FILES['male_tan']['tmp_name'][$key]),
              [
                  'name' => $file_name,
                  'predefinedAcl' => 'publicRead'
              ]
          );
          if ($uploadedFile) {
              $male_tan[$key] = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
          }
      } 
    }

    if(count($male_tan) > 0){

      $images['male_tan'] = array_merge($settings['male_tan'], $male_tan);
    }else{
      
      $images['male_tan'] = $settings['male_tan'];
    }



    $male_dark = array();
    if (
        isset($_FILES['male_dark']['name'])
    ) {
      foreach($_FILES['male_dark']['name'] as $key => $file){

        $file_name = 'UserImages/male_dark-'.$key. uniqid();
          $uploadedFile = $defaultBucket->upload(
              file_get_contents($_FILES['male_dark']['tmp_name'][$key]),
              [
                  'name' => $file_name,
                  'predefinedAcl' => 'publicRead'
              ]
          );
          if ($uploadedFile) {
              $male_dark[$key] = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
          }
      } 
    }

    if(count($male_dark) > 0){

      $images['male_dark'] = array_merge($settings['male_dark'], $male_dark);
    }else{
      
      $images['male_dark'] = $settings['male_dark'];
    }



    $female_light = array();
    if (
        isset($_FILES['female_light']['name'])
    ) {
      foreach($_FILES['female_light']['name'] as $key => $file){

        $file_name = 'UserImages/female_light-'.$key. uniqid();
          $uploadedFile = $defaultBucket->upload(
              file_get_contents($_FILES['female_light']['tmp_name'][$key]),
              [
                  'name' => $file_name,
                  'predefinedAcl' => 'publicRead'
              ]
          );
          if ($uploadedFile) {
              $female_light[$key] = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
          }
      } 
    }

    if(count($female_light) > 0){

      $images['female_light'] = array_merge($settings['female_light'], $female_light);
    }else{
      
      $images['female_light'] = $settings['female_light'];
    }

    

    $female_tan = array();
    if (
        isset($_FILES['female_tan']['name'])
    ) {
      foreach($_FILES['female_tan']['name'] as $key => $file){

        $file_name = 'UserImages/female_tan-'.$key. uniqid();
          $uploadedFile = $defaultBucket->upload(
              file_get_contents($_FILES['female_tan']['tmp_name'][$key]),
              [
                  'name' => $file_name,
                  'predefinedAcl' => 'publicRead'
              ]
          );
          if ($uploadedFile) {
              $female_tan[$key] = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
          }
      } 
    }

    if(count($female_tan) > 0){

      $images['female_tan'] = array_merge($settings['female_tan'], $female_tan);
    }else{
      
      $images['female_tan'] = $settings['female_tan'];
    }



    $female_dark = array();
    if (
        isset($_FILES['female_dark']['name'])
    ) {
      foreach($_FILES['female_dark']['name'] as $key => $file){

        $file_name = 'UserImages/female_dark-'.$key. uniqid();
          $uploadedFile = $defaultBucket->upload(
              file_get_contents($_FILES['female_dark']['tmp_name'][$key]),
              [
                  'name' => $file_name,
                  'predefinedAcl' => 'publicRead'
              ]
          );
          if ($uploadedFile) {
              $female_dark[$key] = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
          }
      } 
    }

    if(count($female_dark) > 0){

      $images['female_dark'] = array_merge($settings['female_dark'], $female_dark);
    }else{
      
      $images['female_dark'] = $settings['female_dark'];
    }

    


    $this->common->updatedatamodel('Settings', $id, $images);

    // if ($response) {
    //   $this->session->set_flashdata('successmessage', 'Images updated successfully..');
    // } else {
    //   $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    // }

    // redirect(base_url('dashboard/userimages'));
    echo(json_encode(['files'=> $_FILES, 'images'=> $images]));
  }
  
  public function meditations()
  {
    $data["meditations"] = $this->common->readdatafromcollectionbetween("Meditations");
    $data['active'] = 'meditations';
    $this->template->template_render('meditations', $data);
  }

  public function addmeditation($id=null)
  {
    $data['meditation'] = null;
    $data['id'] = '';
    $data['active'] = 'meditations';

    if($id){
      $data['meditation'] = $this->common->readdatadocument('Meditations', $id);
      $data['id'] = $id;
    }

    // var_dump($data['music']);die;

    $this->template->template_render('addmeditation', $data);
  }

  public function insertmeditation()
  {
    $post = $this->input->post();
    $data['sessionNo'] = $post['sessionNo'];
    $data['congratsMessage'] = $post['congratsMessage'];
    $data['title'] = $post['title'];
    $data['regularXP'] = $post['regularXP'];
    $data['relistenXP'] = $post['relistenXP'];
    // $data['createdDate'] = time()*1000;
    // $data['isActive'] = true;

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();
    
    // $image = '';
    // if (
    //     isset($_FILES['image']) &&
    //     $_FILES['image']['error'] === UPLOAD_ERR_OK &&
    //     is_uploaded_file($_FILES['image']['tmp_name'])
    // ) {
    //     $file_name = 'Meditations/Images/image-' . time() . basename($_FILES['image']['name']);
    //     $uploadedFile = $defaultBucket->upload(
    //         file_get_contents($_FILES['image']['tmp_name']),
    //         [
    //             'name' => $file_name,
    //             'predefinedAcl' => 'publicRead'
    //         ]
    //     );
    //     if ($uploadedFile) {
    //         $image = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
    //     } else {
    //         throw new Exception("File upload failed! Firebase did not return a valid response.");
    //     }
    // }

    // $data['image'] = $image;

    $audio1 = '';
    if (
        isset($_FILES['audio1']) &&
        $_FILES['audio1']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio1']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio1-' . time() . basename($_FILES['audio1']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio1']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio1 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio1'] = $audio1;

    $audio2 = '';
    if (
        isset($_FILES['audio2']) &&
        $_FILES['audio2']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio2']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio2-' . time() . basename($_FILES['audio2']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio2']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio2 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio2'] = $audio2;

    $audio3 = '';
    if (
        isset($_FILES['audio3']) &&
        $_FILES['audio3']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio3']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio3-' . time() . basename($_FILES['audio3']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio3']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio3 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio3'] = $audio3;

    $response = $this->common->addnewdatamodel('Meditations', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Session added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/meditations'));
  }

  public function updatemeditation()
  {
    $post = $this->input->post();
    $id = $post['id'];
    $data['sessionNo'] = $post['sessionNo'];
    $data['congratsMessage'] = $post['congratsMessage'];
    $data['title'] = $post['title'];
    $data['regularXP'] = $post['regularXP'];
    $data['relistenXP'] = $post['relistenXP'];

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    
    // $image = '';
    // if (
    //     isset($_FILES['image']) &&
    //     $_FILES['image']['error'] === UPLOAD_ERR_OK &&
    //     is_uploaded_file($_FILES['image']['tmp_name'])
    // ) {
    //     $file_name = 'Meditations/Images/image-' . time() . basename($_FILES['image']['name']);
    //     $uploadedFile = $defaultBucket->upload(
    //         file_get_contents($_FILES['image']['tmp_name']),
    //         [
    //             'name' => $file_name,
    //             'predefinedAcl' => 'publicRead'
    //         ]
    //     );
    //     if ($uploadedFile) {
    //         $image = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
    //     } else {
    //         throw new Exception("File upload failed! Firebase did not return a valid response.");
    //     }
    // }

    // if($image){

    //   $data['image'] = $image;
    // }

    $audio1 = '';
    if (
        isset($_FILES['audio1']) &&
        $_FILES['audio1']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio1']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio1-' . time() . basename($_FILES['audio1']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio1']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio1 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio1){

      $data['audio1'] = $audio1;
    }

    $audio2 = '';
    if (
        isset($_FILES['audio2']) &&
        $_FILES['audio2']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio2']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio2-' . time() . basename($_FILES['audio2']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio2']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio2 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio2){

      $data['audio2'] = $audio2;
    }

    $audio3 = '';
    if (
        isset($_FILES['audio3']) &&
        $_FILES['audio3']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio3']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio3-' . time() . basename($_FILES['audio3']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio3']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio3 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio3){

      $data['audio3'] = $audio3;
    }

    $response = $this->common->updatedatamodel("Meditations", $id, $data);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Session has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/meditations'));
  }

  public function deleteMeditation()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Meditations', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Session deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/meditations'));
	}

  public function extrasessions()
  {
    $data["extrasessions"] = $this->common->readdatafromcollectionbetween("ExtraSessions");
    $data['active'] = 'extrasessions';
    $this->template->template_render('extrasessions', $data);
  }

  public function addextrasession($id=null)
  {
    $data['extrasession'] = null;
    $data['id'] = '';
    $data['active'] = 'extrasessions';

    if($id){
      $data['extrasession'] = $this->common->readdatadocument('ExtraSessions', $id);
      $data['id'] = $id;
    }

    // var_dump($data['music']);die;

    $this->template->template_render('addextrasession', $data);
  }

  public function insertextrasession()
  {
    $post = $this->input->post();
    $data['type'] = $post['type'];
    $data['congratsMessage'] = $post['congratsMessage'];
    $data['title'] = $post['title'];
    $data['regularXP'] = $post['regularXP'];
    $data['relistenXP'] = $post['relistenXP'];
    // $data['createdDate'] = time()*1000;
    // $data['isActive'] = true;

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();
    
    // $image = '';
    // if (
    //     isset($_FILES['image']) &&
    //     $_FILES['image']['error'] === UPLOAD_ERR_OK &&
    //     is_uploaded_file($_FILES['image']['tmp_name'])
    // ) {
    //     $file_name = 'ExtraSessions/Images/image-' . time() . basename($_FILES['image']['name']);
    //     $uploadedFile = $defaultBucket->upload(
    //         file_get_contents($_FILES['image']['tmp_name']),
    //         [
    //             'name' => $file_name,
    //             'predefinedAcl' => 'publicRead'
    //         ]
    //     );
    //     if ($uploadedFile) {
    //         $image = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
    //     } else {
    //         throw new Exception("File upload failed! Firebase did not return a valid response.");
    //     }
    // }

    // $data['image'] = $image;

    $audio1 = '';
    if (
        isset($_FILES['audio1']) &&
        $_FILES['audio1']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio1']['tmp_name'])
    ) {
        $file_name = 'ExtraSessions/Audios/audio1-' . time() . basename($_FILES['audio1']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio1']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio1 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio1'] = $audio1;

    $audio2 = '';
    if (
        isset($_FILES['audio2']) &&
        $_FILES['audio2']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio2']['tmp_name'])
    ) {
        $file_name = 'ExtraSessions/Audios/audio2-' . time() . basename($_FILES['audio2']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio2']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio2 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio2'] = $audio2;

    $audio3 = '';
    if (
        isset($_FILES['audio3']) &&
        $_FILES['audio3']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio3']['tmp_name'])
    ) {
        $file_name = 'ExtraSessions/Audios/audio3-' . time() . basename($_FILES['audio3']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio3']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio3 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio3'] = $audio3;

    $response = $this->common->addnewdatamodel('ExtraSessions', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Extra session added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/extrasessions'));
  }

  public function updateextrasession()
  {
    $post = $this->input->post();
    $id = $post['id'];
    $data['type'] = $post['type'];
    $data['congratsMessage'] = $post['congratsMessage'];
    $data['title'] = $post['title'];
    $data['regularXP'] = $post['regularXP'];
    $data['relistenXP'] = $post['relistenXP'];

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    
    // $image = '';
    // if (
    //     isset($_FILES['image']) &&
    //     $_FILES['image']['error'] === UPLOAD_ERR_OK &&
    //     is_uploaded_file($_FILES['image']['tmp_name'])
    // ) {
    //     $file_name = 'ExtraSessions/Images/image-' . time() . basename($_FILES['image']['name']);
    //     $uploadedFile = $defaultBucket->upload(
    //         file_get_contents($_FILES['image']['tmp_name']),
    //         [
    //             'name' => $file_name,
    //             'predefinedAcl' => 'publicRead'
    //         ]
    //     );
    //     if ($uploadedFile) {
    //         $image = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
    //     } else {
    //         throw new Exception("File upload failed! Firebase did not return a valid response.");
    //     }
    // }

    // if($image){

    //   $data['image'] = $image;
    // }

    $audio1 = '';
    if (
        isset($_FILES['audio1']) &&
        $_FILES['audio1']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio1']['tmp_name'])
    ) {
        $file_name = 'ExtraSessions/Audios/audio1-' . time() . basename($_FILES['audio1']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio1']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio1 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio1){

      $data['audio1'] = $audio1;
    }

    $audio2 = '';
    if (
        isset($_FILES['audio2']) &&
        $_FILES['audio2']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio2']['tmp_name'])
    ) {
        $file_name = 'ExtraSessions/Audios/audio2-' . time() . basename($_FILES['audio2']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio2']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio2 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio2){

      $data['audio2'] = $audio2;
    }

    $audio3 = '';
    if (
        isset($_FILES['audio3']) &&
        $_FILES['audio3']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio3']['tmp_name'])
    ) {
        $file_name = 'ExtraSessions/Audios/audio3-' . time() . basename($_FILES['audio3']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio3']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio3 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio3){

      $data['audio3'] = $audio3;
    }

    $response = $this->common->updatedatamodel("ExtraSessions", $id, $data);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Extra session has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/extrasessions'));
  }
  
  public function deleteExtrasession()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('ExtraSessions', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Extra session deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/extrasessions'));
	}

  public function badges()
  {
    $data["badges"] = $this->common->readdatafromcollectionbetween("Badges");
    $data['active'] = 'badges';
    $this->template->template_render('badges', $data);
  }

  public function addbadge($id=null)
  {
    $data['badge'] = null;
    $data['id'] = '';
    $data['active'] = 'badges';

    if($id){
      $data['badge'] = $this->common->readdatadocument('Badges', $id);
      $data['id'] = $id;
    }

    // var_dump($data['music']);die;

    $this->template->template_render('addbadge', $data);
  }

  public function insertbadge()
  {
    $post = $this->input->post();
    $data['xpThreshold'] = $post['xpThreshold'];
    // $data['forgivenessDays'] = $post['forgivenessDays'];

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();
    
    $image = '';
    if (
        isset($_FILES['image']) &&
        $_FILES['image']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['image']['tmp_name'])
    ) {
        $file_name = 'Badges/' . time() . basename($_FILES['image']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['image']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $image = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['image'] = $image;

    $response = $this->common->addnewdatamodel('Badges', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Badge added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/badges'));
  }

  public function updatebadge()
  {
    $post = $this->input->post();
    $id = $post['id'];
    $data['xpThreshold'] = $post['xpThreshold'];
    // $data['forgivenessDays'] = $post['forgivenessDays'];

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $image = '';
    if (
        isset($_FILES['image']) &&
        $_FILES['image']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['image']['tmp_name'])
    ) {
        $file_name = 'Badges/' . time() . basename($_FILES['image']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['image']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $image = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($image){

      $data['image'] = $image;
    }

    $response = $this->common->updatedatamodel("Badges", $id, $data);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Badge has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/badges'));
  }

  public function deleteBadge()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Badges', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Badge deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/badges'));
	}

  public function backmusic()
  {
    $data["musics"] = $this->common->readdatafromcollectionbetween("BackgroundMusic");
    $data['active'] = 'backmusic';
    
    $this->template->template_render('music', $data);
  }
  

  public function addmusic($id=null)
  {
    $data['music'] = null;
    $data['id'] = '';
    $data['active'] = 'backmusic';

    if($id){
      $data['music'] = $this->common->readdatadocument('BackgroundMusic', $id);
      $data['id'] = $id;
    }

    // var_dump($data['music']);die;

    $this->template->template_render('addmusic', $data);
  }

  public function insertmusic()
  {
    $post = $this->input->post();
    $data['title'] = $post['title'];
    // $data['createdDate'] = time()*1000;
    // $data['isActive'] = true;

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();
    
    $audioFile = '';
    if (
        isset($_FILES['music']) &&
        $_FILES['music']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['music']['tmp_name'])
    ) {
        $file_name = 'BackgroundMusic/' . time() . basename($_FILES['music']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['music']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audioFile = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audioFile'] = $audioFile;

    $response = $this->common->addnewdatamodel('BackgroundMusic', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Background music added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/backmusic'));
  }

  public function updatemusic()
  {
    $post = $this->input->post();
    $id = $post['id'];
    $data['title'] = $post['title'];

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $audioFile = '';
    if (
        isset($_FILES['music']) &&
        $_FILES['music']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['music']['tmp_name'])
    ) {
        $file_name = 'BackgroundMusic/' . time() . basename($_FILES['music']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['music']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audioFile = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audioFile){

      $data['audioFile'] = $audioFile;
    }

    $response = $this->common->updatedatamodel("BackgroundMusic", $id, $data);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Background music has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/backmusic'));
  }

  public function deleteMusic()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('BackgroundMusic', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Background music deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/backmusic'));
	}
  
//nexteddeletedatamodel
  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Settings has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
  {
    $data['users1'] = $this->common->readnumberofdocumentsincollectionbetween('Users');
    $data['users1'] = $data['users1']-1;
    $data['meditations'] = $this->common->readnumberofdocumentsincollection('Meditations');
    $data['backmusic'] = $this->common->readnumberofdocumentsincollection('BackgroundMusic');
    $data['active'] = 'dashboard';
   
    $users = $this->common->readdatafromcollectionwhereclause("Users");
    $data['users']=count($users);
    foreach ($users as $key => $user) {
        if ($user['email'] == 'admin@example.com') {
          continue;
        }
        $timestamps[$key]    = $user['memberSince'];
    }
    array_multisort($timestamps, SORT_ASC, $users);
    $labels = array();

    $labels[0] = date('F', strtotime(date('F')." - 3 months"));
    for($i =1; $i<=5; $i++) {
      $timestamp = strtotime($labels[$i-1].' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach($labels as $label) {
      $labelStr .= '"'.$label.'", ';
    }
    
    $data['labelStr'] = $labelStr;
    $dataStr = '';
    for($i =0; $i<count($labels); $i++) {
      $num = 0;
      foreach($timestamps as $timestamp) {
        if($labels[$i] == date('F', $timestamp/1000)) {
          $num += 0.2;
        }
      }
      $dataStr .= $num.',';
    }
    $data['dataStr'] = $dataStr;

    $videos = $this->common->readdatafromcollectionwhereclause("Videos");
    $data['videos2']=count($videos);
    foreach ($videos as $key => $video) {
       
        $timestamps[$key]    = $video['publishDate'];
    }
    array_multisort($timestamps, SORT_ASC, $videos);
    $labels = array();

    $labels[0] = date('F', strtotime(date('F')." - 3 months"));
    for($i =1; $i<=5; $i++) {
      $timestamp = strtotime($labels[$i-1].' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach($labels as $label) {
      $labelStr .= '"'.$label.'", ';
    }
    
    $data['labelStrVideo'] = $labelStr;
    $dataStr = '';
    for($i =0; $i<count($labels); $i++) {
      $num = 0;
      foreach($timestamps as $timestamp) {
        if($labels[$i] == date('F', $timestamp/1000)) {
          $num += 0.2;
        }
      }
      $dataStr .= $num.',';
    }
    $data['dataStrVideo'] = $dataStr;

   
    $this->template->template_render('dashboard', $data);
  }

  public function quotes()
	{

		$data['quotes'] = $this->common->readdatafromcollectionwhereclause('Quotes');
		$this->template->template_render('quotes', $data);
	}

  

  public function addQuote()
	{

		$this->template->template_render('addquote');
	}

  public function addcategory()
	{

		$this->template->template_render('addcategory');
	}

  public function insertquote()
	{
		
		$post = $this->input->post();
    $data['quote'] = $post['quote'];
    $data['createdDate'] = time()*1000;
    $data['isActive'] = true;
    $response = $this->common->addnewdatamodel('Quotes', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Quote added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/quotes'));		
	}

  public function editquote()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
		$data['quote'] = $this->common->readdatadocument('Quotes', $id);
    if(!$data['quote']){
      redirect(base_url('dashboard/quotes'));
    }
		$this->template->template_render('editquote', $data);
	}

  public function updatequote()
	{
    $post = $this->input->post();
    $data['quote'] = $post['quote'];

		$response = $this->common->updatedatamodel('Quotes', $post['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Quote updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/quotes'));
	}

  public function deletequote()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Quotes', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Quote deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/quotes'));
	}

  public function deleteQuestion()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->nexteddeletedatamodel('Journal', $_SESSION['type'], 'Questions', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Question deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/questions'));
	}

  public function deleteComment()
	{
    $videoId = $this->uri->segment(3);
    $commentId = $this->uri->segment(4);

 		$response = $this->common->nexteddeletedatamodel('Videos', $videoId, 'Comments', $commentId);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Comment deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/comments/'.$videoId));
	}

  public function deleteVideo()
	{
    $videoId = $this->uri->segment(3);

 		$response = $this->common->deletedatamodel('Videos', $videoId);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Video deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/reelzz'));
	}

  public function deleteReply()
	{
    $videoId = $this->uri->segment(3);
    $commentId = $this->uri->segment(4);
    $replyId = $this->uri->segment(5);

 		$response = $this->common->nexteddeletedatamodel2('Videos', $videoId, 'Comments', $commentId, 'reply', $replyId);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Reply deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/comments/'.$videoId));
	}

  

}