<?php
class Data_model extends CI_Model {

    public function get_dummy_data($range = 'day')
    {
        // Simulated dummy dataset
        $raw_data = [
            ['date' => '2025-06-01', 'type' => 'ride'],
            ['date' => '2025-06-01', 'type' => 'order'],
            ['date' => '2025-06-02', 'type' => 'ride'],
            ['date' => '2025-06-02', 'type' => 'order'],
            ['date' => '2025-06-03', 'type' => 'ride'],
            ['date' => '2025-06-04', 'type' => 'order'],
            ['date' => '2025-06-05', 'type' => 'ride'],
            ['date' => '2025-06-06', 'type' => 'ride'],
            ['date' => '2025-06-06', 'type' => 'order'],
            ['date' => '2025-06-10', 'type' => 'ride'],
            ['date' => '2025-06-12', 'type' => 'order'],
            ['date' => '2025-06-13', 'type' => 'ride'],
            ['date' => '2025-05-01', 'type' => 'ride'],
            ['date' => '2025-05-01', 'type' => 'order'],
            ['date' => '2025-05-02', 'type' => 'ride'],
            ['date' => '2025-05-02', 'type' => 'order'],
            ['date' => '2025-05-03', 'type' => 'ride'],
            ['date' => '2025-05-04', 'type' => 'order'],
            ['date' => '2025-05-05', 'type' => 'ride'],
            ['date' => '2025-05-06', 'type' => 'ride'],
            
        ];

        $grouped = [];

        foreach ($raw_data as $entry) {
            $timestamp = strtotime($entry['date']);
            switch ($range) {
                case 'week':
                    $period = date('Y-\WW', $timestamp); // e.g., 2025-W23
                    break;
                case 'month':
                    $period = date('Y-m', $timestamp); // e.g., 2025-06
                    break;
                default:
                    $period = date('Y-m-d', $timestamp);
            }

            if (!isset($grouped[$period])) {
                $grouped[$period] = ['rides' => 0, 'orders' => 0];
            }

            if ($entry['type'] == 'ride') {
                $grouped[$period]['rides']++;
            } else {
                $grouped[$period]['orders']++;
            }
        }

        $result = [];
        foreach ($grouped as $period => $counts) {
            $result[] = [
                'period' => $period,
                'rides' => $counts['rides'],
                'orders' => $counts['orders']
            ];
        }

        return $result;
    }
}