<?php
function floorDec($val, $precision = 2)
{
    if ($precision < 0) {
        $precision = 0;
    }
    $numPointPosition = intval(strpos($val, '.'));
    if ($numPointPosition === 0) { //$val is an integer
        return $val;
    }
    return floatval(substr($val, 0, $numPointPosition + $precision + 1));
}
?>

<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Dashboard</h2>
            </div>
        </div>
    </div>
    <div class="row column1">
        <div class="col-md-6 col-lg-3">
            <a href="<?=base_url('customer')?>">
                <div class="full counter_section margin_bottom_30">
                    <div class="couter_icon">
                        <div>
                            <i class="fa fa-user yellow_color"></i>
                        </div>
                    </div>
                    <div class="counter_no">
                        <div>
                            <!-- <p class="total_no"><?=$users1?></p> -->
                            <p class="total_no">0</p>
                            <p class="head_couter">Active Users</p>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-6 col-lg-3">
            <a href="<?=base_url('customer/drivers')?>">
                <div class="full counter_section margin_bottom_30">
                    <div class="couter_icon">
                        <div>
                            <i class="fa fa-users orange_color"></i>
                        </div>
                    </div>
                    <div class="counter_no">
                        <div>
                            <!-- <p class="total_no"><?=$users1?></p> -->
                            <p class="total_no">0</p>
                            <p class="head_couter">Drivers</p>
                        </div>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-6 col-lg-3">
            <a href="<?=base_url('customer/drivers')?>">
                <div class="full counter_section margin_bottom_30">
                    <div class="couter_icon">
                        <div>
                            <i class="fa fa-user-circle green_color"></i>
                        </div>
                    </div>
                    <div class="counter_no">
                        <div>
                            <!-- <p class="total_no"><?=$users1?></p> -->
                            <p class="total_no">0</p>
                            <p class="head_couter">Riders</p>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-6 col-lg-3">
            <a href="<?=base_url('dashboard/rides')?>">
                <div class="full counter_section margin_bottom_30">
                    <div class="couter_icon">
                        <div>
                            <i class="fa fa-subway" style="color: green;"></i>
                        </div>
                    </div>
                    <div class="counter_no">
                        <div>
                            <p class="total_no">0</p>
                            <p class="head_couter">Rides</p>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-6 col-lg-3">
            <a href="<?=base_url('dashboard/restaurants')?>">
                <div class="full counter_section margin_bottom_30">
                    <div class="couter_icon">
                        <div>
                            <i class="fa fa-utensils " style="color:cornflowerblue;"></i>
                        </div>
                    </div>
                    <div class="counter_no">
                        <div>
                            <p class="total_no">0</p>
                            <p class="head_couter">Restaurants</p>
                        </div>
                    </div>
                </div>
            </a>
        </div>


    </div>
    <div class="row column1">
        <div class="col-lg-12 col-md-12">
            <div class="white_shd full margin_bottom_30">
                <div class="full graph_head">
                    <div class="heading1 margin_0">
                        <h2>Rides and Orders by <span id="range-label">Day</span></h2>
                    </div>
                </div>
                <div class="map_section padding_infor_info">
                    <select id="range-select" class="form-control mb-3">
                        <option value="day">Day View</option>
                        <option value="week">Week View</option>
                        <option value="month">Month View</option>
                    </select>
                    <canvas id="ridesOrdersChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    <!-- <div class="row column1">
        <div class="col-lg-12 col-md-12">
            <div class="white_shd full margin_bottom_30">
                <div class="full graph_head">
                    <div class="heading1 margin_0">
                        <h2>User Signup Trend</h2>
                    </div>
                </div>
                <div class="map_section padding_infor_info">
                    <canvas id="line_chart"></canvas>
                </div>
            </div>
        </div>
    </div>


    <div class="row column1">
        <div class="col-lg-12 col-md-12">
            <div class="white_shd full margin_bottom_30">
                <div class="full graph_head">
                    <div class="heading1 margin_0">
                        <h2>Reelzz Trends</h2>
                    </div>
                </div>
                <div class="map_section padding_infor_info">
                    <canvas id="reelzzChart"></canvas>
                </div>
            </div>
        </div>
    </div> -->
    <!-- <div class="row column1">
        <div class="col-lg-12 col-md-12">
            <div class="white_shd full margin_bottom_30">
                <div class="full graph_head">
                    <div class="heading1 margin_0">
                        <h2>Comments Trends</h2>
                    </div>
                </div>
                <div class="map_section padding_infor_info">
                    <canvas id="commentsChart"></canvas>
                </div>
            </div>
        </div>
    </div> -->



</div>