<!-- DataTables CSS -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
<style>
video {
    width: 100%
}

table {
    width: 100%;
    border-collapse: collapse;
}

td,
th {
    padding: 8px;
    text-align: left;
}

.fw-bold {
    font-weight: 700;
    color: #000;

}

.dt-buttons {
    margin: 1rem;
}

.dataTables_filter {
    margin: 1rem;
}

@media (max-width: 768px) {

    /* Change table layout to block on small screens */
    table,
    thead,
    tbody,
    th,
    td,
    tr {
        display: block;
    }

    /* Hide the table headers */
    thead tr {
        display: none;
    }

    /* Display each row as a card */
    tr {
        margin-bottom: 8px;
        border-bottom: 2px solid #bbb;
    }

    /* Label each cell for clarity */
    .sort-button {
        font-size: 12px;
        cursor: pointer;
        margin-left: 5px;

    }
}
</style>
<!-- Begin Page Content -->
<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Reported Comments & Replies</h2>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <!-- <h6 class="m-0 font-weight-bold text-primary">DataTables Example</h6> -->
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped" id="reelzzTable">
                    <thead class="thead-dark">
                        <tr>
                            <th>Comment/Reply</th>
                            <th>Reported As</th>
                            <th>Reported By</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($reports)) {



                            $count = 1;
                            foreach ($reports as $id => $report) {
                                
                        ?>

                        <tr>

                            <td>
                                <?php echo $report['comment']; ?>
                            </td>
                            <td>
                                <?php echo $report['reason']; ?>
                            </td>
                            <td>
                                <?php echo $report['userName']; ?>
                            </td>


                            <td>

                                <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($id); ?>','Video', 'deleteReport');">Delete</button>

                            </td>
                        </tr>

                        <?php
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="post" action="<?= base_url('customer/sendWarning') ?>">
        <input id="user-id" type="hidden" name="userid" value="" />
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Send Warning to "<spna id="user-name"></spna>"
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form>

                        <div class="form-group">
                            <label for="message-text" class="col-form-label">Warning Message:</label>
                            <textarea class="form-control" id="message-text" rows="5" name="message" required></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Send Warning</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="get" name="cform" action="">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel2"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn"></button>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
function showModal(userid, username) {
    document.getElementById('user-name').innerText = username;
    document.getElementById('user-id').value = userid;
}

function showConfirmation(userid, username, action) {
    let url = "";
    let message = "";
    let btnTitle = "";
    switch (action) {
        case 'deleteReport':
            url = "<?php echo base_url(); ?>dashboard/deleteReport/" + userid;
            message = "Are you sure you want to delete this comment?";
            btnTitle = "Delete Comment";
            break;
        case 'deleteImage':
            url = "<?php echo base_url(); ?>customer/deleteImage/" + userid;
            message = "Are you sure you want to remove profile phot of user '" + username + "'?";
            btnTitle = "Remove Profile Photo";
            break;
        case 'banCustomer':
            url = "<?php echo base_url(); ?>customer/banCustomer/" + userid;
            message = "Are you sure you want to ban user '" + username + "'?";
            btnTitle = "Ban User";
            break;
        case 'unBanCustomer':
            url = "<?php echo base_url(); ?>customer/unBanCustomer/" + userid;
            message = "Are you sure you want to Unbanned user '" + username + "'?";
            btnTitle = "Unban User";
            break;
        case 'suspendCustomer':
            url = "<?php echo base_url(); ?>customer/suspendCustomer/" + userid;
            message = "Are you sure you want to deactivate user '" + username + "'?";
            btnTitle = "Deactivate User";
            break;
        case 'unSuspendCustomer':
            url = "<?php echo base_url(); ?>customer/unSuspendCustomer/" + userid;
            message = "Are you sure you want to activate user '" + username + "'?";
            btnTitle = "Activate User";
            break;
        case 'deleteCustomer':
            url = "<?php echo base_url(); ?>customer/remove/" + userid + "/user";
            message = "Are you sure you want to delete user '" + username + "'?";
            btnTitle = "Delete User";
            break;
        default:
            return false;
    }

    document.getElementById('exampleModalLabel2').innerText = message;
    document.getElementById('submitBtn').innerText = btnTitle;
    document.cform.action = url;
}
</script>
<!-- jQuery and DataTables JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

<!-- <script>
$(document).ready(function() {
    $('#reelzzTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
});
</script> -->

<script>
// Initialize DataTables
$(document).ready(function() {
    $('#reelzzTable').DataTable();
});

// Custom sorting function
function sortTable(columnIndex) {
    var table = $('#reelzzTable').DataTable();
    var currentOrder = table.order();

    // Toggle sorting order based on current state
    if (currentOrder[0][0] === columnIndex) {
        // Reverse the order if already sorted on this column
        var newOrder = currentOrder[0][1] === 'asc' ? 'desc' : 'asc';
        table.order([columnIndex, newOrder]).draw();
    } else {
        // Sort in ascending order if sorting for the first time
        table.order([columnIndex, 'asc']).draw();
    }
}
</script>