<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Chart.js Time Filter</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body>

    <div>
        <button onclick="updateChart('daily')">Daily</button>
        <button onclick="updateChart('weekly')">Weekly</button>
        <button onclick="updateChart('monthly')">Monthly</button>
    </div>

    <canvas id="myChart" width="600" height="300"></canvas>

    <script>
    const ctx = document.getElementById('myChart').getContext('2d');

    const datasets = {
        daily: {
            labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            data: [12, 19, 3, 5, 2, 3, 7]
        },
        weekly: {
            labels: ['Week 1', 'Week 2', 'Week 3', 'Week 4'],
            data: [40, 60, 35, 70]
        },
        monthly: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May'],
            data: [200, 250, 180, 300, 275]
        }
    };

    const config = {
        type: 'line',
        data: {
            labels: datasets.daily.labels,
            datasets: [{
                label: 'Sample Data',
                data: datasets.daily.data,
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 2,
                fill: false
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    };

    const myChart = new Chart(ctx, config);

    function updateChart(range) {
        myChart.data.labels = datasets[range].labels;
        myChart.data.datasets[0].data = datasets[range].data;
        myChart.update();
    }
    </script>

</body>

</html>